export default ($this) => {
  return [
    {
      formType: 'div',
      name: ' MRS评分',
      className: 'sec-title',
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title',
      prop: 'assessTime',
      model: 'assessTime',
      placeholder: '请选择',
      label: '评估时间：',
      format: 'yyyy-MM-dd',
      valueFormat: 'yyyy-MM-dd',
      dateType: 'date',
      type: 'date',
      rules: [{ required: true, message: '请选择评估时间', trigger: ['submit','change'] }],
      spanNum: 6,
    },
    {
      formType: 'radio',
      className: 'obj-form-title radio-block',
      prop: 'symptomScore',
      model: 'symptomScore',
      label: '评分值：',
      disabled: false,
      spanNum: 24,
      options: [
        { label: '0（完全无症状）', value: '0（完全无症状）', disabled: false },
        { label: '1（尽管有症状，但无明显功能障碍，能完成所有日常工作和生活）', value: '1（尽管有症状，但无明显功能障碍，能完成所有日常工作和生活）', disabled: false },
        { label: '2（轻度残疾，不能完成病前所有活动，但不需帮助能照顾自己的日常生活）', value: '2（轻度残疾，不能完成病前所有活动，但不需帮助能照顾自己的日常生活）', disabled: false },
        { label: '3（中度残疾，需部分帮助，但能独立行走）', value: '3（中度残疾，需部分帮助，但能独立行走）', disabled: false },
        { label: '4（重度残疾，不能独立行走，无他人帮助不能满足自身日常生活需求）', value: '4（重度残疾，不能独立行走，无他人帮助不能满足自身日常生活需求）', disabled: false },
        { label: '5（严重残疾，持续卧床、二便失禁，需持续护理和关注，日常生活完全依赖他人）', value: '5（严重残疾，持续卧床、二便失禁，需持续护理和关注，日常生活完全依赖他人）', disabled: false },
      ],
      rules: [{ required: true, message: '请选择评分值', trigger: ['submit','change'] }],
      changeFun: (e)=>{
        // console.log(e)
      }
    },


  ]
}
