import fetch from '../fetch';
import { getBaseUrl, getSaasDomain, getSaasApiDomain } from '@/utils/index'
let headers = {
'Content-Type': 'application/json;charset=UTF-8',
token: localStorage.getItem('storageToken'),
};

export const getCircleInfoReq = (id) => {
return fetch({
headers,
url: getBaseUrl(`circle/circle/${id}/info`),
method: 'get',
description: '获取圈子详情',
})
};
export const getCircleProvincesReq = (idType) => {
return fetch({
headers,
url: getBaseUrl(`circle/memberSelect/provinces/idType/${idType}`),
method: 'get',
description: '根据用户ID 获取选人时省市',
})
};
export const getMemberSelectOrgReq = (data) => {
return fetch({
headers,
url: getBaseUrl(`circle/memberSelect/org/search`),
method: 'post',
data: data,
description: '圈子设置查询机构列表',
})
};
export const getMemberSelectOrgOptionReq = (data) => {
  return fetch({
  headers,
  url: getBaseUrl(`circle/memberSelect/org/option`),
  method: 'post',
  data: data,
  description: '圈子设置勾选操作',
  })
  };
  export const getMemberSelectOrgSaveReq = (data) => {
    return fetch({
    headers,
    url: getBaseUrl(`circle/memberSelect/org/save`),
    method: 'post',
    data: data,
    description: ' 圈子设置选择机构保存',
    })
    };




export const getOrgProvincesReq = (idType,circleId,type=1) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/memberSelect/provinces/idType/${idType}/${circleId}/${type}`),
    method: 'get',
    description: '根据用户ID圈子id 获取选人时省市',
  })
};

export const getCircleRole = (circleId) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/circle/auth/${circleId}`),
    method: 'get',
    description: '根据圈子 获取人的角色',
  })
};

export const getTotalNumber = (data) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/memberSelect/orgPeopleTotal/related/search`),
    method: 'post',
    data: data,
    description: '查询已选机构、人员',
  })
};

export const getExpertList = (circleId) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/kol/admin/circleId/${circleId}/list`),
    method: 'get',
    description: '获取kol配置、专家列表',
  })
};

export const getExperNametList = (circleId, name) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/kol/admin/circleId/${circleId}/queryName/${name}`),
    method: 'get',
    description: '添加专家关联-获取专家下拉',
  })
};

export const saveKolConfig = (data) => {
  return fetch({
    headers,
    url: getBaseUrl(`circle/kol/admin/save`),
    method: 'post',
    data: data,
    description: 'KOL管理tab保存',
  })
};
