import { checkRange, checkIsInteger, checkNumberIsToFixed } from '@/utils/followup/followupUtils/checkField';

export default ($this) => {
  return [
    {
      formType: 'input',
      className: 'float-none',
      prop: 'reason',
      model: 'reason',
      label: '原因：',
      disabled: false,
      placeholder: '请输入原因',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      rules: [{required: false, message: '请输入原因', trigger: ['submit','change','blur']}],
      changeFun: (val)=>{
        let flag = val ? true : false;
        $this.addComponents.forEach((item,index)=>{
          if(item.name == 'hypeDataSourceReferral'){
            $this.addComponents[index].dataSource.forEach((item,index2)=>{
              if($this.addComponents[index].dataSource[index2].rules){
                $this.addComponents[index].dataSource[index2].rules[0].required = flag;
              }
            })
          }
        })
      },
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'mechanism',
      model: 'mechanism',
      label: '机构：',
      disabled: false,
      placeholder: '请输入机构',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      rules: [{required: false, message: '请输入机构', trigger: ['submit','change','blur']}],
      changeFun: (val)=>{
        let flag = val ? true : false;
        $this.addComponents.forEach((item,index)=>{
          if(item.name == 'hypeDataSourceReferral'){
            $this.addComponents[index].dataSource.forEach((item,index2)=>{
              if($this.addComponents[index].dataSource[index2].rules){
                $this.addComponents[index].dataSource[index2].rules[0].required = flag;
              }
            })
          }
        })
      },
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'department',
      model: 'department',
      label: '科室：',
      disabled: false,
      placeholder: '请输入科室',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      rules: [{required: false, message: '请输入科室', trigger: ['submit','change','blur']}],
      changeFun: (val)=>{
        let flag = val ? true : false;
        $this.addComponents.forEach((item,index)=>{
          if(item.name == 'hypeDataSourceReferral'){
            $this.addComponents[index].dataSource.forEach((item,index2)=>{
              if($this.addComponents[index].dataSource[index2].rules){
                $this.addComponents[index].dataSource[index2].rules[0].required = flag;
              }
            })
          }
        })
      },
    },
  ]
}
