import "@babel/polyfill";
import Vue from 'vue'
import VueRouter from 'vue-router'
import routes from './router/router'
import store from './store/'
const mixins = require('@/utils/mixins');
import FastClick from 'fastclick'
import vueFilters from '@/utils/filter'
import '@/utils/toBlob';

// 引入ElementUI
import ElementUI from 'element-ui';
import 'element-ui/lib/theme-chalk/index.css';
//引入滚动加载分页
import infiniteScroll from 'vue-infinite-scroll'
import VueVideoPlayer from 'vue-video-player';
import 'video.js/dist/video-js.css';
// import pdf from 'vue-pdf'

Vue.use(infiniteScroll);
Vue.use(VueVideoPlayer);
// Vue.use(pdf);

// 可调试
// Vue.config.devtools = true;
// Vue.use(Logger, { prefix: new Date(), isDev: process.env.NODE_ENV === 'development', cLevel: 'debug' })

Vue.use(ElementUI)

// 注册所有公用过滤器
for(let key in vueFilters) {
	Vue.filter(key, vueFilters[key])
}

if ('addEventListener' in document) {
    document.addEventListener('DOMContentLoaded', function() {
        FastClick.attach(document.body);
    }, false);
}

Vue.use(VueRouter)
const router = new VueRouter({
	routes,
	mode: 'hash',
	strict: process.env.NODE_ENV !== 'production',
	scrollBehavior (to, from, savedPosition) {
	    if (savedPosition) {
		    return savedPosition
		} else {
			if (from.meta.keepAlive) {
				from.meta.savedPosition = document.body.scrollTop;
			}
		    return { x: 0, y: to.meta.savedPosition || 0 }
		}
	}
})

import utils from '@/utils/followup/followupUtils';
router.beforeEach((to, from, next) => {
  if(to.meta.checkAuth){
    utils.checkAuthFunc().then(res=>{
      if(res==3){
      	if(to.meta.doctorAuth){
      		utils.getDoctorAuth(router).then(resAuth=>{
	        	if(resAuth==3){
	        		next()
	        	}else{
	        		next(false)
	        		return
	        	}
	        })
	        return
      	}
        next();
      }else{
        next(false)
        return
      }
    })
    return
  }
  next()
});

// 加入混合
Vue.mixin({
	...mixins
})
new Vue({
	router,
	store,
}).$mount('#app')

