import fetch from '../fetch';
import { getFollowUpApi, getBasicDataApi, getFollowUpSC } from '@/utils/index'

import utils from './followupUtils';



/*计划管理API*/
const  planManageApi = [
  {
    url: '/followup/plans',
    method: 'get',
    params: 'params',
    name: 'getPlanList',
    description: '获取计划列表',
  },
  {
    url: '/plans/',
    method: 'get',
    params: 'params',
    name: 'getPlanDetail',
    description: '获取计划详情',
  },
  {
    url: '',
    method: 'get',
    params: 'params',
    name: 'getNodeTimeList',
    description: '获取随访时间节点列表',
  },
  {
    url: '/plans/time/',
    method: 'get',
    params: 'params',
    name: 'getNodeTimeContent',
    description: '获取节点详情',
  },
  {
    url: '/followup/planPatient/',
    method: 'get',
    params: 'params',
    name: 'getResidentList',
    description: '获取居民列表',
  },
  {
    url: '/followup/planPatient/group',
    method: 'get',
    params: 'params',
    name: 'getGroupList',
    description: '获取分组列表',
  },
  {
    url: '/followup/planPatient/detail',
    method: 'get',
    params: 'params',
    name: 'getResidentDetail',
    description: '获取居民详情',
  },
  {
    url: '/followup/planPatient/change',
    method: 'put',
    params: 'params',
    name: 'changePlan',
    description: '变更计划',
  },
];

/*预约管理API*/
const reservationManageApi = [
  {
    url: '/followup/appointmentPatient/',
    method: 'get',
    params: 'params',
    name: 'getReservationList',
    description: '获取预约列表',
  },
  {
    url: '/followup/appointmentPatient/check/',
    method: 'get',
    params: 'params',
    name: 'getCheckReservation',
    description: '发送预约校验',
  },
  {
    url: '/followup/appointmentPatient/accept/',
    method: 'get',
    params: 'params',
    name: 'getReservationPatients',
    description: '查看预约人数',
  },
  {
    url: '/appoint/status/',
    method: 'post',
    params: 'data',
    name: 'changeReservationStatus',
    description: '手动变更预约状态',
  },
  {
    url: '/appoint',
    method: 'post',
    params: 'data',
    name: 'sendReservation',
    description: '发送预约',
  },
]

/*工作台*/
const workbenchApi = [
  {
    url: '/overView/todayAppoints',
    method: 'get',
    params: 'params',
    name: 'getTodayAppointsListSC',
    description: '获取今日预约列表',
  },
  {
    url: '/overView/todayOverview',
    method: 'get',
    params: 'params',
    name: 'getTodayOverviewSC',
    description: '获取今日随访、预约、随访人数',
  },
  {
    url: '/overView/todayPlans',
    method: 'get',
    params: 'params',
    name: 'getTodayPlansSC',
    description: '查询今日随访计划',
  },
]

/*常量API*/
const basicDataApi = [
  {
    url: '/overView/todayAppoints',
    method: 'get',
    params: 'params',
    name: 'getBasicData',
    description: '获取常量',
  },
]

/*录入管理API*/
const recordManageApi = [
  {
    url: '/followup/entering/list',
    method: 'post',
    params: 'data',
    name: 'getEnteringList',
    description: '录入列表查看',
  },
  {
    url: '/followup/entering/status/change',
    method: 'post',
    params: 'data',
    name: 'changeEnteringStatus',
    description: '变更随访状态',
  },
  {
    url: ``,
    method: 'get',
    params: 'params',
    name: 'getEnteringInfo',
    description: '随访单条信息查看',
  },
]



const api = {};
const apis = [...planManageApi, ...reservationManageApi, ...basicDataApi, ...workbenchApi, ...recordManageApi];

apis.forEach(item => api[item.name] = (params = {}, extraConfig = {}) => {
  // const config = {
  //   url: getFollowUpApi(item.url),
  //   method: item.method,
  // };
  let config = {};
  if (item.name == 'getBasicData') {
     config = {
      url: getBasicDataApi(item.url),
      method: item.method,
    };
  } else if (item.name == 'getNodeTimeList') {
    let url = `/plan/${extraConfig.urlSuffix}/time`
    config = {
      url: getFollowUpApi(url),
      method: item.method,
    };
  } else if (item.name.indexOf("SC")!=-1) {
    config = {
      url: getFollowUpSC(item.url),
      method: item.method,
    };
  } else if (item.name == 'getEnteringInfo') {
    let url = `/followup/entering/${extraConfig.patientId}/fuInfo/${extraConfig.fuPlanPatientTimesId}`
    config = {
      url: getFollowUpApi(url),
      method: item.method,
    };
  } else {
    config = {
      url: getFollowUpApi(item.url),
      method: item.method,
    };
  }

  if (extraConfig.urlSuffix) { // 需要做URL拼接的情况(比如*.do/2),,,可以根据自己的实际情况进行扩展
    config.url = `${config.url}${extraConfig.urlSuffix}`;
    //something else
  }
  const filterParams = utils.DC.getParams(params, item.args);
  if (item.params === 'data') {
    config.data = filterParams;
  } else {
    config.params = filterParams;
  }

  /*utils.MSG.$emit('axios:begin', item.url);*/
  return fetch({
    ...config,
    ...extraConfig,
  }).then(res => {
    return Promise.resolve(res);
  }).catch(err => {
    return Promise.resolve(err);
  });
});

export default api;
