const followUp = (r) =>
  require.ensure(
    [],
    () => r(require('../views/followup/layout.vue')),
    'followUp'
  )
/*计划*/
const planManage = (r) =>
  require.ensure(
    [],
    () => r(require('../views/followup/plan-manage/layout.vue')),
    'planManage'
  )
const planList = (r) =>
  require.ensure(
    [],
    () => r(require('../views/followup/plan-manage/plan-list.vue')),
    'planList'
  )
const planDetail = (r) =>
  require.ensure(
    [],
    () => r(require('../views/followup/plan-manage/plan-detail.vue')),
    'planDetail'
  )
const planModify = (r) =>
  require.ensure(
    [],
    () => r(require('../views/followup/plan-manage/plan-modify.vue')),
    'planModify'
  )
const residentList = (r) =>
  require.ensure(
    [],
    () => r(require('../views/followup/plan-manage/resident-list.vue')),
    'residentList'
  )
const residentDetail = (r) =>
  require.ensure(
    [],
    () => r(require('../views/followup/plan-manage/resident-detail.vue')),
    'residentDetail'
  )
const newPlan = (r) =>
  require.ensure(
    [],
    () => r(require('../views/followup/plan-manage/new-plan.vue')),
    'newPlan'
  )

/*预约*/
const reservationManage = (r) =>
  require.ensure(
    [],
    () => r(require('../views/followup/reservation-manage/layout.vue')),
    'reservationManage'
  )
const reservationList = (r) =>
  require.ensure(
    [],
    () =>
      r(require('../views/followup/reservation-manage/reservation-list.vue')),
    'reservationList'
  )

/*录入*/
const recordManage = (r) =>
  require.ensure(
    [],
    () => r(require('../views/followup/record-manage/layout.vue')),
    'recordManage'
  )
const recordList = (r) =>
  require.ensure(
    [],
    () => r(require('../views/followup/record-manage/record-list.vue')),
    'recordList'
  )
const formTemplate = (r) =>
  require.ensure(
    [],
    () => r(require('../views/followup/record-manage/form-template.vue')),
    'formTemplate'
  ) //量表模板

const followRouters = {
  path: '/followup',
  name: 'followUp',
  component: followUp,
  redirect: 'followup/plan-manage/planList',
  children: [
    {
      path: 'plan-manage',
      component: planManage,
      name: 'planManage',
      redirect: 'plan-manage/plan-list',
      children: [
        {
          path: 'plan-modify',
          component: planModify,
          name: 'planModify',
          meta: {
            title: '修改计划',
            keepAlive: false, //页面不需要缓存
          },
        },
        {
          path: 'plan-detail',
          component: planDetail,
          name: 'planDetail',
          meta: {
            title: '查看计划',
            keepAlive: false, //页面不需要缓存
          },
        },
        {
          path: 'plan-list',
          component: planList,
          name: 'planList',
          meta: {
            title: '计划列表',
            keepAlive: false, //页面不需要缓存
          },
        },
        {
          path: 'resident-list',
          component: residentList,
          name: 'residentList',
          meta: {
            title: '居民列表',
            keepAlive: false, //页面不需要缓存
          },
        },
        {
          path: 'resident-detail',
          component: residentDetail,
          name: 'residentDetail',
          meta: {
            title: '居民详情',
            keepAlive: false, //页面不需要缓存
          },
        },
        {
          path: 'new-plan',
          component: newPlan,
          name: 'newPlan',
          meta: {
            title: '新建履约计划',
            keepAlive: false, //页面不需要缓存
          },
        },
      ],
      meta: {
        title: '计划管理',
        checkAuth: true,
      },
    },
    {
      path: 'reservation-manage',
      component: reservationManage,
      name: 'reservationManage',
      redirect: 'reservation-manage/reservation-list',
      children: [
        {
          path: 'reservation-list',
          component: reservationList,
          name: 'reservationList',
          meta: {
            title: '预约列表',
            keepAlive: false,
          },
        },
      ],
      meta: {
        title: '预约管理',
        checkAuth: true,
      },
    },
    {
      path: 'record-manage',
      component: recordManage,
      name: 'recordManage',
      redirect: 'record-manage/record-list',
      children: [
        {
          path: 'record-list',
          component: recordList,
          name: 'recordList',
          meta: {
            title: '录入列表',
            keepAlive: false,
          },
        },
        {
          path: 'form-template',
          component: formTemplate,
          name: 'formTemplate',
          meta: {
            title: '录入量表',
            keepAlive: false,
          },
        },
      ],
      meta: {
        title: '录入管理',
        checkAuth: true,
      },
    },
  ],
}

export default followRouters
