import {
  getPlanList,
  getPlanDetail,
  getNodeTimeList,
  getNodeTimeContent,
  getResidentList,
  getGroupList,
  getResidentDetail,
  getBasicData,
  getFormOptions,
  getFollowupTemplate,
  createFollowPlan,
  getFollowStartTimeList,
} from '../../utils/followup/followapis'

export default {
  namespaced: true,
  state: {
    residentList: {
      //居民列表
      pageNum: 1, //当前页码
      pageSize: 10, //每页数据大小
      total: null, //总数
    },
    groupList: [], //分组列表
    residentDetail: {}, //居民详情,
    planDetail: {}, // 计划详情页,
    nodeTimeList: [], //履约时间节点列表,
    nodeContent: {}, //时间节点详情
    planOption: [], //履约计划select
    timeNodeList: [],
    setTimeNodeList: [], //新建计划设置时间节点
    planList: {}, //履约计划列表
    remarkOption: [], //履约计划备注常量
    markOptions: [], //履约 履约时间节点单位 常量
    followTypeList: [], //履约 履约方式 常量
    remindOptions: [], //履约 提醒医生天数 常量
    pushTimeOptions: [], //履约 推送患教提醒天数 常量
    planStatusOption: [], //履约计划状态常量
    formOptions: [], // 获取量表
    templateOptions: [
      // 获取履约计划模板
      {
        id: 0,
        name: '自定义模板',
      },
    ],
    followStartTimeList: [], //履约时间
    residentCrumb: [], //居民面包屑
    planModifyCrumb: [], //修改计划面包屑
    selectResidentList: [], //修改计划已选居民
  },
  mutations: {
    GET_RESIDENT_LIST(state, payload) {
      state.residentList = payload
    },
    GET_GROUP_LIST(state, payload) {
      state.groupList = payload
    },
    GET_FOLLOW_START_TIME_LIST(state, payload) {
      state.followStartTimeList = payload
    },
    GET_RESIDENT_DETAIL(state, payload) {
      state.residentDetail = payload
      state.timeNodeList = payload.fPlanDto.fPlanTimeReqList
    },
    GET_PLAN_DETAIL(state, payload) {
      state.planDetail = payload
    },
    GET_REMARK_OPTION(state, payload) {
      state.remarkOption = payload.P211
    },
    GET_DATE_UNIT(state, payload) {
      state.markOptions = payload.P017
    },
    GET_FOLLOW_TYPE_LIST(state, payload) {
      state.followTypeList = payload.P212
    },
    GET_REMIND_OPTIONS(state, payload) {
      state.remindOptions = payload.P213
    },
    GET_PUSH_TIME_OPTIONS(state, payload) {
      state.pushTimeOptions = payload.P214
    },
    GET_PLAN_STATUS_OPTION(state, payload) {
      state.planStatusOption = payload.P216
    },
    GET_NODE_TIME_LIST(state, payload) {
      state.nodeTimeList = payload
    },
    GET_NODE_CONTENT(state, payload) {
      state.nodeContent = payload
    },
    GET_PLAN_OPTION(state, payload) {
      state.planOption = payload.fPlanDtoList
    },
    SET_TIME_NODE_LIST(state, payload) {
      state.setTimeNodeList = payload
    },
    GET_PLAN_LIST(state, payload) {
      state.planList = payload
    },
    GET_FORM_OPTIONS(state, payload) {
      state.formOptions = payload
    },
    GET_FOLLOW_TEMPLATE(state, payload) {
      state.templateOptions = [
        {
          id: 0,
          name: '自定义模板',
        },
      ]
      state.templateOptions = state.templateOptions.concat(payload)
    },
    SET_RESIDENT_CRUMB(state, payload) {
      state.residentCrumb = payload
      sessionStorage.setItem(
        'residentCrumb',
        JSON.stringify(state.residentCrumb)
      )
    },
    SET_PLAN_MODIFY_CRUMB(state, payload) {
      state.planModifyCrumb = payload
      sessionStorage.setItem(
        'planModifyCrumb',
        JSON.stringify(state.planModifyCrumb)
      )
    },
    GET_SELECT_RESIDENT(state, payload) {
      state.selectResidentList = payload.fPlanPatientInfoDtoList
    },
  },
  actions: {
    setFollowPlan(context, payload) {
      createFollowPlan({
        ...payload,
      }).then(({ data }) => {
        // console.log('成功',data)
      })
    },
    getResidentList(context, payload) {
      const { pageSize, pageNum } = context.state.residentList
      getResidentList({
        pageSize,
        pageNum,
        ...payload,
      }).then(({ data }) => {
        context.commit('GET_RESIDENT_LIST', data)
        context.dispatch('getSelectResident', {
          planId: payload.planId,
        })
      })
    },
    getGroupList(context, payload) {
      getGroupList({}).then(({ data }) => {
        context.commit('GET_GROUP_LIST', data)
      })
    },
    getFollowStartTimeList(context, payload) {
      getFollowStartTimeList(payload).then(({ data }) => {
        context.commit('GET_FOLLOW_START_TIME_LIST', data)
      })
    },
    getResidentDetail(context, payload) {
      getResidentDetail(
        payload.planId,
        payload.patientId,
        payload.fuPlanPatientId
      ).then(({ data }) => {
        context.commit('GET_RESIDENT_DETAIL', data)
      })
    },
    getPlanDetail(context, payload) {
      getPlanDetail(payload).then(({ data }) => {
        context.commit('GET_PLAN_DETAIL', data)
        context.dispatch('getSelectResident', {
          planId: data.id,
        })
      })
    },
    getRemarkOption(context, payload) {
      getBasicData({
        numList: 'P211',
      }).then(({ data }) => {
        context.commit('GET_REMARK_OPTION', data)
      })
    },
    getDateUnit(context, payload) {
      // 履约时间节点单位
      getBasicData({
        numList: 'P017',
      }).then(({ data }) => {
        context.commit('GET_DATE_UNIT', data)
      })
    },
    getFollowTypeList(context, payload) {
      // 履约方式
      getBasicData({
        numList: 'P212',
      }).then(({ data }) => {
        context.commit('GET_FOLLOW_TYPE_LIST', data)
      })
    },
    getRemindOptions(context, payload) {
      // 提醒医生天数
      getBasicData({
        numList: 'P213',
      }).then(({ data }) => {
        context.commit('GET_REMIND_OPTIONS', data)
      })
    },
    getPushTimeOptions(context, payload) {
      // 推送患教提醒天数
      getBasicData({
        numList: 'P214',
      }).then(({ data }) => {
        context.commit('GET_PUSH_TIME_OPTIONS', data)
      })
    },
    getFormOptions(context, payload) {
      // 获取量表
      getFormOptions().then(({ data }) => {
        context.commit('GET_FORM_OPTIONS', data)
      })
    },
    getFollowupTemplate(context, payload) {
      // 获取履约模板
      getFollowupTemplate().then(({ data }) => {
        context.commit('GET_FOLLOW_TEMPLATE', data)
      })
    },
    getPlanStatusOption(context, payload) {
      getBasicData({
        numList: 'P216',
      }).then(({ data }) => {
        context.commit('GET_PLAN_STATUS_OPTION', data)
      })
    },
    getNodeTimeList(context, payload) {
      getNodeTimeList(payload).then(({ data }) => {
        context.commit('GET_NODE_TIME_LIST', data)
      })
    },
    getNodeTimeContent(context, payload) {
      getNodeTimeContent(payload).then(({ data }) => {
        context.commit('GET_NODE_CONTENT', data)
      })
    },
    getPlanOptions(context, payload) {
      getPlanList({
        pageNo: -1,
      }).then(({ data }) => {
        context.commit('GET_PLAN_OPTION', data)
      })
    },
    /*async changePlan(context, payload) {
      changePlan({
        ...payload
      }).then(({data}) => {
       return data
      });
    },*/
    getTimeNodeList(context, payload) {
      context.commit('SET_TIME_NODE_LIST', payload)
    },
    async getPlanList(context, payload) {
      await getPlanList({
        ...payload,
      }).then(({ data }) => {
        context.commit('GET_PLAN_LIST', data)
      })
    },
    setResidentCrumb(context, payload) {
      context.commit('SET_RESIDENT_CRUMB', payload)
    },
    setPlanModifyCrumb(context, payload) {
      context.commit('SET_PLAN_MODIFY_CRUMB', payload)
    },
    getSelectResident(context, payload) {
      getResidentList({
        needEnd: 1,
        ...payload,
      }).then(({ data }) => {
        context.commit('GET_SELECT_RESIDENT', data)
      })
    },
  },
}
