const checkBarcode = (rule, value, cb) => {
  const valedBarcode = new RegExp('[\\u4E00-\\u9FFF]+', 'g')
  if (value && valedBarcode.test(value)) cb(new Error('条形码不能输入中文'))
  cb()
}

const checkNumber = (rule, value, cb) => {
  const val = String(value)
  const isInt = /^([1-9][0-9]*)$/
  if (val && !isInt.test(val)) cb(new Error('请输入正整数'))
  cb()
}

const checkProjectStr = (rule, value, callback) => {
  if (value.indexOf('\\') != -1) {
    //存在
    callback(new Error('请勿输入字符“ \\ ”'))
  } else if (value.indexOf('.') != -1) {
    callback(new Error('请勿输入字符“ . ”'))
  } else {
    callback()
  }
}

const rules1 = {
  barCode: [
    { required: true, message: '请输入条形码', trigger: 'blur' },
    { validator: checkBarcode, trigger: 'blur' },
  ],
  medicCommonName: [
    { required: true, message: '请输入产品名称/通用名称', trigger: 'blur' },
  ],
  medicGoodsName: [
    {
      required: true,
      message: '请输入商品名称或品牌名/商品名',
      trigger: 'blur',
    },
  ],
  specifications: [{ required: true, message: '请输入规格', trigger: 'blur' }],
  productionCompany: [
    { required: true, message: '请输入生产企业', trigger: 'blur' },
  ],
  medicalCategoryId: [
    { required: true, message: '请选择药品分类', trigger: 'change' },
  ],
  approvalNumber: [
    { required: true, message: '请输入批准文号', trigger: 'blur' },
  ],
  // dosageId:[
  //   { required: true, message: "请选择剂型", trigger: "change" }
  // ],
  categoryIdLevel2: [
    { required: true, message: '请选择药品类型', trigger: 'blur' },
  ],
  categoryIdLevel3: [
    { required: true, message: '请选择一级类目', trigger: 'blur' },
  ],
  categoryIdLevel4: [
    { required: true, message: '请选择二级类目', trigger: 'blur' },
  ],
  categoryIdLevel5: [
    { required: true, message: '请选择三级类目', trigger: 'blur' },
  ],
  specification_url: [
    { required: true, message: '请上传药品说明书', trigger: 'blur' },
  ],
  // otc:[
  //   { required: true, message: "请选择是否是处方", trigger: "blur" }
  // ],
  dynamicFlag: [
    { required: true, message: '请选择内容发布权', trigger: 'blur' },
  ],
}

const rules2 = {
  // barCode: [
  //   { required: true, message: "请输入条形码", trigger: "submit" },
  //   { validator: checkBarcode, trigger: "submit" }
  // ],
  checkName: [{ required: true, message: '请输入检测名称', trigger: 'blur' }],
  hospitalName: [
    { required: true, message: '请输入医疗机构名称', trigger: 'blur' },
  ],
  hospitalType: [
    { required: true, message: '请选择医疗机构类型', trigger: 'blur' },
  ],
  checkItem: [{ required: true, message: '请输入检测项目', trigger: 'blur' }],
  checkStandard: [
    { required: true, message: '请输入检测指标', trigger: 'blur' },
  ],
  useCount: [
    { required: true, message: '请输入使用人数', trigger: 'submit' },
    { validator: checkNumber, trigger: 'submit' },
  ],
  checkType: [{ required: true, message: '请选择检测类型', trigger: 'blur' }],
  suitableArr: [{ required: true, message: '请选择适用人群', trigger: 'blur' }],
  endTime: [{ required: true, message: '请选择商品使用日期', trigger: 'blur' }],
  // goodsCheckImages: [
  //   { required: true, message: "请上传检测说明图", trigger: "blur" }
  // ],
}

const rules = {
  // barCode: [
  //   { required: true, message: "请输入条形码", trigger: "blur" },
  //   { validator: checkBarcode, trigger: "blur" },
  // ],
  optPrice: [{ required: true, message: '请输入价格', trigger: 'blur' }],
  realCostPrice: [{ required: true, message: '请输入价格', trigger: 'blur' }],
  saleType: [{ required: true, message: '请选择销售方式', trigger: 'change' }],
  stock: [{ required: true, message: '请输入库存', trigger: 'blur' }],
  minWhole: [{ required: true, message: '请输入最小起批', trigger: 'blur' }],
  expressLimitFlag: [
    {
      required: true,
      message: '请选择是否支持售后',
      trigger: 'change',
    },
  ],
}

const rules3 = {
  goodsName: [
    { required: true, message: '请输入商品名称', trigger: 'blur' },
    // { validator: checkProjectStr, trigger: "submit" },
  ],
  goodsDescription: [
    { required: true, message: '请输入商品介绍', trigger: 'blur' },
  ],
  goodsHeaderImages: [
    { required: true, message: '请上传商品头图', trigger: 'blur' },
  ],
  goodsCategoryIdList: [
    { required: true, message: '请选择商品分类', trigger: 'change' },
  ],
}

export const originRules1 = rules1
export const originRules2 = rules2
export const originRules3 = rules3
export const originRules = rules
