export default ($this) => {
  return [

    {
      formType: 'div',
      name: '4.3 出血性卒中外科治疗',
      className: 'sec-title',
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'haveSurgicalIntervention',
      model: 'haveSurgicalIntervention',
      label: '是否接受过出血性卒中外科干预：',
      disabled: false,
      spanNum: 24,
      options: [
        {label: '否', value: '否', disabled: false},
        {label: '是', value: '是', disabled: false},
      ],
      rules: [{required: true, message: '请选择是否', trigger: ['submit','change']}]
    },
    {
      formType: 'input',
      className: 'obj-form-title2',
      prop: 'treatmentMethod',
      model: 'treatmentMethod',
      label: '治疗方式：',
      linkageRule: [{name: 'haveSurgicalIntervention', value: ['是']}],
      disabled: false,
      placeholder: '请输入治疗方式',
      spanNum: 6,
      maxlength: 30,
      type: 'text',
      labmsg: '次',
      // slots: [{name: 'cm', type: 'append'}],
      rules: [{required: true, message: '请输入治疗方式', trigger: ['submit','change']}],
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title2',
      prop: 'treatmentTime',
      model: 'treatmentTime',
      placeholder: '请选择',
      label: '手术时间：',
      linkageRule: [{name: 'haveSurgicalIntervention', value: ['是']}],
      format: 'yyyy',
      valueFormat: 'yyyy',
      dateType: 'year',
      type: 'date',
      rules: [{required: true, message: '手术时间', trigger: ['submit','change']}],
      spanNum: 6
    },
  ]
}
