import { opAck } from '@/api/diagnosis';

export default {
    gotoInquiry({ commit }, current) {
        if (current.imTeamId) {
            const params = {
                teamIdList: [current.imTeamId]
            };
            opAck(params).then(res => {
                if (res.code == '000000') {
                    commit('updateShowChat', true);
                    commit('updateCurrentChat', current);
                }
            }).catch(err => {
                _VM.$message({
                    message: err.message,
                    type: 'warning',
                    duration: 1000
                });
            });

        }
    },
};