const common = {
    namespaced:true,
    state: {
        _token: '',
        isFromAssignTask: false,
        time:null,
    },
    getters: {
        _token: state => state.common._token,
        isFromAssignTask: state => state.common.isFromAssignTask,
        time:state => state.common.time,
    },
    mutations: {
        CHANGE_TOKEN: (state, data) => {
            state._token = data;
        },
        SET_IS_FROM_ASSIGN_TASK: (state, status) => {
            state.isFromAssignTask = status;
        },
        SET_TIME(state, data) {
          state.time = data;
        }
    },
    actions: {
        changeToken({ commit }, tokenData) {
            commit('CHANGE_TOKEN', tokenData);
        },
        changeTime({ commit }, tokenData) {
          commit('SET_TIME', tokenData);
        },

    }
};
export default common;
