import io from 'socket.io-client';
const socket = {
  namespaced: true,
  state: {
    socketClient: null,
  },
  actions: {
    initSocket(context, payload) {
      const socketClient = io.connect(payload.url, {
        query: {
          loginUserNum: `diagnose_list_socket_${payload.userId}`,
        },
        // reconnection: false,
      });
      console.log('-=-=-initSocket次数', socketClient);
      context.commit('SET_SOCKET', socketClient);
      socketClient.on('connect', (socket) => {
        console.log('socket 链接成功', socket, socketClient);
      });
      socketClient.on('connect_error', (err) => {
        console.log('socket connect_error', err);
        // state.socketClient.connect();
      });
      socketClient.on('disconnect', (socket) => {
        console.log('socket disconnect----', socket);
        // state.socketClient.connect();
      });
      socketClient.on('diagnose_push_event', (socket) => {
        const { list, allSize, countRespList } = socket;
        console.log('sdjfhsdjkfhsajkdfhasjkdfhasjk------------')
        context.commit('main/updateCurrentCalList', countRespList,{root:true});
        context.commit('updateCurrentDiagList', list);
        context.commit('updateAllSize', allSize);
        
        // context.commit('updateCurrentCalList', countRespList);
      });
      socketClient.on('diagnose_call_push_event', (socket) => {
        console.log('diagnose_call_push_event---', socket);
        const l = context.state.noticeList;
        if (l.length >= 5) {
          l.shift();
        }
        l.push(socket);
        const n = { notifyIndex: l.length, ...socket };
        context.commit('updateNoticeList', l);
        console.log('n--------', n);
        const { path } = window._VM.$route;
        const operateUserId = context.state.soketQuest.operateUserId
          ? context.state.soketQuest.operateUserId
          : '';
        if (
          path &&
          String(path).indexOf('workbench') > -1 &&
          n.operateUserId == operateUserId
        ) {
          context.commit('socket/SET_NOTIFY', context, n);
        }
      });
      socketClient.on('ping', function () {
        console.log('[E] 心跳请求已发出 →', socketClient);
      });
      // 收到
      socketClient.on('pong', function (socket) {
        console.log('[E] 心跳响应已收到 ←', socket, socketClient);
      });
      socketClient.io.on('reconnect_attempt', (socket) => {
        console.log('--reconnect_attempt', socket);
        // ...
      });

      socketClient.on('reconnect', (socket) => {
        console.log('--reconnect', socket);
        // ...
      });
      socketClient.on('reconnecting', (attemptNumber) => {
        // ...
        console.log('--reconnecting', attemptNumber);
      });
    },
  },
  mutations: {
    SET_SOCKET: (state, payload) => {
      window.socketClient = payload;
      state.socketClient = payload;
    },
    SET_NOTIFY: (state, context, payload) => {
      console.log('--payload', payload);
      const doms = document.getElementsByClassName('el-notification');
      if (doms.length >= 5) return;
      const h = window._VM.$createElement;

      const t = payload.department
        ? `问诊单${payload.diagnoseLogId}(${payload.department})`
        : `问诊单${payload.diagnoseLogId}`;
      // userCallKfStatus 医助呼叫
      // doctorCallKfStatus 医生呼叫
      const name =
        payload.userCallKfStatus == 1 ? payload.userName : payload.doctorName;
      const cn = window._VM.$notify({
        title: t,
        message: h('p', [
          h('i', { style: 'color: teal;' }, `${name}正在呼叫你`),

          h(
            'el-button',
            {
              style: `float:right;margin-top:${30}px;`,
              on: {
                click: function () {
                  console.log('----state', state);
                  if (state.showChat) {
                    window._VM.$message({
                      message:
                        '不可同时进入多个诊室，请先退出已进入的诊室，再试。',
                      type: 'warning',
                      duration: 1000,
                    });
                    return false;
                  }
                  context.dispatch('gotoInquiry', payload);
                  cn.close();
                },
              },
            },
            '进入诊室'
          ),
        ]),
        onClose: function () {
          console.log('--onClose', payload);
        },
        duration: 5000,
        position: 'top-right',
      });
    },
  },
};
export default socket;
