/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.spark.mllib;

import org.apache.spark.SparkContext;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.clustering.KMeansModel$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class KmeansModelSaveToOss$ {
    public static final KmeansModelSaveToOss$ MODULE$;
    private final String modelOssDir;

    static {
        new KmeansModelSaveToOss$();
    }

    public String modelOssDir() {
        return this.modelOssDir;
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().config("spark.hadoop.fs.oss.credentials.provider", "org.apache.hadoop.fs.aliyun.oss.AliyunStsTokenCredentialsProvider").config("spark.hadoop.fs.oss.ststoken.roleArn", "acs:ram::****:role/aliyunodpsdefaultrole").config("spark.hadoop.fs.oss.endpoint", "oss-cn-hangzhou-zmf.aliyuncs.com").appName("KmeansModelSaveToOss").getOrCreate();
        SparkContext sc = spark.sparkContext();
        Seq points = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.1})), Vectors$.MODULE$.dense(0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), Vectors$.MODULE$.dense(9.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), Vectors$.MODULE$.dense(9.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.2})), Vectors$.MODULE$.dense(9.2, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))}));
        RDD rdd = sc.parallelize(points, 3, ClassTag$.MODULE$.apply(Vector.class));
        String initMode = KMeans$.MODULE$.K_MEANS_PARALLEL();
        KMeansModel model = KMeans$.MODULE$.train(rdd, 2, 2, 1, initMode);
        String[] predictResult1 = (String[])rdd.map((Function1)new Serializable(model){
            public static final long serialVersionUID = 0L;
            private final KMeansModel model$1;

            public final String apply(Vector feature) {
                return new StringBuilder().append((Object)"cluster id: ").append((Object)BoxesRunTime.boxToInteger((int)this.model$1.predict(feature))).append((Object)" feature:").append((Object)Predef$.MODULE$.doubleArrayOps(feature.toArray()).mkString(",")).toString();
            }
            {
                this.model$1 = model$1;
            }
        }, ClassTag$.MODULE$.apply(String.class)).collect();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"modelOssDir=").append((Object)this.modelOssDir()).toString());
        model.save(sc, this.modelOssDir());
        KMeansModel modelLoadOss = KMeansModel$.MODULE$.load(sc, this.modelOssDir());
        String[] predictResult2 = (String[])rdd.map((Function1)new Serializable(modelLoadOss){
            public static final long serialVersionUID = 0L;
            private final KMeansModel modelLoadOss$1;

            public final String apply(Vector feature) {
                return new StringBuilder().append((Object)"cluster id: ").append((Object)BoxesRunTime.boxToInteger((int)this.modelLoadOss$1.predict(feature))).append((Object)" feature:").append((Object)Predef$.MODULE$.doubleArrayOps(feature.toArray()).mkString(",")).toString();
            }
            {
                this.modelLoadOss$1 = modelLoadOss$1;
            }
        }, ClassTag$.MODULE$.apply(String.class)).collect();
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])predictResult1).size() == Predef$.MODULE$.refArrayOps((Object[])predictResult2).size());
        Predef$.MODULE$.refArrayOps((Object[])predictResult2).foreach((Function1)new Serializable(predictResult1){
            public static final long serialVersionUID = 0L;
            private final String[] predictResult1$1;

            public final void apply(String result2) {
                Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.predictResult1$1).contains((Object)result2));
            }
            {
                this.predictResult1$1 = predictResult1$1;
            }
        });
    }

    private KmeansModelSaveToOss$() {
        MODULE$ = this;
        this.modelOssDir = "oss://bucket/kmeans-model";
    }
}

