/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.spark.zeppelin;

import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.requestcupid.CupidProxyTokenUtil;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterServer;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.sys.process.Process$;

public final class ZeppelinServer$ {
    public static final ZeppelinServer$ MODULE$;
    private final Logger com$aliyun$odps$spark$zeppelin$ZeppelinServer$$LOG;
    private final String zeppelinHome;
    private final String fixedReplOutputDir;
    private final ScheduledExecutorService pool;

    static {
        new ZeppelinServer$();
    }

    /*
     * WARNING - void declaration
     */
    public ScheduledExecutorService newDaemonSingleThreadScheduledExecutor(String threadName) {
        void var3_3;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(threadName).build();
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, threadFactory);
        executor.setRemoveOnCancelPolicy(true);
        return var3_3;
    }

    public Logger com$aliyun$odps$spark$zeppelin$ZeppelinServer$$LOG() {
        return this.com$aliyun$odps$spark$zeppelin$ZeppelinServer$$LOG;
    }

    public String zeppelinHome() {
        return this.zeppelinHome;
    }

    public String fixedReplOutputDir() {
        return this.fixedReplOutputDir;
    }

    public ScheduledExecutorService pool() {
        return this.pool;
    }

    /*
     * WARNING - void declaration
     */
    public int getRandomPort() {
        void var2_2;
        ServerSocket socket = new ServerSocket(0);
        int port = socket.getLocalPort();
        socket.close();
        return (int)var2_2;
    }

    public InetAddress findLocalInetAddress() {
        NonLocalReturnControl nonLocalReturnControl2;
        block5: {
            InetAddress inetAddress;
            Object object = new Object();
            try {
                String defaultIpOverride = System.getenv("SPARK_LOCAL_IP");
                if (defaultIpOverride == null) {
                    InetAddress address = InetAddress.getLocalHost();
                    if (address.isLoopbackAddress()) {
                        Seq activeNetworkIFs = ((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(NetworkInterface.getNetworkInterfaces()).asScala()).toSeq();
                        Seq reOrderedNetworkIFs = (Seq)activeNetworkIFs.reverse();
                        reOrderedNetworkIFs.foreach((Function1)new Serializable(address, object){
                            public static final long serialVersionUID = 0L;
                            private final InetAddress address$1;
                            private final Object nonLocalReturnKey1$1;

                            public final void apply(NetworkInterface ni) {
                                Seq addresses = ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(ni.getInetAddresses()).asScala()).filterNot((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(InetAddress addr) {
                                        return addr.isLinkLocalAddress() || addr.isLoopbackAddress();
                                    }
                                }).toSeq();
                                if (addresses.nonEmpty()) {
                                    InetAddress addr = (InetAddress)addresses.find((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(InetAddress x$1) {
                                            return x$1 instanceof Inet4Address;
                                        }
                                    }).getOrElse((Function0)new Serializable(this, addresses){
                                        public static final long serialVersionUID = 0L;
                                        private final Seq addresses$1;

                                        public final InetAddress apply() {
                                            return (InetAddress)this.addresses$1.head();
                                        }
                                        {
                                            this.addresses$1 = addresses$1;
                                        }
                                    });
                                    InetAddress strippedAddress = InetAddress.getByAddress(addr.getAddress());
                                    ZeppelinServer$.MODULE$.com$aliyun$odps$spark$zeppelin$ZeppelinServer$$LOG().warn((Object)new StringBuilder().append((Object)"Your hostname, ").append((Object)InetAddress.getLocalHost().getHostName()).append((Object)" resolves to").append((Object)" a loopback address: ").append((Object)this.address$1.getHostAddress()).append((Object)"; using ").append((Object)strippedAddress.getHostAddress()).append((Object)" instead (on interface ").append((Object)ni.getName()).append((Object)")").toString());
                                    ZeppelinServer$.MODULE$.com$aliyun$odps$spark$zeppelin$ZeppelinServer$$LOG().warn((Object)"Set SPARK_LOCAL_IP if you need to bind to another address");
                                    throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)strippedAddress);
                                }
                            }
                            {
                                this.address$1 = address$1;
                                this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                            }
                        });
                        this.com$aliyun$odps$spark$zeppelin$ZeppelinServer$$LOG().warn((Object)new StringBuilder().append((Object)"Your hostname, ").append((Object)InetAddress.getLocalHost().getHostName()).append((Object)" resolves to").append((Object)" a loopback address: ").append((Object)address.getHostAddress()).append((Object)", but we couldn't find any").append((Object)" external IP address!").toString());
                        this.com$aliyun$odps$spark$zeppelin$ZeppelinServer$$LOG().warn((Object)"Set SPARK_LOCAL_IP if you need to bind to another address");
                    }
                    inetAddress = address;
                } else {
                    inetAddress = InetAddress.getByName(defaultIpOverride);
                }
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block5;
                inetAddress = (InetAddress)nonLocalReturnControl2.value();
            }
            return inetAddress;
        }
        throw nonLocalReturnControl2;
    }

    public void replaceZeppelinCoreSite(int zeppelinPort) {
        Process$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cp -f ", "/conf/zeppelin-site.xml.todo ", "/conf/zeppelin-site.xml"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zeppelinHome(), this.zeppelinHome()}))).$bang();
        File file = new File(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/conf/zeppelin-site.xml"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zeppelinHome()})));
        String replaceStr = "##zeppelin_port##";
        String replaceContent = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec()).mkString().replace(replaceStr, ((Object)BoxesRunTime.boxToInteger((int)zeppelinPort)).toString());
        PrintWriter writer = new PrintWriter(file);
        writer.write(replaceContent);
        writer.close();
    }

    public void replaceZeppelinInterpreterJson(int interpreterPort) {
        Process$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cp -f ", "/conf/interpreter.json.todo ", "/conf/interpreter.json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zeppelinHome(), this.zeppelinHome()}))).$bang();
        File file = new File(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/conf/interpreter.json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zeppelinHome()})));
        String replaceStr = "##interpreter_port##";
        String replaceContent = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec()).mkString().replace(replaceStr, ((Object)BoxesRunTime.boxToInteger((int)interpreterPort)).toString());
        PrintWriter writer = new PrintWriter(file);
        writer.write(replaceContent);
        writer.close();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().config("spark.repl.class.outputDir", this.fixedReplOutputDir()).appName("ZeppelinServer").getOrCreate();
        this.pool().scheduleWithFixedDelay(new Runnable(){

            public void run() {
                File linkDir = new File(ZeppelinServer$.MODULE$.fixedReplOutputDir());
                if (linkDir.exists()) {
                    return;
                }
                File tmpDir = new File(System.getProperty("java.io.tmpdir"));
                String[] dirs = tmpDir.list();
                Predef$.MODULE$.refArrayOps((Object[])dirs).foreach((Function1)new Serializable(this, tmpDir){
                    public static final long serialVersionUID = 0L;
                    private final File tmpDir$1;

                    public final Object apply(String dir) {
                        Object object;
                        if (dir.startsWith("spark")) {
                            File tmpDir2 = new File(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmpDir$1.getAbsolutePath(), dir})));
                            int lineCount = tmpDir2.list(new FilenameFilter(this){

                                public boolean accept(File dir, String name) {
                                    return name.startsWith("$line");
                                }
                            }).length;
                            if (lineCount > 0) {
                                String cmd = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ln -s ", "/", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmpDir$1.getCanonicalPath(), dir, ZeppelinServer$.MODULE$.fixedReplOutputDir()}));
                                ZeppelinServer$.MODULE$.com$aliyun$odps$spark$zeppelin$ZeppelinServer$$LOG().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"find repl dir and do link with cmd ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cmd})));
                                object = BoxesRunTime.boxToInteger((int)Process$.MODULE$.apply(cmd).$bang());
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }
                    {
                        this.tmpDir$1 = tmpDir$1;
                    }
                });
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        int interpreterServerPort = this.getRandomPort();
        int zeppelinPort = this.getRandomPort();
        this.com$aliyun$odps$spark$zeppelin$ZeppelinServer$$LOG().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"interpreterServerPort: ", ", zeppelinPort: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)interpreterServerPort), BoxesRunTime.boxToInteger((int)zeppelinPort)})));
        this.replaceZeppelinCoreSite(zeppelinPort);
        this.replaceZeppelinInterpreterJson(interpreterServerPort);
        String zeppelinAppName = spark.sparkContext().getConf().get("spark.zeppelin.appName", "zeppelin");
        InetAddress address = this.findLocalInetAddress();
        String zeppelinEndpoint = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http://", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{address.getHostAddress(), BoxesRunTime.boxToInteger((int)zeppelinPort)}));
        this.com$aliyun$odps$spark$zeppelin$ZeppelinServer$$LOG().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zeppelinEndpoint: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{zeppelinEndpoint})));
        String metaPanguPath = new StringBuilder().append((Object)System.getenv("FUXI_JOB_TEMP_ROOT")).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"../../AppAddresses/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{zeppelinAppName}))).toString();
        FileSystem fs = FileSystem.get((Configuration)spark.sparkContext().hadoopConfiguration());
        this.com$aliyun$odps$spark$zeppelin$ZeppelinServer$$LOG().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"metaPanguPath: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metaPanguPath})));
        FSDataOutputStream out = fs.create(new Path(metaPanguPath));
        out.write(zeppelinEndpoint.getBytes());
        out.close();
        String cupidProxyEndPoint = spark.sparkContext().getConf().get("spark.hadoop.odps.cupid.proxy.end.point", "cupid.aliyun-inc.com");
        String zeppelinExpiredInHours = spark.sparkContext().getConf().get("spark.zeppelin.expired.in.hours", "144");
        String cupidToken = CupidProxyTokenUtil.getProxyToken((String)CupidSession.get().getJobLookupName(), (String)zeppelinAppName, (int)new StringOps(Predef$.MODULE$.augmentString(zeppelinExpiredInHours)).toInt(), (CupidSession)CupidSession.get());
        String externalUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http://", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cupidToken, cupidProxyEndPoint}));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please visit the following url for zeppelin interaction.\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{externalUrl})));
        String pathEnv = System.getenv("PATH");
        String startZeppelinCmd = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/bin/zeppelin-daemon.sh start"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zeppelinHome()}));
        Process$.MODULE$.apply(startZeppelinCmd, (Option)None$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CLASSPATH"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PATH"), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/extraPath:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zeppelinHome(), pathEnv}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ZEPPELIN_HOME"), (Object)this.zeppelinHome())})).$bang();
        RemoteInterpreterServer interpreter = new RemoteInterpreterServer(null, interpreterServerPort, null);
        interpreter.start();
        interpreter.join();
        System.exit(0);
    }

    private ZeppelinServer$() {
        MODULE$ = this;
        this.com$aliyun$odps$spark$zeppelin$ZeppelinServer$$LOG = Logger.getLogger(this.getClass());
        this.zeppelinHome = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new File(".").getCanonicalPath()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"public.zeppelin-0.8.1-bin-netinst.tar.gz/"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zeppelin-0.8.1-bin-netinst/"})).s((Seq)Nil$.MODULE$)).toString();
        this.fixedReplOutputDir = "/home/admin/replClassOutputDir";
        this.pool = this.newDaemonSingleThreadScheduledExecutor("link4replClassOutputDir");
    }
}

