/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot.buffer;

import com.alibaba.jboot.buffer.ByteBufferPool;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class JbootBufferFactory {
    private static boolean usePool = true;
    private static final ThreadLocal<ByteBufferPool> threadLocalPool = ThreadLocal.withInitial(() -> new ByteBufferPool(usePool));
    private static int defaultBufferSize = 128;

    public static void setUsePool(boolean usePoolFromConf) {
        usePool = usePoolFromConf;
    }

    public static ByteBuffer allocateBuffer(int capacity) {
        int buffersNum = capacity / defaultBufferSize;
        int bigSize = defaultBufferSize * (buffersNum += capacity % defaultBufferSize > 0 ? 1 : 0);
        ByteBuffer directBuffer = threadLocalPool.get().getDirect(bigSize);
        return directBuffer;
    }

    public static void returnBuffer(ByteBuffer bb) {
        if (bb != null && bb.isDirect()) {
            threadLocalPool.get().release(bb);
        }
    }

    public static class FlatBufferFactory
    implements FlatBufferBuilder.ByteBufferFactory {
        @Override
        public ByteBuffer newByteBuffer(int capacity) {
            return JbootBufferFactory.allocateBuffer(capacity).order(ByteOrder.LITTLE_ENDIAN);
        }

        @Override
        public void releaseByteBuffer(ByteBuffer bb) {
            JbootBufferFactory.returnBuffer(bb);
        }
    }
}

