/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot.google.flatbuffers;

import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CoderResult;

public class JbootFlatBufferBuilder
extends FlatBufferBuilder {
    public JbootFlatBufferBuilder() {
        int initial_size;
        this.space = initial_size = 128;
        this.bb_factory = new JbootBufferFactory.FlatBufferFactory();
        this.bb = this.bb_factory.newByteBuffer(initial_size);
    }

    @Override
    public int createString(CharSequence s) {
        int length = s.length();
        int estimatedDstCapacity = (int)((float)length * this.encoder.maxBytesPerChar());
        if (this.dst == null || this.dst.capacity() < estimatedDstCapacity) {
            this.dst = this.bb_factory.newByteBuffer(Math.max(128, estimatedDstCapacity));
        }
        this.dst.clear();
        CharBuffer src = s instanceof CharBuffer ? (CharBuffer)s : CharBuffer.wrap(s);
        CoderResult result = this.encoder.encode(src, this.dst, true);
        if (result.isError()) {
            try {
                result.throwException();
            }
            catch (CharacterCodingException x) {
                throw new Error(x);
            }
        }
        this.dst.flip();
        return this.createString(this.dst);
    }

    @Override
    public int createString(ByteBuffer s) {
        int length = s.remaining();
        this.addByte((byte)0);
        this.startVector(1, length, 1);
        this.space -= length;
        this.bb.position(this.space);
        this.bb.put(s);
        this.bb_factory.releaseByteBuffer(s);
        this.dst = null;
        return this.endVector();
    }
}

