/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.auth;

import com.aliyun.emr.fs.auth.AliyunCredentials;
import com.aliyun.emr.fs.auth.AliyunSessionCredentials;
import com.aliyun.emr.fs.auth.AuthUtils;
import com.aliyun.emr.fs.auth.BasicCredentials;
import com.aliyun.emr.fs.auth.BasicSessionCredentials;
import com.aliyun.emr.fs.auth.MarshalledCredentials;
import com.aliyun.emr.fs.auth.NoAliyunCredentialsException;
import com.aliyun.emr.fs.auth.NoAuthWithAliyunException;
import com.aliyun.emr.fs.internal.oss.ProviderUtils;
import com.aliyun.emr.fs.oss.Constants;
import com.aliyun.emr.shade.google_guava.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MarshalledCredentialBinding {
    private static final Logger LOG = LoggerFactory.getLogger(MarshalledCredentialBinding.class);
    @VisibleForTesting
    public static final String NO_ALIYUN_CREDENTIALS = "No ALIYUN credentials";

    private MarshalledCredentialBinding() {
    }

    public static MarshalledCredentials fromAliyunCredentials(AliyunSessionCredentials credentials) {
        return new MarshalledCredentials(credentials.getAccessKeyId(), credentials.getAccessKeySecret(), credentials.getSecurityToken());
    }

    public static MarshalledCredentials fromEnvironment(Map<String, String> env) {
        return new MarshalledCredentials(MarshalledCredentialBinding.nullToEmptyString(env.get("ALIYUN_ACCESS_KEY_ID")), MarshalledCredentialBinding.nullToEmptyString(env.get("ALIYUN_ACCESS_KEY_SECRET")), MarshalledCredentialBinding.nullToEmptyString(env.get("ALIYUN_SECURITY_TOKEN")));
    }

    private static String nullToEmptyString(String src) {
        return src == null ? "" : src;
    }

    public static MarshalledCredentials fromFileSystem(URI uri, Configuration conf, Class<? extends FileSystem> fileSystemClass) throws IOException {
        String bucket = uri != null ? uri.getHost() : "";
        Configuration leanConf = ProviderUtils.excludeIncompatibleCredentialProviders(conf, fileSystemClass);
        return new MarshalledCredentials(AuthUtils.lookupOssPassword(bucket, leanConf, "fs.jfs.cache.oss.accessKeyId", Constants.DEPRECATED_OSS_ACCESS_KEY_ID), AuthUtils.lookupOssPassword(bucket, leanConf, "fs.jfs.cache.oss.accessKeySecret", Constants.DEPRECATED_OSS_ACCESS_KEY_SECRET), AuthUtils.lookupOssPassword(bucket, leanConf, "fs.jfs.cache.oss.securityToken", Constants.DEPRECATED_OSS_SECURITY_TOKEN));
    }

    public static AliyunCredentials toAliyunCredentials(MarshalledCredentials marshalled, MarshalledCredentials.CredentialTypeRequired typeRequired, String component) throws NoAliyunCredentialsException {
        if (marshalled.isEmpty()) {
            throw new NoAliyunCredentialsException(component, NO_ALIYUN_CREDENTIALS);
        }
        if (!marshalled.isValid(typeRequired)) {
            throw new NoAuthWithAliyunException(component + ":" + marshalled.buildInvalidCredentialsError(typeRequired));
        }
        String accessKey = marshalled.getAccessKeyId();
        String secretKey = marshalled.getAccessKeySecret();
        if (marshalled.hasSecurityToken()) {
            return new BasicSessionCredentials(accessKey, secretKey, marshalled.getSecurityToken());
        }
        return new BasicCredentials(accessKey, secretKey);
    }
}

