/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.jfs;

import java.io.IOException;
import org.apache.hadoop.util.DataChecksum;

public class CrcUtil {
    public static final int CRC32C_POLYNOMIAL = 1;
    public static final int CRC32_ZLIB_POLYNOMIAL = 2;

    static DataChecksum.Type getDataChecksumType(int type) throws IOException {
        if (type == 1) {
            return DataChecksum.Type.CRC32C;
        }
        if (type == 2) {
            return DataChecksum.Type.CRC32;
        }
        throw new IOException("Illegal checksum type " + type);
    }

    public static byte[] intToBytes(int value) {
        byte[] buf = new byte[4];
        CrcUtil.writeInt(buf, 0, value);
        return buf;
    }

    public static void writeInt(byte[] buf, int offset, int value) {
        buf[offset + 0] = (byte)(value >>> 24 & 0xFF);
        buf[offset + 1] = (byte)(value >>> 16 & 0xFF);
        buf[offset + 2] = (byte)(value >>> 8 & 0xFF);
        buf[offset + 3] = (byte)(value & 0xFF);
    }
}

