/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.ossnative;

import com.alibaba.jfs.CredentialContext;
import com.alibaba.jfs.OssAtomicRenameContext;
import com.aliyun.emr.fs.auth.AliyunCredentialProviderList;
import com.aliyun.emr.fs.auth.AliyunCredentials;
import com.aliyun.emr.fs.auth.AliyunCredentialsProvider;
import com.aliyun.emr.fs.auth.AliyunSessionCredentials;
import com.aliyun.emr.fs.auth.AuthUtils;
import com.aliyun.emr.fs.auth.JindoCredentialsProvider;
import com.aliyun.emr.fs.oss.Constants;
import com.aliyun.emr.shade.google_guava.base.Strings;
import com.aliyun.emr.utils.StringUtils;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssCredentialUtils {
    public static final Logger LOG = LoggerFactory.getLogger(OssCredentialUtils.class);
    public static volatile CredentialContext cachedCredentialContext;
    public static volatile boolean needInitCredential;

    public static URI createFinallyURI(URI uri, Configuration conf, String schema, CredentialContext ossContext) {
        if (schema.equals("jfs")) {
            return uri;
        }
        String bucket = null;
        String host = uri.getHost();
        if (!StringUtils.isEmpty(host) && !host.contains(".")) {
            bucket = host;
        } else if (!StringUtils.isEmpty(host)) {
            bucket = host.substring(0, host.indexOf("."));
        }
        StringBuilder strBuilder = new StringBuilder();
        if (ossContext.accessKeyId != null && ossContext.accessKeySecret != null) {
            strBuilder.append(ossContext.accessKeyId).append(":").append(ossContext.accessKeySecret);
            if (ossContext.securityToken != null) {
                strBuilder.append(":").append(ossContext.securityToken);
            }
            strBuilder.append("@");
        }
        strBuilder.append(bucket);
        String actualEndpoint = OssCredentialUtils.getEndpoint(conf, uri);
        if (actualEndpoint != null) {
            strBuilder.append(".").append(actualEndpoint);
        }
        String authority = strBuilder.toString();
        return URI.create(uri.getScheme() + "://" + authority);
    }

    public static CredentialContext createCredentialContext(String path, Configuration configuration, AliyunCredentialsProvider.CredentialType type) throws IOException {
        URI uri = URI.create(path);
        uri = uri.getAuthority() != null ? URI.create(uri.getScheme() + "://" + uri.getAuthority()) : URI.create(uri.getScheme() + ":///");
        return OssCredentialUtils.createOssCredentialContext(configuration, uri, AuthUtils.createAliyunCredentialProviderSet(uri, configuration, type));
    }

    public static CredentialContext createOssCredentialContext(Configuration conf, URI uri, AliyunCredentialProviderList providers) throws IOException {
        String userInfo;
        String actualAccessKeyId = null;
        String actualAccessKeySecret = null;
        String actualSecurityToken = null;
        if (uri.getScheme().equals("oss") && (userInfo = uri.getUserInfo()) != null) {
            String[] ossCredentials = userInfo.split(":");
            if (ossCredentials.length >= 2) {
                actualAccessKeyId = ossCredentials[0];
                actualAccessKeySecret = ossCredentials[1];
            }
            if (ossCredentials.length == 3) {
                actualSecurityToken = ossCredentials[2];
            }
        }
        String accessKeyId = null;
        String accessKeySecret = null;
        String securityToken = null;
        AliyunCredentials credentials = providers.getCredentials();
        if (credentials != null) {
            accessKeyId = credentials.getAccessKeyId();
            accessKeySecret = credentials.getAccessKeySecret();
            boolean hasSessionCreds = credentials instanceof AliyunSessionCredentials;
            if (hasSessionCreds) {
                AliyunSessionCredentials sessionCredentials = (AliyunSessionCredentials)credentials;
                securityToken = sessionCredentials.getSecurityToken();
            }
        }
        if (actualAccessKeyId == null) {
            actualAccessKeyId = accessKeyId;
        }
        if (actualAccessKeySecret == null) {
            actualAccessKeySecret = accessKeySecret;
        }
        if (actualSecurityToken == null) {
            actualSecurityToken = securityToken;
        }
        CredentialContext ossContext = new CredentialContext();
        ossContext.accessKeyId = actualAccessKeyId;
        ossContext.accessKeySecret = actualAccessKeySecret;
        ossContext.securityToken = actualSecurityToken;
        if (Strings.isNullOrEmpty(actualAccessKeyId) || Strings.isNullOrEmpty(actualAccessKeySecret)) {
            JindoCredentialsProvider provider = providers.getJindoCredentialsProvider();
            byte format = 0;
            if (provider != null) {
                ossContext.providerEndpoint = OssCredentialUtils.getProviderEndpoint(provider);
                format = OssCredentialUtils.getTokenFormat(provider.getTokenFormat());
            }
            ossContext.format = format;
        }
        ossContext.endpoint = OssCredentialUtils.getEndpoint(conf, uri);
        return ossContext;
    }

    private static String getEndpoint(Configuration conf, URI uri) {
        String actualEndpoint = null;
        if (uri.getScheme().equals("oss")) {
            String host = uri.getHost();
            if (!StringUtils.isEmpty(host) && host.contains(".")) {
                actualEndpoint = host.substring(host.indexOf(".") + 1);
            }
            String endpoint = OssCredentialUtils.getOSSConfig(conf, "fs.jfs.cache.oss.endpoint", Constants.DEPRECATED_OSS_ENDPOINT);
            if (actualEndpoint == null) {
                actualEndpoint = endpoint;
            }
        } else if (uri.getScheme().equals("jfs")) {
            actualEndpoint = OssCredentialUtils.getOSSConfig(conf, "fs.jfs.endpoint", new String[0]);
        }
        if (actualEndpoint == null) {
            actualEndpoint = OssCredentialUtils.getOSSConfig(conf, "jindo.common.oss.endpoint", new String[0]);
        }
        return actualEndpoint;
    }

    private static String getProviderEndpoint(JindoCredentialsProvider provider) throws IOException {
        String url;
        try {
            url = provider.getStsProviderUrl();
        }
        catch (IOException e) {
            throw new IOException("ERROR: fail to get endpoint from provider. " + e.getMessage());
        }
        if (Strings.isNullOrEmpty(url)) {
            throw new IOException("ERROR: the endpoint of provider: " + provider.getClass() + " is null.");
        }
        return url;
    }

    private static String getOSSConfig(Configuration conf, String key, String ... deprecatedKeys) {
        String value = conf.getTrimmed(key);
        if (value == null & deprecatedKeys != null) {
            for (int i = 0; i < deprecatedKeys.length; ++i) {
                value = conf.getTrimmed(deprecatedKeys[i]);
                if (value == null) continue;
                LOG.warn("{} is deprecated, please use: {}", (Object)deprecatedKeys[i], (Object)key);
                return value;
            }
        }
        return value;
    }

    private static byte getTokenFormat(JindoCredentialsProvider.CredentialsTokenFormat format) {
        byte result;
        switch (format) {
            case PLAIN: {
                result = 0;
                break;
            }
            case JSON: {
                result = 1;
                break;
            }
            default: {
                LOG.warn("unknown format: " + (Object)((Object)format) + " . use the default format " + 1);
                result = 1;
            }
        }
        return result;
    }

    public static OssAtomicRenameContext.OtsOptions createOtsCredential(Configuration conf) throws IOException {
        OssAtomicRenameContext.OtsOptions otsOptions = new OssAtomicRenameContext.OtsOptions();
        AliyunCredentialProviderList providers = AuthUtils.createAliyunCredentialProviderSet(null, conf, AliyunCredentialsProvider.CredentialType.OTS);
        String accessKeyId = null;
        String accessKeySecret = null;
        String securityToken = null;
        AliyunCredentials credentials = providers.getCredentials();
        if (credentials != null) {
            accessKeyId = credentials.getAccessKeyId();
            accessKeySecret = credentials.getAccessKeySecret();
            boolean hasSessionCreds = credentials instanceof AliyunSessionCredentials;
            if (hasSessionCreds) {
                AliyunSessionCredentials sessionCredentials = (AliyunSessionCredentials)credentials;
                securityToken = sessionCredentials.getSecurityToken();
            }
        }
        if (Strings.isNullOrEmpty(accessKeyId) || Strings.isNullOrEmpty(accessKeySecret)) {
            JindoCredentialsProvider provider = providers.getJindoCredentialsProvider();
            byte format = 0;
            if (provider != null) {
                otsOptions.providerEndpoint = OssCredentialUtils.getProviderEndpoint(provider);
                format = OssCredentialUtils.getTokenFormat(provider.getTokenFormat());
            }
            otsOptions.format = format;
        } else {
            otsOptions.accessKeyId = accessKeyId;
            otsOptions.accessKeySecret = accessKeySecret;
            otsOptions.securityToken = securityToken;
        }
        return otsOptions;
    }

    static {
        needInitCredential = true;
    }
}

