/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.jfs;

import bigboot.protocol.type.CltArchiveDirReply;
import bigboot.protocol.type.CltRestoreDirReply;
import bigboot.protocol.type.CltUnarchiveDirReply;
import bigboot.protocol.type.FileletStatus;
import bigboot.protocol.type.NamespaceInfo;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.alibaba.jboot.google.flatbuffers.Table;
import com.alibaba.jfs.CredentialContext;
import com.alibaba.jfs.JindoRequestPath;
import com.aliyun.emr.fs.auth.AliyunCredentialProviderList;
import com.aliyun.emr.fs.auth.AliyunCredentialsProvider;
import com.aliyun.emr.fs.auth.AuthUtils;
import com.aliyun.emr.fs.common.AbstractJindoCommitterFactory;
import com.aliyun.emr.fs.common.AbstractJindoShimsFileSystem;
import com.aliyun.emr.fs.internal.hdfs.HdfsStore;
import com.aliyun.emr.fs.internal.jfs.JfsFileletSystem;
import com.aliyun.emr.fs.internal.jfs.JfsStore;
import com.aliyun.emr.fs.internal.ossnative.OssCredentialUtils;
import com.aliyun.emr.fs.internal.ossnative.OssNativeStore;
import com.aliyun.emr.fs.jfs.JindoFSCommitterFactory;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.JfsTrashPolicy;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JindoFileSystem
extends AbstractJindoShimsFileSystem {
    static final Logger LOG = LoggerFactory.getLogger(JindoFileSystem.class);
    private String defaultStorageClass = null;

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        if (!uri.getScheme().equals("jfs")) {
            throw new IOException("Wrong scheme: JindoFileSystem only support jfs scheme, please check your configuration files.");
        }
        Configuration updateConf = AuthUtils.propagateNamespaceOptions(conf, uri.getAuthority());
        super.initialize(uri, conf);
        this.setConf(updateConf);
        String namespaceRpcAddresses = this.getConf().get("fs.jfs.namespace.rpc-address");
        this.defaultStorageClass = conf.get("fs.jfs.cache.storage-class-default", "");
        this.initStore(uri, namespaceRpcAddresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStore(URI uri, String namespaceRpcAddresses) throws IOException {
        block9: {
            Table nsInfo = null;
            try {
                JfsFileletSystem jfs1FileletSystem = new JfsFileletSystem();
                nsInfo = jfs1FileletSystem.getNamespaceInfo(uri.getAuthority(), namespaceRpcAddresses);
                if (nsInfo == null) {
                    throw new IOException("Namespace " + uri.getAuthority() + " is not found in JFS ");
                }
                if (((NamespaceInfo)nsInfo).mode() == 1) {
                    this.initJfsStoreContext((NamespaceInfo)nsInfo, jfs1FileletSystem);
                    break block9;
                }
                if (((NamespaceInfo)nsInfo).mode() == 0) {
                    if (((NamespaceInfo)nsInfo).uri().startsWith("hdfs://")) {
                        this.initHdfsStoreContext((NamespaceInfo)nsInfo);
                    } else {
                        this.initOssStoreContext((NamespaceInfo)nsInfo);
                    }
                    break block9;
                }
                throw new IOException("Namespace " + uri.getAuthority() + " mode is invalid: " + ((NamespaceInfo)nsInfo).mode());
            }
            finally {
                if (nsInfo != null && nsInfo.getByteBuffer() != null) {
                    JbootBufferFactory.returnBuffer(nsInfo.getByteBuffer());
                }
            }
        }
    }

    private void initJfsStoreContext(NamespaceInfo nsInfo, JfsFileletSystem jfs1FileletSystem) throws IOException {
        JfsStore.Context context = new JfsStore.Context();
        context.logName = this.logName;
        context.uri = this.uri;
        context.workingDir = this.workingDir;
        context.statistics = this.statistics;
        context.fileletSystem = jfs1FileletSystem;
        context.nsConnectorPtr = nsInfo.nsConnectorPtr();
        this.store = new JfsStore((FileSystem)this, this.conf, context);
    }

    private void initOssStoreContext(NamespaceInfo nsInfo) throws IOException {
        OssNativeStore.Context context = new OssNativeStore.Context();
        context.logName = this.logName;
        context.uri = this.uri;
        context.workingDir = this.workingDir;
        context.statistics = this.statistics;
        context.prefix = nsInfo.name();
        context.credentialProviders = AuthUtils.createAliyunCredentialProviderSet(context.uri, this.conf, AliyunCredentialsProvider.CredentialType.JFS);
        this.store = new OssNativeStore((FileSystem)this, this.conf, context);
    }

    private void initHdfsStoreContext(NamespaceInfo nsInfo) throws IOException {
        HdfsStore.Context context = new HdfsStore.Context();
        context.logName = this.logName;
        context.uri = this.uri;
        context.workingDir = this.workingDir;
        context.statistics = this.statistics;
        context.prefix = nsInfo.name();
        context.credentialProviders = AuthUtils.createAliyunCredentialProviderSet(context.uri, this.conf, AliyunCredentialsProvider.CredentialType.JFS);
        this.store = new HdfsStore((FileSystem)this, this.conf, context);
    }

    @Override
    protected FSDataOutputStream createCore(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.store.create(f, permission, overwrite, bufferSize, replication, blockSize, progress, this.defaultStorageClass);
    }

    @Override
    protected boolean deleteCore(Path f, boolean recursive, boolean deleteVersions) throws IOException {
        return this.store.delete(f, recursive, false, deleteVersions);
    }

    @Override
    protected FileStatus getFileStatusCore(Path f) throws IOException {
        return this.store.getFileStatus(f);
    }

    @Override
    public String getScheme() {
        return "jfs";
    }

    public int getDefaultPort() {
        return -1;
    }

    @Override
    protected FileStatus[] listStatusCore(Path f) throws IOException {
        return this.store.listStatus(f, false, this.isCmd);
    }

    @Override
    protected boolean mkdirsCore(Path f, FsPermission permission) throws IOException {
        return this.store.mkdirs(f, permission);
    }

    @Override
    public FSDataInputStream openCore(Path f, int bufferSize) throws IOException {
        return this.store.open(f, bufferSize);
    }

    @Override
    protected boolean renameCore(Path src, Path dst) throws IOException {
        return this.store.rename(src, dst, false, false);
    }

    @Override
    protected byte[] getXAttrCore(Path path, String name) throws IOException {
        return this.store.getXAttr(path, name);
    }

    @Override
    protected Map<String, byte[]> getXAttrsCore(Path path) throws IOException {
        return this.store.getXAttrs(path);
    }

    @Override
    protected Map<String, byte[]> getXAttrsCore(Path path, List<String> names) throws IOException {
        return this.store.getXAttrs(path, names);
    }

    @Override
    protected void setXAttrCore(Path path, String name, byte[] value) throws IOException {
        this.store.setXAttr(path, name, value);
    }

    @Override
    protected List<String> listXAttrsCore(Path path) throws IOException {
        return this.store.listXAttrs(path);
    }

    @Override
    protected void removeXAttrCore(Path path, String name) throws IOException {
        this.store.removeXAttr(path, name);
    }

    @Override
    protected void checkPermissionCore(Path path, FsAction mode) throws IOException {
        this.store.checkPermission(path, mode);
    }

    @Override
    protected ContentSummary getContentSummaryCore(Path path) throws IOException {
        return this.store.getContentSummary(path);
    }

    @Override
    protected BlockLocation[] getFileBlockLocationsCore(FileStatus file, long start, long len) throws IOException {
        return this.store.getFileBlockLocations(file, start, len);
    }

    @Override
    public void close() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("FileSystem [ " + this.getUri() + " ] closed");
        }
        super.close();
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        try {
            this.store.setPermission(p, permission);
        }
        catch (UnsupportedOperationException e) {
            super.setPermission(p, permission);
        }
    }

    public void setPermissionWithDelta(Path path, short permission, short permissionDelta, boolean recursive) throws IOException {
        this.store.processPermissionDelta(path, permission, permissionDelta, recursive);
    }

    public void setOwner(Path path, String username, String groupName, boolean recursive) throws IOException {
        this.store.setOwner(path, username, groupName, recursive);
    }

    @Override
    public boolean renameFilesCore(Path srcFolder, Path destFolder, boolean errorOnExists) throws IOException {
        return this.store.rename(srcFolder, destFolder, !errorOnExists, true);
    }

    @Override
    public boolean moveToAppropriateTrashCore(Path p) throws IOException {
        Path fullyResolvedPath = p;
        FileSystem fullyResolvedFs = FileSystem.get((URI)fullyResolvedPath.toUri(), (Configuration)this.conf);
        Configuration confCopy = new Configuration(this.conf);
        confCopy.set("fs.trash.classname", JfsTrashPolicy.class.getName());
        Trash trash = new Trash(fullyResolvedFs, confCopy);
        return trash.moveToTrash(fullyResolvedPath);
    }

    @Override
    public boolean deleteFilesCore(Path p) throws IOException {
        return this.store.delete(p, true, true, false);
    }

    public void setOwner(Path p, String username, String groupName) throws IOException {
        try {
            this.store.setOwner(p, username, groupName);
        }
        catch (UnsupportedOperationException e) {
            super.setOwner(p, username, groupName);
        }
    }

    public Map<Path, FileStatus[]> listGlobStatus(Path p, boolean isRecursive, boolean isCmd) throws IOException {
        FileStatus[] reqLists = this.globStatus(p);
        LinkedHashMap<Path, FileStatus[]> result = new LinkedHashMap<Path, FileStatus[]>();
        if (reqLists != null && reqLists.length > 0) {
            for (FileStatus cPath : reqLists) {
                result.put(cPath.getPath(), this.store.listStatus(cPath.getPath(), isRecursive, isCmd));
            }
        }
        return result;
    }

    @Override
    public Boolean isCacheMode() {
        return this.store instanceof OssNativeStore;
    }

    @Override
    public Boolean isMagicCommitEnabled() {
        return this.store.isMagicCommitEnabled();
    }

    @Override
    protected void unCacheCore(Path path) throws IOException {
        this.store.uncache(path);
    }

    @Override
    protected void cacheCore(Path path, AbstractJindoShimsFileSystem.CacheOpContext opContext) throws IOException {
        this.store.cache(path, opContext);
    }

    @Override
    protected void archiveCore(Path path, Byte policy) throws IOException {
        this.store.archive(path, policy);
    }

    @Override
    protected void unArchiveCore(Path path, Byte policy) throws IOException {
        this.store.unarchive(path, policy);
    }

    @Override
    protected FileletStatus[] checkProgressCore(Path path, boolean detailed) throws IOException {
        return this.store.checkProgress(path, detailed);
    }

    public String getCanonicalServiceName() {
        return null;
    }

    @Override
    public Boolean isBatchMetaSupported() {
        if (this.store instanceof JfsStore) {
            return true;
        }
        return false;
    }

    public Path composeClosePath(Path realPath) throws IOException {
        AliyunCredentialProviderList providers = AuthUtils.createAliyunCredentialProviderSet(this.uri, this.conf, AliyunCredentialsProvider.CredentialType.JFS);
        CredentialContext ossContext = OssCredentialUtils.createOssCredentialContext(this.conf, this.uri, providers);
        JindoRequestPath path = new JindoRequestPath(this.uri.toString(), 0L, ossContext);
        if (!(this.store instanceof JfsStore)) {
            throw new IOException("fs doesn't support close2");
        }
        LOG.info("composeClosePath for application with file " + realPath);
        return ((JfsStore)this.store).composeClosePath(realPath);
    }

    public boolean close2(List<String> paths, Boolean abort) throws IOException {
        AliyunCredentialProviderList providers = AuthUtils.createAliyunCredentialProviderSet(this.uri, this.conf, AliyunCredentialsProvider.CredentialType.JFS);
        CredentialContext ossContext = OssCredentialUtils.createOssCredentialContext(this.conf, this.uri, providers);
        JindoRequestPath path = new JindoRequestPath(this.uri.toString(), 0L, ossContext);
        if (!(this.store instanceof JfsStore)) {
            throw new IOException("fs doesn't support close2");
        }
        LOG.info("Close2 for application with files " + paths.size());
        return ((JfsStore)this.store).close2(path, paths, abort);
    }

    @Override
    protected CltArchiveDirReply archiveDirCore(Path path, Byte policy) throws IOException {
        return this.store.archiveDir(path, policy);
    }

    @Override
    protected CltUnarchiveDirReply unarchiveDirCore(Path path, Byte policy) throws IOException {
        return this.store.unarchiveDir(path, policy);
    }

    @Override
    protected CltRestoreDirReply restoreDirCore(Path path) throws IOException {
        return this.store.restoreDir(path);
    }

    @Override
    protected AbstractJindoCommitterFactory createFileOutputCommitterFactory() throws IOException {
        return new JindoFSCommitterFactory();
    }
}

