/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.oss.commit.magic;

import bigboot.protocol.type.CltFlushMultipartUploadReply;
import com.alibaba.jboot.JbootOssWriter;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.alibaba.jfs.CredentialContext;
import com.alibaba.jfs.JindoRequestPath;
import com.aliyun.emr.buffer.ChunkBuffer;
import com.aliyun.emr.compatibility.StopWatch;
import com.aliyun.emr.fs.common.FsStats;
import com.aliyun.emr.fs.internal.ossnative.OssFileletSystem;
import com.aliyun.emr.fs.internal.ossnative.OssOpContext;
import com.aliyun.emr.fs.internal.ossnative.OssPartInfo;
import com.aliyun.emr.fs.oss.commit.magic.CRC64;
import com.aliyun.emr.fs.oss.commit.magic.SinglePendingCommit;
import com.aliyun.emr.utils.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JindoOssMagicOutputStream
extends OutputStream {
    static final Logger LOG = LoggerFactory.getLogger(JindoOssMagicOutputStream.class);
    private boolean closed;
    private final byte[] singleByteBuf = new byte[1];
    private ChunkBuffer writeBuffer;
    private long byteWriten = 0L;
    private long writeElapsedNanos = 0L;
    private OssFileletSystem ossFileletSystem;
    private OssMagicWriteContext context;
    private CredentialContext ossContext;
    private CRC64 crc64;

    public JindoOssMagicOutputStream(OssMagicWriteContext context, CredentialContext ossContext) throws IOException {
        this.context = context;
        this.ossFileletSystem = context.ossFileletSystem;
        this.ossContext = ossContext;
        this.crc64 = new CRC64();
        this.writeBuffer = new ChunkBuffer(JbootBufferFactory.allocateBuffer(context.bufferSize));
        LOG.info("JindoOssMagicOutputStream init, path:{}. Buffer size {}, destPath {}, pendingPath {}, bucket {}", new Object[]{context.path, context.bufferSize, context.destPath, context.pendingPath, context.bucket});
    }

    @Override
    public synchronized void flush() throws IOException {
        LOG.debug("Not real flush");
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            List<OssPartInfo> partInfos;
            String uploadId;
            this.writeOutBuffer();
            StopWatch sw = new StopWatch().start();
            CltFlushMultipartUploadReply reply = null;
            try {
                reply = this.context.jbootWriter.flushMultipartUpload();
                uploadId = reply.uploadId();
                partInfos = OssPartInfo.fromPartList(reply.partListAsPartList());
            }
            catch (IOException e) {
                throw new IOException("Failed to flush all written data to oss with multipart upload of path " + this.context.path, e);
            }
            finally {
                if (reply != null) {
                    JbootBufferFactory.returnBuffer(reply.getByteBuffer());
                }
            }
            if (StringUtils.isNotEmpty(uploadId)) {
                this.writeSingePendingCommit(partInfos, uploadId);
            }
            this.writeElapsedNanos += sw.stop().now();
            this.closed = true;
        }
        catch (IOException e) {
            this.closed = true;
            LOG.error("Close " + this.context.path + " error " + e.getMessage(), (Throwable)e);
            throw new IOException("Close stream " + this.context.path + " error " + e.getMessage(), e);
        }
        finally {
            FsStats.logStats("upload", new Path(this.context.path), null, this.byteWriten, null, this.writeElapsedNanos, "3.7.2");
            this.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSingePendingCommit(List<OssPartInfo> partInfos, String uploadId) throws IOException {
        SinglePendingCommit commitData = new SinglePendingCommit();
        commitData.touch(System.currentTimeMillis());
        commitData.setDestinationKey(this.context.destPath);
        commitData.setUri(this.context.path);
        commitData.setUploadId(uploadId);
        commitData.setBucket(this.context.bucket);
        commitData.setText("");
        commitData.bindCommitData(partInfos);
        commitData.setChecksum(this.crc64);
        byte[] bytes = commitData.toBytes();
        LOG.info("Uncommitted data pending to file {}; commit metadata for {} parts in {}.", new Object[]{this.context.path, partInfos.size(), this.context.pendingPath});
        ByteBuffer buffer = JbootBufferFactory.allocateBuffer(bytes.length);
        this.ossFileletSystem.write(new JindoRequestPath(this.context.path, this.ossContext), ByteBuffer.wrap(new byte[0]));
        try {
            buffer.put(bytes);
            buffer.rewind();
            this.ossFileletSystem.write(new JindoRequestPath(this.context.pendingPath, this.ossContext), buffer);
        }
        finally {
            JbootBufferFactory.returnBuffer(buffer);
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.checkStatus();
        this.singleByteBuf[0] = (byte)b;
        this.write(this.singleByteBuf, 0, 1);
    }

    @Override
    public synchronized void write(byte[] buffer, int off, int len) throws IOException {
        this.checkStatus();
        int nWritten = this.writeBuffer.write(buffer, off, len);
        if (nWritten < len) {
            try {
                this.writeOutBuffer();
            }
            catch (Exception e) {
                this.cleanUp();
                throw new IOException("Write " + off + "~" + len + " error", e);
            }
            if (this.context.verifyChecksum) {
                this.crc64.update(buffer, off, nWritten);
            }
            this.write(buffer, off + nWritten, len - nWritten);
        } else if (this.context.verifyChecksum) {
            this.crc64.update(buffer, off, len);
        }
    }

    protected void finalize() {
        this.cleanUp();
    }

    private void writeOutBuffer() throws IOException {
        StopWatch sw = new StopWatch().start();
        this.writeBuffer.buffer().flip();
        if (this.writeBuffer.buffer().remaining() > 0) {
            ByteBuffer buffer = this.writeBuffer.buffer();
            this.context.jbootWriter.write(buffer);
        }
        this.writeBuffer.buffer().position(0);
        this.writeElapsedNanos += sw.stop().now();
    }

    private void checkStatus() throws IOException {
        if (this.closed) {
            throw new IOException("Output stream closed.");
        }
    }

    private void cleanUp() {
        this.context.jbootWriter.close();
        if (this.writeBuffer != null) {
            JbootBufferFactory.returnBuffer(this.writeBuffer.buffer());
            this.writeBuffer = null;
        }
    }

    public static class OssMagicWriteContext
    extends OssOpContext {
        public String path;
        public int bufferSize;
        public JbootOssWriter jbootWriter;
        public String pendingPath;
        public String destPath;
        public String bucket;
        public boolean verifyChecksum;
    }
}

