/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.auth;

import com.aliyun.emr.fs.s3.auth.NoCredentialsException;
import com.aliyun.emr.fs.s3.auth.S3Credentials;
import com.aliyun.emr.fs.s3.auth.S3CredentialsProvider;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;

public abstract class JindoCredentialsProvider
implements S3CredentialsProvider {
    private final URI binding;
    private final Configuration conf;
    private final String bucket;
    private final S3CredentialsProvider.CredentialType type;

    public JindoCredentialsProvider(URI uri, Configuration conf, S3CredentialsProvider.CredentialType type) {
        this.binding = uri;
        this.conf = conf;
        this.bucket = uri != null ? uri.getHost() : "";
        this.type = type;
    }

    @Override
    public S3Credentials getCredentials() {
        throw new NoCredentialsException("JindoCredentialsProvider", "No Aliyun credentials in the configuration");
    }

    @Override
    public void refresh() {
    }

    public Configuration getConf() {
        return this.conf;
    }

    public URI getUri() {
        return this.binding;
    }

    public String getBucket() {
        return this.bucket;
    }

    public S3CredentialsProvider.CredentialType getType() {
        return this.type;
    }

    public abstract String getStsProviderUrl() throws IOException;

    public abstract CredentialsTokenFormat getTokenFormat();

    public static enum CredentialsTokenFormat {
        PLAIN,
        JSON;

    }
}

