/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import com.aliyun.emr.fs.common.AbstractJindoShimsFileSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.PathIsDirectoryException;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.FsCommandProvider;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.util.ToolRunner;

public class JfsDelete
implements FsCommandProvider {
    @Override
    public Class<? extends FsCommand> getCommandClass() {
        return Delete.class;
    }

    public static class Delete
    extends FsCommand {
        public static void registerCommands(CommandFactory factory) {
            factory.addClass(Rm.class, new String[]{"-rm2"});
            factory.addClass(Rmr.class, new String[]{"-rmr2"});
        }

        static class Rmr
        extends Rm {
            public static final String NAME = "rmr2";

            Rmr() {
            }

            @Override
            protected void processOptions(LinkedList<String> args) throws IOException {
                args.addFirst("-r");
                super.processOptions(args);
            }

            public String getReplacementCommand() {
                return "-rm -r";
            }
        }

        public static class Rm
        extends FsCommand {
            public static final String NAME = "rm2";
            public static final String USAGE = "[-f] [-r|-R] [-skipTrash] [-safely] <src> ...";
            public static final String DESCRIPTION = "Delete all files that match the specified file pattern. Equivalent to the Unix command \"rm <src>\"\n-f: If the file does not exist, do not display a diagnostic message or modify the exit status to reflect an error.\n-[rR]:  Recursively deletes directories.\n-skipTrash: option bypasses trash, if enabled, and immediately deletes <src>.\n-safely: option requires safety confirmation, if enabled, requires confirmation before deleting large directory with more than <hadoop.shell.delete.limit.num.files> files. Delay is expected when walking over large directory recursively to count the number of files to be deleted before the confirmation.\n";
            private boolean skipTrash = false;
            private boolean deleteDirs = false;
            private boolean ignoreFNF = false;
            private boolean safeDelete = false;

            protected void processOptions(LinkedList<String> args) throws IOException {
                CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, new String[]{"f", "r", "R", "skipTrash", "safely"});
                cf.parse(args);
                this.ignoreFNF = cf.getOpt("f");
                this.deleteDirs = cf.getOpt("r") || cf.getOpt("R");
                this.skipTrash = cf.getOpt("skipTrash");
                this.safeDelete = cf.getOpt("safely");
            }

            protected List<PathData> expandArgument(String arg) throws IOException {
                try {
                    return super.expandArgument(arg);
                }
                catch (PathNotFoundException e) {
                    if (!this.ignoreFNF) {
                        throw e;
                    }
                    return new LinkedList<PathData>();
                }
            }

            protected void processNonexistentPath(PathData item) throws IOException {
                if (!this.ignoreFNF) {
                    super.processNonexistentPath(item);
                }
            }

            protected void processPath(PathData item) throws IOException {
                if (item.stat.isDirectory() && !this.deleteDirs) {
                    throw new PathIsDirectoryException(item.toString());
                }
                if (this.moveToTrash(item) || !this.canBeSafelyDeleted(item)) {
                    return;
                }
                if (item.fs instanceof AbstractJindoShimsFileSystem && ((AbstractJindoShimsFileSystem)item.fs).isCacheMode() != false ? !((AbstractJindoShimsFileSystem)item.fs).delete(item.path, this.deleteDirs, true) : !item.fs.delete(item.path, this.deleteDirs)) {
                    throw new PathIOException(item.toString());
                }
                this.out.println("Deleted " + item);
            }

            private boolean canBeSafelyDeleted(PathData item) throws IOException {
                ContentSummary cs;
                long numFiles;
                long deleteLimit;
                boolean shouldDelete = true;
                if (this.safeDelete && (deleteLimit = this.getConf().getLong("hadoop.shell.safely.delete.limit.num.files", 100L)) > 0L && (numFiles = (cs = item.fs.getContentSummary(item.path)).getFileCount()) > deleteLimit && !ToolRunner.confirmPrompt((String)("Proceed deleting " + numFiles + " files?"))) {
                    System.err.println("Delete aborted at user request.\n");
                    shouldDelete = false;
                }
                return shouldDelete;
            }

            private boolean moveToTrash(PathData item) throws IOException {
                boolean success = false;
                if (!this.skipTrash) {
                    try {
                        success = Trash.moveToAppropriateTrash((FileSystem)item.fs, (Path)item.path, (Configuration)this.getConf());
                    }
                    catch (FileNotFoundException fnfe) {
                        throw fnfe;
                    }
                    catch (IOException ioe) {
                        String msg = ioe.getMessage();
                        if (ioe.getCause() != null) {
                            msg = msg + ": " + ioe.getCause().getMessage();
                        }
                        throw new IOException(msg + ". Consider using -skipTrash option", ioe);
                    }
                }
                return success;
            }
        }
    }
}

