/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot.protocols;

import bigboot.protocol.type.CltOssDeleteObjectsRequest;
import bigboot.protocol.type.DeleteKeySummary;
import bigboot.protocol.type.DeleteKeySummaryList;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.alibaba.jboot.google.flatbuffers.JbootFlatBufferBuilder;
import com.alibaba.jboot.protocols.JniRequestWrapper;
import com.alibaba.jfs.CredentialContext;
import java.nio.ByteBuffer;
import java.util.List;

public class OssDeleteObjectsRequestWrapper
extends JniRequestWrapper {
    private String bucket;
    private List<String> objects;
    private boolean quiet;

    public OssDeleteObjectsRequestWrapper(String bucket, List<String> objects, boolean quiet, CredentialContext ossContext) {
        this.objects = objects;
        this.bucket = bucket;
        this.quiet = quiet;
        this.ossContext = ossContext;
    }

    @Override
    protected ByteBuffer toFbBuffer() {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int objectListOffset = this.getObjectList(builder);
        int bucketOffset = ((FlatBufferBuilder)builder).createString(this.bucket);
        int requestHeaderOffset = this.getRequestHeader(builder, EMPTY_NS_NAME, null);
        CltOssDeleteObjectsRequest.startCltOssDeleteObjectsRequest(builder);
        CltOssDeleteObjectsRequest.addBucketName(builder, bucketOffset);
        CltOssDeleteObjectsRequest.addObjectList(builder, objectListOffset);
        CltOssDeleteObjectsRequest.addQuiet(builder, this.quiet);
        CltOssDeleteObjectsRequest.addRequestHeader(builder, requestHeaderOffset);
        builder.finish(CltOssDeleteObjectsRequest.endCltOssDeleteObjectsRequest(builder));
        ByteBuffer buffer = builder.dataBuffer();
        return buffer;
    }

    private int getObjectList(FlatBufferBuilder requestBuilder) {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int size = this.objects.size();
        int[] objectOffsets = new int[size];
        for (int i = 0; i < this.objects.size(); ++i) {
            int keyOffset = ((FlatBufferBuilder)builder).createString(this.objects.get(i));
            int versionIdOffset = ((FlatBufferBuilder)builder).createString("");
            objectOffsets[i] = DeleteKeySummary.createDeleteKeySummary(builder, keyOffset, versionIdOffset);
        }
        int listOffset = builder.createVectorOfTables(objectOffsets);
        DeleteKeySummaryList.startDeleteKeySummaryList(builder);
        DeleteKeySummaryList.addObjects(builder, listOffset);
        builder.finish(DeleteKeySummaryList.endDeleteKeySummaryList(builder));
        return requestBuilder.createString(builder.dataBuffer());
    }
}

