/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.auth;

import com.aliyun.emr.fs.auth.AliyunCredentials;
import com.aliyun.emr.fs.auth.AliyunCredentialsProvider;
import com.aliyun.emr.fs.auth.CredentialInitializationException;
import com.aliyun.emr.shade.google_guava.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
public abstract class AbstractSessionCredentialsProvider
implements AliyunCredentialsProvider {
    private final URI binding;
    private final Configuration conf;
    private final AliyunCredentialsProvider.CredentialType type;
    private AliyunCredentials aliyunCredentials;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private IOException initializationException;

    public AbstractSessionCredentialsProvider(@Nullable URI uri, Configuration conf, AliyunCredentialsProvider.CredentialType type) {
        this.conf = conf;
        this.binding = uri;
        this.type = type;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void refresh() {
    }

    public URI getUri() {
        return this.binding;
    }

    public AliyunCredentialsProvider.CredentialType getType() {
        return this.type;
    }

    protected void init() throws IOException {
        if (this.initialized.getAndSet(true)) {
            return;
        }
        try {
            this.aliyunCredentials = this.createCredentials(this.getConf());
        }
        catch (IOException e) {
            this.initializationException = e;
            throw e;
        }
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    protected abstract AliyunCredentials createCredentials(Configuration var1) throws IOException;

    @Override
    public AliyunCredentials getCredentials() throws CredentialInitializationException {
        try {
            if (!this.isInitialized()) {
                this.init();
            }
        }
        catch (IOException e) {
            throw new CredentialInitializationException(e.getMessage(), e);
        }
        if (this.aliyunCredentials == null) {
            throw new CredentialInitializationException("Provider " + this + " has no credentials");
        }
        return this.aliyunCredentials;
    }

    public final boolean hasCredentials() {
        return this.aliyunCredentials == null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @VisibleForTesting
    public IOException getInitializationException() {
        return this.initializationException;
    }
}

