/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.auth.delegation;

import com.aliyun.emr.fs.auth.AliyunCredentialProviderList;
import com.aliyun.emr.fs.auth.delegation.AbstractDTService;
import com.aliyun.emr.fs.auth.delegation.AbstractOssTokenIdentifier;
import com.aliyun.emr.fs.auth.delegation.DelegationTokenIOException;
import com.aliyun.emr.fs.auth.delegation.OssDelegationTokens;
import com.aliyun.emr.fs.common.DurationInfo;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDelegationTokenBinding
extends AbstractDTService {
    private final Text kind;
    private SecretManager<AbstractOssTokenIdentifier> secretManager;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDelegationTokenBinding.class);

    protected AbstractDelegationTokenBinding(String name, Text kind) {
        super(name);
        this.kind = Objects.requireNonNull(kind);
    }

    public Text getKind() {
        return this.kind;
    }

    public Text getOwnerText() {
        return new Text(this.getOwner().getUserName());
    }

    public OssDelegationTokens.TokenIssuingPolicy getTokenIssuingPolicy() {
        return OssDelegationTokens.TokenIssuingPolicy.RequestNewToken;
    }

    public Token<AbstractOssTokenIdentifier> createDelegationToken(Text renewer) throws IOException {
        this.requireServiceStarted();
        AbstractOssTokenIdentifier tokenIdentifier = this.createTokenIdentifier(renewer);
        if (tokenIdentifier != null) {
            Token token = new Token((TokenIdentifier)tokenIdentifier, this.secretManager);
            token.setKind(this.getKind());
            LOG.debug("Created token {} with token identifier {}", (Object)token, (Object)tokenIdentifier);
            return token;
        }
        return null;
    }

    public abstract AbstractOssTokenIdentifier createTokenIdentifier(Text var1) throws IOException;

    protected <T extends AbstractOssTokenIdentifier> T convertTokenIdentifier(AbstractOssTokenIdentifier identifier, Class<T> expectedClass) throws DelegationTokenIOException {
        if (!((Object)((Object)identifier)).getClass().equals(expectedClass)) {
            throw new DelegationTokenIOException("Delegation token is wrong class; expected a token identifier of type " + expectedClass + " but got " + ((Object)((Object)identifier)).getClass() + " and kind " + identifier.getKind());
        }
        return (T)((Object)identifier);
    }

    public abstract AliyunCredentialProviderList deployUnbonded() throws IOException;

    public abstract AliyunCredentialProviderList bindToTokenIdentifier(AbstractOssTokenIdentifier var1) throws IOException;

    public abstract AbstractOssTokenIdentifier createEmptyIdentifier();

    public String toString() {
        return super.toString() + " token kind = " + this.getKind();
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.secretManager = this.createSecretMananger();
    }

    public String getDescription() {
        return "Token binding " + this.getKind().toString();
    }

    protected SecretManager<AbstractOssTokenIdentifier> createSecretMananger() throws IOException {
        return new TokenSecretManager();
    }

    public String getUserAgentField() {
        return "";
    }

    protected static byte[] getSecretManagerPasssword() {
        return "non-password".getBytes(Charset.forName("UTF-8"));
    }

    protected class TokenSecretManager
    extends SecretManager<AbstractOssTokenIdentifier> {
        protected TokenSecretManager() {
        }

        protected byte[] createPassword(AbstractOssTokenIdentifier identifier) {
            return AbstractDelegationTokenBinding.getSecretManagerPasssword();
        }

        public byte[] retrievePassword(AbstractOssTokenIdentifier identifier) throws SecretManager.InvalidToken {
            return AbstractDelegationTokenBinding.getSecretManagerPasssword();
        }

        public AbstractOssTokenIdentifier createIdentifier() {
            try (DurationInfo ignored = new DurationInfo(LOG, true, "Creating Delegation Token Identifier", new Object[0]);){
                AbstractOssTokenIdentifier abstractOssTokenIdentifier = AbstractDelegationTokenBinding.this.createEmptyIdentifier();
                return abstractOssTokenIdentifier;
            }
        }
    }
}

