/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.common;

import java.net.URI;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);

    public static String pathToKey(Path path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute: " + path);
        }
        String absolutePath = path.toUri().getPath();
        return absolutePath;
    }

    public static String pathToJindoPath(Path path) {
        String rawPath;
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute: " + path);
        }
        StringBuffer sb = new StringBuffer();
        String scheme = path.toUri().getScheme();
        if (scheme != null) {
            sb.append(scheme);
            sb.append(':');
        }
        if ((rawPath = path.toUri().getRawPath()) == null) {
            sb.append(path.toUri().getSchemeSpecificPart());
        } else {
            String host = path.toUri().getHost();
            String rawAuthority = path.toUri().getRawAuthority();
            if (host != null) {
                int port;
                boolean needBrackets;
                sb.append("//");
                String rawUserInfo = path.toUri().getRawUserInfo();
                if (rawUserInfo != null) {
                    sb.append(path.toUri().getUserInfo());
                    sb.append('@');
                }
                boolean bl = needBrackets = host.indexOf(58) >= 0 && !host.startsWith("[") && !host.endsWith("]");
                if (needBrackets) {
                    sb.append('[');
                }
                sb.append(host);
                if (needBrackets) {
                    sb.append(']');
                }
                if ((port = path.toUri().getPort()) != -1) {
                    sb.append(':');
                    sb.append(port);
                }
            } else if (rawAuthority != null) {
                sb.append("//");
                sb.append(path.toUri().getAuthority());
            }
            String p = path.toUri().getRawPath();
            if (p != null) {
                sb.append(path.toUri().getPath());
            }
        }
        return sb.toString();
    }

    public static String maybeAddTrailingSlash(String key) {
        if (!key.isEmpty() && !key.endsWith("/")) {
            return key + '/';
        }
        return key;
    }

    public static Path qualifyPath(Path f, URI defaultUri, Path workingDir) {
        Path qualifiedPath = f.makeQualified(defaultUri, workingDir);
        String scheme = defaultUri.getScheme();
        String authority = defaultUri.getAuthority();
        String path = qualifiedPath.toUri().getPath();
        return new Path(scheme, authority, path);
    }
}

