/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.hdfs;

import com.aliyun.emr.fs.hdfs.HdfsFileContext;
import com.aliyun.emr.fs.hdfs.JindoHdfsStreamHook;
import com.aliyun.emr.shade.apache_http.HttpEntity;
import com.aliyun.emr.shade.apache_http.HttpResponse;
import com.aliyun.emr.shade.apache_http.client.HttpClient;
import com.aliyun.emr.shade.apache_http.client.entity.UrlEncodedFormEntity;
import com.aliyun.emr.shade.apache_http.client.methods.HttpPost;
import com.aliyun.emr.shade.apache_http.client.methods.HttpUriRequest;
import com.aliyun.emr.shade.apache_http.impl.client.HttpClients;
import com.aliyun.emr.shade.apache_http.message.BasicNameValuePair;
import com.aliyun.emr.shade.apache_http.util.EntityUtils;
import com.aliyun.emr.utils.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JindoHttpControlStreamHook
implements JindoHdfsStreamHook {
    public static final Logger LOG = LoggerFactory.getLogger(JindoHttpControlStreamHook.class);
    public static final String HTTP_SERVER_KEY = "fs.hdfs.cache.hook.http.server";
    public static final String HTTP_FACTOR_KEY = "fs.hdfs.cache.hook.http.factor";
    public static final int HTTP_FACTOR_DEFAULT = 100;
    public static final String HTTP_RETRIES_KEY = "fs.hdfs.cache.hook.http.retries";
    public static final int HTTP_RETRIES_DEFAULT = 10;
    public static final String HTTP_EXPECT_RESULT_KEY = "fs.hdfs.cache.hook.http.expect-result";
    public static final int HTTP_EXPECT_RESULT_DEFAULT = 200;
    public static final String HTTP_LOG_KEY = "fs.hdfs.cache.hook.http.log";
    public static final boolean HTTP_LOG_DEFAULT = true;
    public String httpControlServer = "";
    public int factor = 100;
    public int retries = 10;
    public int expect_result = 200;
    public boolean logged = true;
    Configuration conf;
    HttpClient client = HttpClients.createDefault();

    @Override
    public void doBeforeRead(HdfsFileContext context, long requestSize) throws IOException {
        this.request(context, requestSize);
    }

    @Override
    public void doBeforeWrite(HdfsFileContext context, long requestSize) throws IOException {
        this.request(context, requestSize);
    }

    @Override
    public void close() {
    }

    private String generatePostData(long bufferSize) {
        int dataSize = (int)(bufferSize / (long)this.factor);
        return StringUtils.repeat("0", dataSize);
    }

    private void request(HdfsFileContext context, long requestSize) throws IOException {
        int currentRetried = 0;
        int returnCode = -1;
        while (currentRetried < this.retries && returnCode != this.expect_result) {
            HttpPost httpPost = new HttpPost(this.httpControlServer);
            httpPost.setHeader("Content-Type", "Application/EMR");
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            String value = this.generatePostData(requestSize);
            params.add(new BasicNameValuePair("sample", value));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            StopWatch stopWatch = new StopWatch().start();
            HttpResponse response = this.client.execute((HttpUriRequest)httpPost);
            long costTime = stopWatch.stop().now(TimeUnit.MILLISECONDS);
            returnCode = response.getStatusLine().getStatusCode();
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            if (!this.logged) continue;
            LOG.info("Took {}ms to request remote stream:{}, request_size:{}/{}, retried:{}, return_code:{}\uff0cresponse:{}", new Object[]{costTime, context.pathKey, requestSize, this.factor, currentRetried++, returnCode, responseStr});
        }
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.httpControlServer = conf.get(HTTP_SERVER_KEY);
        this.factor = conf.getInt(HTTP_FACTOR_KEY, 100);
        this.retries = conf.getInt(HTTP_RETRIES_KEY, 10);
        this.expect_result = conf.getInt(HTTP_EXPECT_RESULT_KEY, 200);
        this.logged = conf.getBoolean(HTTP_LOG_KEY, true);
    }

    public Configuration getConf() {
        return this.conf;
    }
}

