/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.jfs;

import bigboot.protocol.type.BlockInfoList;
import bigboot.protocol.type.CltFileChecksumReply;
import bigboot.protocol.type.ConfigurationInfo;
import bigboot.protocol.type.FileletCreateReply;
import bigboot.protocol.type.FileletOpenReply;
import bigboot.protocol.type.FileletStatus;
import bigboot.protocol.type.FileletStatusList;
import bigboot.protocol.type.FileletSummary;
import bigboot.protocol.type.FileletXattributeList;
import bigboot.protocol.type.NamespaceInfo;
import bigboot.protocol.type.NsAuditLogInfo;
import bigboot.protocol.type.Xattribute;
import com.alibaba.jboot.JbootFuture;
import com.alibaba.jboot.JbootJfsReader;
import com.alibaba.jboot.JbootJfsWriter;
import com.alibaba.jboot.JbootStorage;
import com.alibaba.jboot.JbootUtils;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.alibaba.jboot.exception.ShouldReturnFalseException;
import com.alibaba.jboot.future.ByteBufferFuture;
import com.alibaba.jboot.protocols.AuditLogInfoRequestWrapper;
import com.alibaba.jboot.protocols.ClientArchiveRequestWrapper;
import com.alibaba.jboot.protocols.ClientCacheRequestWrapper;
import com.alibaba.jboot.protocols.ClientCheckPermissionRequestWrapper;
import com.alibaba.jboot.protocols.ClientUnarchiveRequestWrapper;
import com.alibaba.jboot.protocols.ClientUncacheRequestWrapper;
import com.alibaba.jboot.protocols.FileletClose2RequestWrapper;
import com.alibaba.jboot.protocols.FileletFinalizeRequestWrapper;
import com.alibaba.jboot.protocols.FileletListXattrsRequestWrapper;
import com.alibaba.jboot.protocols.FileletRenameRequestWrapper;
import com.alibaba.jboot.protocols.NamespaceInfoRequestWrapper;
import com.alibaba.jfs.JfsSystemBase;
import com.alibaba.jfs.JindoRequestPath;
import com.aliyun.emr.fs.common.AbstractJindoShimsFileSystem;
import com.aliyun.emr.fs.internal.ossnative.HadoopLoginUserInfo;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class JfsFileletSystem
extends JfsSystemBase {
    private JbootStorage jbootStorage = new JbootStorage();
    public long DEFAULT_FUTURE_TIMEOUT = 600L;

    public JfsFileletSystem() {
        super(new HadoopLoginUserInfo());
    }

    public FileletCreateReply create(JindoRequestPath path, boolean overWrite, ByteBuffer filelet, int bufferSize, JbootJfsWriter writer) throws IOException {
        return this.create(path, overWrite, filelet, bufferSize, writer, this.DEFAULT_FUTURE_TIMEOUT);
    }

    public boolean rename(String oldPath, String newPath, boolean appendName, boolean ignoreHidden) throws IOException {
        return this.rename(oldPath, newPath, appendName, ignoreHidden, this.DEFAULT_FUTURE_TIMEOUT);
    }

    public boolean delete(JindoRequestPath path, boolean isRecursive, boolean ignoreHidden) throws IOException {
        return this.delete(path, isRecursive, ignoreHidden, this.DEFAULT_FUTURE_TIMEOUT);
    }

    public FileletStatus getFileStatus(JindoRequestPath path) throws IOException {
        return this.getFileStatus(path, this.DEFAULT_FUTURE_TIMEOUT);
    }

    public FileletStatusList list(JindoRequestPath path, boolean isRecursive, boolean located, boolean isCmd, boolean reCacheLocation) throws IOException {
        return this.list(path, isRecursive, located, isCmd, reCacheLocation, this.DEFAULT_FUTURE_TIMEOUT);
    }

    public boolean finalizeFile(String iNodeId, JindoRequestPath path, long fileSize) throws IOException {
        return this.finalizeFile(iNodeId, path, fileSize, this.DEFAULT_FUTURE_TIMEOUT);
    }

    public Xattribute getXattr(JindoRequestPath path, String name) throws IOException {
        return this.getXattr(path, name, this.DEFAULT_FUTURE_TIMEOUT);
    }

    public boolean setXattr(JindoRequestPath path, String name, String value) throws IOException {
        return this.setXattr(path, name, value, this.DEFAULT_FUTURE_TIMEOUT);
    }

    public FileletXattributeList listXattrs(JindoRequestPath path) throws IOException {
        return this.listXattrs(path, this.DEFAULT_FUTURE_TIMEOUT);
    }

    public boolean removeXattr(JindoRequestPath path, String name) throws IOException {
        return this.removeXattr(path, name, false);
    }

    public boolean removeXattr(JindoRequestPath path, String name, boolean recursive) throws IOException {
        return this.removeXattr(path, name, recursive, this.DEFAULT_FUTURE_TIMEOUT);
    }

    public BlockInfoList getFileBlockLocations(JindoRequestPath path, long start, long len, int logicBlockSize) throws IOException {
        return this.getFileBlockLocations(path, start, len, logicBlockSize, this.DEFAULT_FUTURE_TIMEOUT);
    }

    public NamespaceInfo getNamespaceInfo(String nsName) throws IOException {
        return this.getNamespaceInfo(nsName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamespaceInfo getNamespaceInfo(String nsName, String nsAddress) throws IOException {
        ByteBuffer request = new NamespaceInfoRequestWrapper(this.ugi, nsName, nsAddress, null).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            ByteBuffer buffer = this.jbootStorage.getNamespaceInfo(request);
            if (buffer == null) {
                throw new IOException("Failed to get namespace info for " + nsName + ", please check if the name is correct and if the corresponding namespace is correctly configured");
            }
            rpc_succeed = true;
            NamespaceInfo nsInfo = NamespaceInfo.getRootAsNamespaceInfo(buffer);
            if (nsInfo != null && !nsInfo.valid()) {
                throw new IOException(nsInfo.errorText());
            }
            NamespaceInfo namespaceInfo = nsInfo;
            return namespaceInfo;
        }
        finally {
            if (request != null && rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NsAuditLogInfo getNamespaceSysInfoBucket() throws IOException {
        ByteBuffer request = new AuditLogInfoRequestWrapper().toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            ByteBuffer buffer = this.jbootStorage.getSysInfoBucket(request);
            if (buffer == null) {
                throw new IOException("Failed to get audit log Info");
            }
            rpc_succeed = true;
            NsAuditLogInfo nsAuditLogInfo = NsAuditLogInfo.getRootAsNsAuditLogInfo(buffer);
            return nsAuditLogInfo;
        }
        finally {
            if (request != null && rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    public List<NamespaceInfo> getNamespaceInfoList() throws IOException {
        ByteBuffer buffer = this.jbootStorage.getNamespaceInfoList();
        if (buffer == null) {
            throw new IOException("Failed to get namespace info, please check if the name is correct and if the corresponding namespace is correctly configured");
        }
        ConfigurationInfo nsInfoListObj = ConfigurationInfo.getRootAsConfigurationInfo(buffer);
        ArrayList<NamespaceInfo> nsInfoList = new ArrayList<NamespaceInfo>();
        for (int i = 0; i < nsInfoListObj.namespaceInfosLength(); ++i) {
            NamespaceInfo nsInfo = nsInfoListObj.namespaceInfos(i);
            nsInfoList.add(nsInfo);
        }
        return nsInfoList;
    }

    /*
     * Exception decompiling
     */
    public CltFileChecksumReply getFileChecksum(JindoRequestPath path, byte checksumAlgorithm, long blockSize, long timeoutInSeconds) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String create(JindoRequestPath path, boolean overWrite, ByteBuffer filelet, long timeoutInSeconds) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public FileletCreateReply create(JindoRequestPath path, boolean overWrite, ByteBuffer filelet, int bufferSize, JbootJfsWriter writer, long timeoutInSeconds) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public FileletOpenReply open(JindoRequestPath path, JbootJfsReader reader, boolean ossOnly, boolean dataVerify, int bufferSize, String inodeId, long size, long timeoutInSeconds) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    public boolean rename(String oldPath, String newPath, boolean appendName, boolean ignoreHidden, long timeoutInSeconds) throws IOException {
        ByteBuffer request = new FileletRenameRequestWrapper(this.ugi, new JindoRequestPath(oldPath, null), newPath, appendName, ignoreHidden).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            JbootFuture jbootFuture;
            int retryCount = 0;
            JbootFuture future = jbootFuture = this.jbootStorage.rename(request);
            try {
                JbootFuture.checkFuture(future, timeoutInSeconds);
                rpc_succeed = true;
                JbootUtils.logRetrySuccess("rename", retryCount);
                boolean bl = true;
                return bl;
            }
            catch (ShouldReturnFalseException e) {
                boolean bl;
                block9: {
                    JbootUtils.logRetrySuccess("rename", retryCount);
                    bl = false;
                    if (!rpc_succeed) break block9;
                    JbootBufferFactory.returnBuffer(request);
                }
                return bl;
            }
            catch (IOException e) {
                IOException lastException = e;
                throw lastException;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean delete(JindoRequestPath path, boolean isRecursive, boolean ignoreHidden, long timeoutInSeconds) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public FileletStatus getFileStatus(JindoRequestPath path, long timeoutInSeconds) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public FileletSummary getContentSummary(JindoRequestPath path, long timeoutInSeconds) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public FileletStatusList list(JindoRequestPath path, boolean isRecursive, boolean located, boolean isCmd, boolean reCacheLocation, long timeoutInSeconds) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean finalizeFile(String iNodeId, JindoRequestPath path, long fileSize, long timeoutInSeconds) throws IOException {
        ByteBuffer request = new FileletFinalizeRequestWrapper(this.ugi, path, iNodeId, fileSize).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            JbootFuture jbootFuture;
            int retryCount = 0;
            JbootFuture future = jbootFuture = this.jbootStorage.finalizeFile(request);
            try {
                rpc_succeed = true;
                JbootFuture.checkFuture(future, timeoutInSeconds);
                JbootUtils.logRetrySuccess("finalizeFile", retryCount);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                IOException lastException = e;
                throw lastException;
            }
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public Xattribute getXattr(JindoRequestPath path, String key, long timeoutInSeconds) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean setXattr(JindoRequestPath path, String key, String value, long timeoutInSeconds) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FileletXattributeList listXattrs(JindoRequestPath path, long timeoutInSeconds) throws IOException {
        ByteBuffer request = new FileletListXattrsRequestWrapper(this.ugi, path).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            int retryCount = 0;
            ByteBufferFuture future = new ByteBufferFuture(this.jbootStorage.listXattrs(request));
            try {
                rpc_succeed = true;
                ByteBuffer ret = future.get(timeoutInSeconds, TimeUnit.SECONDS);
                JbootUtils.logRetrySuccess("listXattrs", retryCount);
                FileletXattributeList fileletXattributeList = FileletXattributeList.getRootAsFileletXattributeList(ret);
                return fileletXattributeList;
            }
            catch (Exception e) {
                IOException lastException = new IOException(e);
                throw lastException;
            }
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean removeXattr(JindoRequestPath path, String name, boolean recursive, long timeoutInSeconds) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean setPermission(JindoRequestPath path, short permission, short permissionDelta, boolean recursive, int timeoutInSeconds) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean setOwner(JindoRequestPath path, String username, String groupName, boolean recursive, int timeoutInSeconds) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public BlockInfoList getFileBlockLocations(JindoRequestPath path, long start, long len, long logicBlockSize, long timeoutInSeconds) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IOException wrapIOException(ExecutionException ee) {
        if (ee.getCause() instanceof IOException) {
            return (IOException)ee.getCause();
        }
        return new IOException(ee.getCause());
    }

    public boolean checkPermission(JindoRequestPath path, boolean doCheckOwner, short parentAccess, short access, long timeoutInSeconds) throws IOException {
        ByteBuffer request = new ClientCheckPermissionRequestWrapper(this.ugi, path, doCheckOwner, parentAccess, access).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            JbootFuture jbootFuture;
            int retryCount = 0;
            JbootFuture future = jbootFuture = this.jbootStorage.checkPermission(request);
            try {
                JbootFuture.checkFuture(future, timeoutInSeconds);
                rpc_succeed = true;
                JbootUtils.logRetrySuccess("checkPermission", retryCount);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                IOException lastException = e;
                throw lastException;
            }
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    public boolean cache(JindoRequestPath path, AbstractJindoShimsFileSystem.CacheOpContext opContext, long timeoutInSeconds) throws IOException {
        ByteBuffer request = new ClientCacheRequestWrapper(this.ugi, path, opContext.shouldPin, opContext.shouldLoadMemory, opContext.sync, opContext.smallfile, opContext.fileBatchSize, opContext.replica).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            JbootFuture jbootFuture;
            int retryCount = 0;
            JbootFuture future = jbootFuture = this.jbootStorage.cache(request);
            try {
                JbootFuture.checkFuture(future, timeoutInSeconds);
                rpc_succeed = true;
                JbootUtils.logRetrySuccess("cache", retryCount);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                IOException lastException = e;
                throw lastException;
            }
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    public boolean uncache(JindoRequestPath path, long timeoutInSeconds) throws IOException {
        ByteBuffer request = new ClientUncacheRequestWrapper(this.ugi, path).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            JbootFuture jbootFuture;
            int retryCount = 0;
            JbootFuture future = jbootFuture = this.jbootStorage.uncache(request);
            try {
                JbootFuture.checkFuture(future, timeoutInSeconds);
                rpc_succeed = true;
                JbootUtils.logRetrySuccess("uncache", retryCount);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                IOException lastException = e;
                throw lastException;
            }
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    public boolean archive(JindoRequestPath path, Byte policy, long timeoutInSeconds) throws IOException {
        ByteBuffer request = new ClientArchiveRequestWrapper(this.ugi, path, policy).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            JbootFuture jbootFuture;
            int retryCount = 0;
            JbootFuture future = jbootFuture = this.jbootStorage.archive(request);
            try {
                JbootFuture.checkFuture(future, timeoutInSeconds);
                rpc_succeed = true;
                JbootUtils.logRetrySuccess("archive", retryCount);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                IOException lastException = e;
                throw lastException;
            }
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    public boolean unarchive(JindoRequestPath path, Byte policy, long timeoutInSeconds) throws IOException {
        ByteBuffer request = new ClientUnarchiveRequestWrapper(this.ugi, path, policy).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            JbootFuture jbootFuture;
            int retryCount = 0;
            JbootFuture future = jbootFuture = this.jbootStorage.unarchive(request);
            try {
                JbootFuture.checkFuture(future, timeoutInSeconds);
                rpc_succeed = true;
                JbootUtils.logRetrySuccess("unarchive", retryCount);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                IOException lastException = e;
                throw lastException;
            }
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public FileletStatusList checkProgress(JindoRequestPath path, boolean detailed, long timeoutInSeconds) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean close2(JindoRequestPath path, List<String> paths, List<String> fileIds, List<Long> sizes, String owner, String group, boolean abort, long timeoutInSeconds) throws IOException {
        ByteBuffer request = new FileletClose2RequestWrapper(this.ugi, path, paths, fileIds, sizes, owner, group, abort).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            JbootFuture jbootFuture;
            int retryCount = 0;
            JbootFuture future = jbootFuture = this.jbootStorage.close2(request);
            rpc_succeed = true;
            JbootFuture.checkFuture(future, timeoutInSeconds);
            JbootUtils.logRetrySuccess("close2", retryCount);
            boolean bl = true;
            return bl;
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }
}

