/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.jfs;

import bigboot.protocol.type.BlockInfo;
import bigboot.protocol.type.BlockInfoList;
import bigboot.protocol.type.CltArchiveDirReply;
import bigboot.protocol.type.CltFileChecksumReply;
import bigboot.protocol.type.CltRestoreDirReply;
import bigboot.protocol.type.CltUnarchiveDirReply;
import bigboot.protocol.type.FileletCreateReply;
import bigboot.protocol.type.FileletOpenReply;
import bigboot.protocol.type.FileletStatus;
import bigboot.protocol.type.FileletStatusList;
import bigboot.protocol.type.FileletSummary;
import bigboot.protocol.type.FileletXattributeList;
import bigboot.protocol.type.NssGetCryptoPolicyReply;
import bigboot.protocol.type.StoragePolicy;
import bigboot.protocol.type.StringList;
import bigboot.protocol.type.Xattribute;
import com.alibaba.jboot.JbootJfsReader;
import com.alibaba.jboot.JbootJfsWriter;
import com.alibaba.jboot.JbootNative;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.alibaba.jboot.google.flatbuffers.Table;
import com.alibaba.jfs.CredentialContext;
import com.alibaba.jfs.JindoRequestPath;
import com.aliyun.emr.fs.auth.AliyunCredentialProviderList;
import com.aliyun.emr.fs.auth.AliyunCredentialsProvider;
import com.aliyun.emr.fs.auth.AuthUtils;
import com.aliyun.emr.fs.common.AbstractJindoShimsFileSystem;
import com.aliyun.emr.fs.common.Utils;
import com.aliyun.emr.fs.internal.AbstractFileSystemStore;
import com.aliyun.emr.fs.internal.JindoCryptoPolicy;
import com.aliyun.emr.fs.internal.jfs.CompositeCrcFileChecksum;
import com.aliyun.emr.fs.internal.jfs.CompositePathInfo;
import com.aliyun.emr.fs.internal.jfs.Create2PathInfo;
import com.aliyun.emr.fs.internal.jfs.JfsFileStatus;
import com.aliyun.emr.fs.internal.jfs.JfsFileletSystem;
import com.aliyun.emr.fs.internal.jfs.JfsInputStream;
import com.aliyun.emr.fs.internal.jfs.JfsLocatedFileStatus;
import com.aliyun.emr.fs.internal.jfs.JfsOutputStream;
import com.aliyun.emr.fs.internal.ossnative.OssCredentialUtils;
import com.aliyun.emr.fs.jfs.Constants;
import com.aliyun.emr.fs.jfs.JfsAdminTool;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.MD5MD5CRC32CastagnoliFileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32GzipFileChecksum;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JfsStore
extends AbstractFileSystemStore {
    static final Logger LOG = LoggerFactory.getLogger(JfsStore.class);
    public static AtomicLong totalOssReadTime = new AtomicLong(0L);
    public static AtomicLong ossReadCount = new AtomicLong(0L);
    public static AtomicLong totalCacheReadTime = new AtomicLong(0L);
    public static AtomicLong cacheReadCount = new AtomicLong(0L);
    private AliyunCredentialProviderList providers = null;
    private CredentialContext ossContext;
    private ConcurrentHashMap<String, JfsOutputStream.WriteContext> path2InodeIdMap = new ConcurrentHashMap();
    private boolean enableBlockLocation;
    private int jbootWriterBufferSize;
    private int jbootReaderBufferSize;
    private boolean enableDirectUpload;
    private boolean readOssOnly;
    private int timeoutInSecond;
    private int getSummaryTimeoutInSecond;
    private long logicBlockSize;
    private boolean reCacheLocation;
    private byte checksumAlgorithm;
    private boolean dataVerify;
    private boolean enableFlush;
    private int readOssPercent;
    private Random rand;
    private Context context;

    public static String getOssAverage() {
        long time = totalOssReadTime.get();
        long count = ossReadCount.get();
        if (count <= 0L) {
            return "<none>";
        }
        return Long.toString(time / count) + " us";
    }

    public static String getCacheAverage() {
        long time = totalCacheReadTime.get();
        long count = cacheReadCount.get();
        if (count <= 0L) {
            return "<none>";
        }
        return Long.toString(time / count) + " us";
    }

    public static String getOssPercent() {
        long cacheCount;
        long ossCount = ossReadCount.get();
        long totalCount = ossCount + (cacheCount = cacheReadCount.get());
        if (totalCount <= 0L) {
            return "<none>";
        }
        return Long.toString(100L * ossCount / totalCount) + "%";
    }

    public JfsStore(FileSystem fs, Configuration conf, Context context) throws IOException {
        super(fs, conf, context);
        this.context = context;
        try {
            String logName = JbootNative.instance().getLogName();
            LOG.info("Jboot log name is {}", (Object)logName);
            this.context.logName = logName;
        }
        catch (Throwable e) {
            LOG.info("NativeLibrary of Jindo is not available, you can ignore if you are not using jindo fs and cache.");
        }
        this.providers = AuthUtils.createAliyunCredentialProviderSet(context.uri, conf, AliyunCredentialsProvider.CredentialType.JFS);
        LOG.debug("Using credential provider {}", (Object)this.providers);
        this.ossContext = OssCredentialUtils.createOssCredentialContext(conf, context.uri, this.providers);
        this.enableBlockLocation = conf.getBoolean("fs.jfs.block.location.enable", true);
        int bufferSize = conf.getInt("fs.jfs.write.buffer.size", 0x100000);
        this.jbootWriterBufferSize = this.allignBufferSize(bufferSize);
        bufferSize = conf.getInt("fs.jfs.read.buffer.size", 0x100000);
        this.jbootReaderBufferSize = this.allignBufferSize(bufferSize);
        this.readOssOnly = conf.getBoolean("fs.jfs.read.oss-only", false);
        this.enableDirectUpload = conf.getBoolean("fs.jfs.direct.upload.enable", false);
        this.timeoutInSecond = conf.getInt("fs.jfs.timeout.second", 600);
        this.getSummaryTimeoutInSecond = conf.getInt("fs.jfs.summary.timeout.second", 3600);
        this.logicBlockSize = conf.getLong("fs.jfs.blocksize", Constants.FS_JFS_BLOCKSIZE_DEFAULT);
        this.dataVerify = conf.getBoolean("fs.jfs.data.verify.enable", true);
        this.reCacheLocation = conf.getBoolean("fs.jfs.list-located.recache.enable", true);
        this.enableFlush = conf.getBoolean("fs.jfs.flush.enable", true);
        this.readOssPercent = conf.getInt("fs.jfs.read.oss.percent", 0);
        if (this.readOssPercent < 0) {
            this.readOssPercent = 0;
        } else if (this.readOssPercent > 100) {
            this.readOssPercent = 100;
        }
        this.rand = new Random();
        String checksumValue = conf.get("fs.jfs.checksum.combine.mode", "MD5MD5CRC");
        if (checksumValue.equals("MD5MD5CRC")) {
            this.checksumAlgorithm = 0;
        } else if (checksumValue.equals("COMPOSITE_CRC")) {
            this.checksumAlgorithm = 1;
        } else {
            LOG.warn("Invaild checksum mode configured {}, use default mode {}", (Object)checksumValue, (Object)"MD5MD5CRC");
            this.checksumAlgorithm = 0;
        }
        boolean usePool = conf.getBoolean("fs.jfs.buffer.pool", false);
        JbootBufferFactory.setUsePool(usePool);
        LOG.info("Write buffer size {}, read buffer size {}, logic block size {}", new Object[]{this.jbootWriterBufferSize, this.jbootReaderBufferSize, this.logicBlockSize});
    }

    @Override
    public void close() throws IOException {
        LOG.info("Read total statistics: oss read average {}, cache read average {}, read oss percent {}", new Object[]{JfsStore.getOssAverage(), JfsStore.getCacheAverage(), JfsStore.getOssPercent()});
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress, String storageOption) throws IOException {
        Create2PathInfo create2PathInfo = Create2PathInfo.decode(f);
        boolean isCreate2 = false;
        if (create2PathInfo != null) {
            f = create2PathInfo.realPath;
            isCreate2 = true;
        }
        JfsFileStatus status = JfsFileStatus.createStatus(f, permission, overwrite, bufferSize, replication, blockSize, this.conf);
        if (isCreate2) {
            status.setINodeId("create2_req");
        }
        ByteBuffer statusBuffer = JfsFileStatus.toBuffer(status);
        Path qualifiedPath = f.makeQualified(this.context.uri, this.context.workingDir);
        String pathStr = Utils.pathToJindoPath(qualifiedPath);
        if (isCreate2) {
            LOG.info("Create2 " + pathStr);
        }
        JindoRequestPath jindoRequestPath = new JindoRequestPath(pathStr, this.context.nsConnectorPtr, this.ossContext);
        JbootJfsWriter jbootWriter = new JbootJfsWriter(this.context.fileletSystem.getUgi(), jindoRequestPath);
        Table reply = null;
        try {
            reply = this.context.fileletSystem.create(jindoRequestPath, overwrite, statusBuffer, this.jbootWriterBufferSize, jbootWriter, this.timeoutInSecond);
            int realBufferSize = ((FileletCreateReply)reply).bufferSize();
            JfsOutputStream.WriteContext writeContext = new JfsOutputStream.WriteContext();
            String inodeId = ((FileletCreateReply)reply).statusAsFileletStatus().inodeAsInodeStatus().fileId();
            if (isCreate2) {
                this.path2InodeIdMap.put(f.toString(), writeContext);
                LOG.info("path2InodeIdMap.put " + f.toString() + ", " + inodeId);
            }
            writeContext.iNodeId = inodeId;
            writeContext.path = qualifiedPath;
            writeContext.bufferSize = realBufferSize;
            writeContext.timeoutInSecond = this.timeoutInSecond;
            writeContext.enableDirectUpload = this.enableDirectUpload;
            writeContext.fileletSystem = this.context.fileletSystem;
            writeContext.jbootWriter = jbootWriter;
            writeContext.enableFlush = this.enableFlush;
            JfsOutputStream outputStream = new JfsOutputStream(writeContext);
            FSDataOutputStream fSDataOutputStream = new FSDataOutputStream((OutputStream)outputStream, this.context.statistics);
            return fSDataOutputStream;
        }
        finally {
            if (reply != null) {
                JbootBufferFactory.returnBuffer(reply.getByteBuffer());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(Path f, boolean recursive, boolean ignoreHidden, boolean deleteVersion) throws IOException {
        f = CompositePathInfo.extractRealPath(f);
        Path qualifiedPath = f.makeQualified(this.context.uri, this.context.workingDir);
        String path = Utils.pathToJindoPath(qualifiedPath);
        boolean result = false;
        try {
            LOG.debug("Delete Filelet start. path: {}, isRecursive {}. Log name: {}", new Object[]{path, recursive, this.context.logName});
            result = this.context.fileletSystem.delete(new JindoRequestPath(path, this.context.nsConnectorPtr, this.ossContext), recursive, ignoreHidden, this.timeoutInSecond);
        }
        catch (Throwable throwable) {
            LOG.debug("Delete Filelet end. path: {}, isRecursive: {}, result:{}.", new Object[]{path, recursive, result});
            throw throwable;
        }
        LOG.debug("Delete Filelet end. path: {}, isRecursive: {}, result:{}.", new Object[]{path, recursive, result});
        return result;
    }

    @Override
    public JfsFileStatus getFileStatus(Path f) throws IOException {
        CompositePathInfo compositePathInfo = CompositePathInfo.decode(f);
        if (compositePathInfo != null) {
            JfsFileStatus status = JfsFileStatus.createStatus(f, compositePathInfo.inodeId, compositePathInfo.fileSize, this.conf);
            return status;
        }
        Table status = null;
        try {
            Path qualifiedPath = f.makeQualified(this.context.uri, this.context.workingDir);
            String pathStr = Utils.pathToJindoPath(qualifiedPath);
            LOG.debug("Get FileletStatus start. path: {}. Log name: {}", (Object)pathStr, (Object)this.context.logName);
            status = this.context.fileletSystem.getFileStatus(new JindoRequestPath(pathStr, this.context.nsConnectorPtr, this.ossContext), this.timeoutInSecond);
            LOG.debug("Get FileletStatus end. path: {}, fid: {}.", (Object)pathStr, status != null ? ((FileletStatus)status).inodeAsInodeStatus().fileId() : null);
            if (!((FileletStatus)status).inodeAsInodeStatus().fileId().isEmpty()) {
                JfsFileStatus ret;
                JfsFileStatus jfsFileStatus = ret = new JfsFileStatus(((FileletStatus)status).inodeAsInodeStatus(), this.fs, this.conf);
                return jfsFileStatus;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (status != null && status.getByteBuffer() != null) {
                JbootBufferFactory.returnBuffer(status.getByteBuffer());
            }
        }
        throw new FileNotFoundException(f.getName());
    }

    @Override
    public ContentSummary getContentSummary(Path qualifiedPath) throws IOException {
        String pathStr = Utils.pathToJindoPath(qualifiedPath);
        Table fileletSummary = null;
        try {
            fileletSummary = this.context.fileletSystem.getContentSummary(new JindoRequestPath(pathStr, this.context.nsConnectorPtr, this.ossContext), this.getSummaryTimeoutInSecond);
            if (fileletSummary != null) {
                ContentSummary contentSummary = new ContentSummary(((FileletSummary)fileletSummary).fileLength(), ((FileletSummary)fileletSummary).fileCount(), ((FileletSummary)fileletSummary).directoryCount(), -1L, ((FileletSummary)fileletSummary).fileLength(), -1L);
                return contentSummary;
            }
            ContentSummary contentSummary = new ContentSummary();
            return contentSummary;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (fileletSummary != null && fileletSummary.getByteBuffer() != null) {
                JbootBufferFactory.returnBuffer(fileletSummary.getByteBuffer());
            }
        }
    }

    @Override
    public FileChecksum getFileChecksum(Path path) throws IOException {
        return this.getFileChecksum2(path);
    }

    @Override
    public FileChecksum getFileChecksum2(Path path) throws IOException {
        return this.getFileChecksum2(path, 0x8000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileChecksum getFileChecksum2(Path path, long blockSize) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String pathStr = Utils.pathToJindoPath(qualifiedPath);
        Table reply = null;
        try {
            reply = this.context.fileletSystem.getFileChecksum(new JindoRequestPath(pathStr, this.context.nsConnectorPtr, this.ossContext), this.checksumAlgorithm, blockSize, this.timeoutInSecond);
            if (this.checksumAlgorithm == 0) {
                ByteBuffer crcByteBuffer = ((CltFileChecksumReply)reply).md5CrcAsByteBuffer();
                byte[] crcBytes = new byte[crcByteBuffer.remaining()];
                crcByteBuffer.get(crcBytes);
                MD5Hash fileMD5 = new MD5Hash(crcBytes);
                if (((CltFileChecksumReply)reply).bytesPerCrc() == 0) {
                    MD5MD5CRC32GzipFileChecksum mD5MD5CRC32GzipFileChecksum = new MD5MD5CRC32GzipFileChecksum(0, 0L, fileMD5);
                    return mD5MD5CRC32GzipFileChecksum;
                }
                long fileSize = ((CltFileChecksumReply)reply).fileSize();
                long blockNum = (fileSize - 1L) / blockSize + 1L;
                long crcPerBlock = blockNum > 1L ? blockSize / (long)((CltFileChecksumReply)reply).bytesPerCrc() : 0L;
                MD5MD5CRC32CastagnoliFileChecksum mD5MD5CRC32CastagnoliFileChecksum = new MD5MD5CRC32CastagnoliFileChecksum(((CltFileChecksumReply)reply).bytesPerCrc(), crcPerBlock, fileMD5);
                return mD5MD5CRC32CastagnoliFileChecksum;
            }
            if (this.checksumAlgorithm == 1) {
                CompositeCrcFileChecksum compositeCrcFileChecksum = new CompositeCrcFileChecksum(((CltFileChecksumReply)reply).compositeCrc(), ((CltFileChecksumReply)reply).crcType(), ((CltFileChecksumReply)reply).bytesPerCrc());
                return compositeCrcFileChecksum;
            }
            FileChecksum fileChecksum = null;
            return fileChecksum;
        }
        finally {
            if (reply != null && reply.getByteBuffer() != null) {
                JbootBufferFactory.returnBuffer(reply.getByteBuffer());
            }
        }
    }

    @Override
    public FileStatus[] listStatus(Path f, boolean recursive, boolean isCmd) throws IOException {
        Path qualifiedPath = f.makeQualified(this.context.uri, this.context.workingDir);
        String pathStr = Utils.pathToJindoPath(qualifiedPath);
        LOG.debug("List Filelet start: {}, isRecursive: {}. Log name: {}", new Object[]{pathStr, recursive, this.context.logName});
        FileletStatusList list = this.context.fileletSystem.list(new JindoRequestPath(pathStr, this.context.nsConnectorPtr, this.ossContext), recursive, false, isCmd, false, this.timeoutInSecond);
        LOG.debug("List Filelet end: {}, isRecursive: {}, list size: {}", new Object[]{pathStr, recursive, list.filesLength()});
        FileStatus[] fileStatuses = new FileStatus[list.filesLength()];
        for (int i = 0; i < list.filesLength(); ++i) {
            fileStatuses[i] = new JfsFileStatus(list.files(i).inodeAsInodeStatus(), this.fs, this.conf);
        }
        JbootBufferFactory.returnBuffer(list.getByteBuffer());
        return fileStatuses;
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path f, PathFilter filter) throws IOException {
        Path qualifiedPath = f.makeQualified(this.context.uri, this.context.workingDir);
        String pathStr = Utils.pathToJindoPath(qualifiedPath);
        LOG.debug("List located Filelet start: {}, isRecursive: false. Log name: {}", (Object)pathStr, (Object)this.context.logName);
        FileletStatusList list = this.context.fileletSystem.list(new JindoRequestPath(pathStr, this.context.nsConnectorPtr, this.ossContext), false, true, false, this.reCacheLocation, this.timeoutInSecond);
        LOG.debug("List located Filelet end: {}, isRecursive: false, list size: {}", (Object)pathStr, (Object)list.filesLength());
        final ArrayList<JfsLocatedFileStatus> results = new ArrayList<JfsLocatedFileStatus>();
        for (int i = 0; i < list.filesLength(); ++i) {
            BlockInfoList blkList = null;
            try {
                blkList = BlockInfoList.getRootAsBlockInfoList(list.files(i).locationsAsByteBuffer());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            JfsLocatedFileStatus status = new JfsLocatedFileStatus(new JfsFileStatus(list.files(i).inodeAsInodeStatus(), this.fs, this.conf), this.getBlockLocation(blkList, list.files(i).inodeAsInodeStatus().fileSize()));
            if (!filter.accept(status.getPath())) continue;
            results.add(status);
        }
        JbootBufferFactory.returnBuffer(list.getByteBuffer());
        return new RemoteIterator<LocatedFileStatus>(){
            private final LocatedFileStatus[] stats;
            private int i;
            {
                this.stats = results.toArray(new JfsLocatedFileStatus[results.size()]);
                this.i = 0;
            }

            public boolean hasNext() {
                return this.i < this.stats.length;
            }

            public LocatedFileStatus next() throws IOException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more entry in " + f);
                }
                return this.stats[this.i++];
            }
        };
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        LOG.debug("Making dir '" + f + "' in JFS");
        Path qualifiedPath = f.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        JfsFileStatus status = JfsFileStatus.createStatusForDir(new Path(key), permission, this.conf);
        ByteBuffer statusBuffer = JfsFileStatus.toBuffer(status);
        try {
            LOG.debug("Create Filelet start: {}, Buffer: {}/{}. Log name: {}", new Object[]{key, statusBuffer.position(), statusBuffer.limit(), this.context.logName});
            String fid = this.context.fileletSystem.create(new JindoRequestPath(key, this.context.nsConnectorPtr, this.ossContext), true, statusBuffer, this.timeoutInSecond);
            LOG.debug("Create Filelet end: {}, Buffer: {}/{}, fid: {}.", new Object[]{key, statusBuffer.position(), statusBuffer.limit(), fid});
            this.context.statistics.incrementWriteOps(1);
            return true;
        }
        catch (java.nio.file.FileAlreadyExistsException e) {
            throw new FileAlreadyExistsException("Cannot make dir for path " + f.toString() + " since it is a file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        String inodeId = null;
        long fileSize = 0L;
        CompositePathInfo compositePathInfo = CompositePathInfo.decode(f);
        if (compositePathInfo != null) {
            inodeId = compositePathInfo.inodeId;
            fileSize = compositePathInfo.fileSize;
            f = compositePathInfo.realPath;
        }
        Table reply = null;
        try {
            int dice;
            Path qualifiedPath = f.makeQualified(this.context.uri, this.context.workingDir);
            String pathStr = Utils.pathToJindoPath(qualifiedPath);
            JindoRequestPath jindoRequestPath = new JindoRequestPath(pathStr, this.context.nsConnectorPtr, this.ossContext);
            JbootJfsReader jbootBlockletReader = new JbootJfsReader(this.context.fileletSystem.getUgi(), jindoRequestPath);
            boolean ossOnly = this.readOssOnly ? this.readOssOnly : (dice = this.rand.nextInt(100)) < this.readOssPercent;
            reply = this.context.fileletSystem.open(jindoRequestPath, jbootBlockletReader, ossOnly, this.dataVerify, this.jbootReaderBufferSize, inodeId, fileSize, this.timeoutInSecond);
            JfsFileStatus status = new JfsFileStatus(((FileletOpenReply)reply).statusAsFileletStatus().inodeAsInodeStatus(), this.fs, this.conf);
            int realBufferSize = ((FileletOpenReply)reply).bufferSize();
            JfsInputStream.JfsReadContext readContext = new JfsInputStream.JfsReadContext();
            readContext.path = qualifiedPath;
            readContext.bufferSize = realBufferSize;
            readContext.fileSize = status.getLen();
            readContext.iNodeId = status.getINodeId();
            int bufferNum = (int)(readContext.fileSize / (long)readContext.bufferSize);
            readContext.totalBuffers = readContext.fileSize % (long)readContext.bufferSize == 0L ? (long)bufferNum : (long)(bufferNum + 1);
            readContext.timeoutInSecond = this.timeoutInSecond;
            readContext.fileletSystem = this.context.fileletSystem;
            readContext.stats = this.context.statistics;
            readContext.blockletReader = jbootBlockletReader;
            readContext.readOssOnly = ossOnly;
            LOG.info("Average read statistics: oss read average {}, cache read average {}, current read oss only {}, read oss percent {}", new Object[]{JfsStore.getOssAverage(), JfsStore.getCacheAverage(), ossOnly, JfsStore.getOssPercent()});
            JfsInputStream fsInputStream = new JfsInputStream(readContext);
            FSDataInputStream fSDataInputStream = new FSDataInputStream((InputStream)((Object)fsInputStream));
            return fSDataInputStream;
        }
        finally {
            if (reply != null && reply.getByteBuffer() != null) {
                JbootBufferFactory.returnBuffer(reply.getByteBuffer());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean rename(Path src, Path dst, boolean appendName, boolean ignoreHidden) throws IOException {
        String dstKey;
        Path parent;
        String srcKey = Utils.pathToKey(src);
        if (srcKey.length() == 0) {
            return false;
        }
        for (parent = dst.getParent(); parent != null && !src.equals((Object)parent); parent = parent.getParent()) {
        }
        if (parent != null) {
            return false;
        }
        Path qualifiedSrcPath = src.makeQualified(this.context.uri, this.context.workingDir);
        Path qualifiedDstPath = dst.makeQualified(this.context.uri, this.context.workingDir);
        String srcPath = Utils.pathToJindoPath(qualifiedSrcPath);
        String dstPath = Utils.pathToJindoPath(qualifiedDstPath);
        try {
            JfsFileStatus srcFileStatus = this.getFileStatus(qualifiedSrcPath);
            boolean srcIsFile = srcFileStatus.isFile();
            if (qualifiedSrcPath.equals((Object)qualifiedDstPath)) {
                return srcIsFile;
            }
        }
        catch (FileNotFoundException e) {
            LOG.debug("src is not found, maybe an *");
        }
        try {
            boolean dstIsFile = this.getFileStatus(qualifiedDstPath).isFile();
            if (dstIsFile) {
                return false;
            }
            dstKey = new Path(qualifiedDstPath, qualifiedSrcPath.getName()).toString();
            Path dstName = new Path(qualifiedDstPath, qualifiedSrcPath.getName());
            qualifiedDstPath = Utils.qualifyPath(dstName, this.context.uri, this.context.workingDir);
        }
        catch (FileNotFoundException e) {
            dstKey = qualifiedDstPath.toString();
            try {
                if (this.getFileStatus(qualifiedDstPath.getParent()).isFile()) {
                    throw new IOException("Dst parent exists and is a file");
                }
            }
            catch (FileNotFoundException ex) {
                return false;
            }
        }
        if (Utils.maybeAddTrailingSlash(srcPath).equals(Utils.maybeAddTrailingSlash(dstKey))) {
            return true;
        }
        boolean result = false;
        try {
            LOG.debug("Rename Filelet start. oldPath: {}, newPath {}. Log name: {}", new Object[]{srcPath, dstPath, this.context.logName});
            result = this.context.fileletSystem.rename(srcPath, dstPath, appendName, ignoreHidden, this.timeoutInSecond);
        }
        catch (java.nio.file.FileAlreadyExistsException e) {
            LOG.debug("File alreadey exist for rename {} to {}", (Object)srcPath, (Object)dstPath);
            boolean bl = false;
            LOG.debug("Rename Filelet end. oldPath: {}, newPath: {}, result: {}.", new Object[]{srcPath, dstPath, result});
            return bl;
        }
        catch (FileNotFoundException e2) {
            LOG.debug("File not found for rename {} to {}", (Object)srcPath, (Object)dstPath);
            boolean bl = false;
            {
                catch (Throwable throwable) {
                    LOG.debug("Rename Filelet end. oldPath: {}, newPath: {}, result: {}.", new Object[]{srcPath, dstPath, result});
                    throw throwable;
                }
            }
            LOG.debug("Rename Filelet end. oldPath: {}, newPath: {}, result: {}.", new Object[]{srcPath, dstPath, result});
            return bl;
        }
        LOG.debug("Rename Filelet end. oldPath: {}, newPath: {}, result: {}.", new Object[]{srcPath, dstPath, result});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (!this.enableBlockLocation) {
            return null;
        }
        Path qualifiedPath = file.getPath().makeQualified(this.context.uri, this.context.workingDir);
        String path = Utils.pathToJindoPath(qualifiedPath);
        if (file == null) {
            LOG.debug("getFileBlockLocations({}, {}, {}) returned null", new Object[]{path, start, len});
            return null;
        }
        LOG.debug("GetFileBlockLocations file start : {}, {}, {}, {}", new Object[]{path, start, len, this.logicBlockSize});
        Table list = null;
        try {
            list = this.context.fileletSystem.getFileBlockLocations(new JindoRequestPath(path, this.context.nsConnectorPtr, this.ossContext), start, len, this.logicBlockSize, this.timeoutInSecond);
            Object[] blockLocations = this.getBlockLocation((BlockInfoList)list, file.getLen());
            LOG.debug("GetFileBlockLocations file end : {}, {}, {}, {} returned {}", new Object[]{path, start, len, this.logicBlockSize, Arrays.deepToString(blockLocations)});
            Object[] objectArray = blockLocations;
            return objectArray;
        }
        finally {
            if (list != null) {
                JbootBufferFactory.returnBuffer(list.getByteBuffer());
            }
        }
    }

    private BlockLocation[] getBlockLocation(BlockInfoList list, long fileSize) {
        if (list != null && list.blocksLength() > 0) {
            BlockLocation[] blockLocations = new BlockLocation[list.blocksLength()];
            for (int i = 0; i < list.blocksLength(); ++i) {
                BlockInfo info = list.blocks(i);
                ArrayList<String> hosts = new ArrayList<String>();
                ArrayList<String> names = new ArrayList<String>();
                StringList blockHosts = StringList.getRootAsStringList(info.locationsAsByteBuffer());
                for (int j = 0; j < blockHosts.stringsLength(); ++j) {
                    String ip;
                    String host;
                    String hostAndPort = blockHosts.strings(j);
                    String[] hostPort = hostAndPort.split(":");
                    String hostName = hostPort[0];
                    String port = hostPort.length > 1 ? hostPort[1] : "6101";
                    try {
                        InetAddress addr = InetAddress.getByName(hostName);
                        addr.getHostAddress();
                        host = addr.getHostName();
                        ip = addr.getHostAddress();
                    }
                    catch (Exception e) {
                        host = hostName;
                        ip = hostName;
                    }
                    String ipAndPort = ip + ":" + port;
                    hosts.add(host);
                    names.add(ipAndPort);
                }
                long blockOffset = info.start();
                long remainingSize = fileSize - blockOffset;
                long blockLength = Math.min(remainingSize, this.logicBlockSize);
                blockLocations[i] = new BlockLocation(names.toArray(new String[blockHosts.stringsLength()]), hosts.toArray(new String[blockHosts.stringsLength()]), blockOffset, blockLength);
                LOG.debug("Location for block " + i + " : " + ((Object)hosts).toString());
            }
            LOG.debug("Got location for " + list.blocksLength() + " blocks.");
            return blockLocations;
        }
        String[] name = new String[]{"localhost:6101"};
        String[] host = new String[]{"localhost"};
        return new BlockLocation[]{new BlockLocation(name, host, 0L, fileSize)};
    }

    @Override
    public byte[] getXAttr(Path path, String name) throws IOException {
        byte[] byArray;
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        Xattribute attr = null;
        try {
            LOG.debug("Get Filelet attr {} of path {}", (Object)name, (Object)key);
            attr = this.context.fileletSystem.getXattr(new JindoRequestPath(key, this.context.nsConnectorPtr, this.ossContext), name, this.timeoutInSecond);
            byArray = attr.value().getBytes();
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                LOG.debug("Get Filelet attr {} of path {} value {}", new Object[]{name, key, attr.value()});
                if (attr != null && attr.getByteBuffer() != null) {
                    JbootBufferFactory.returnBuffer(attr.getByteBuffer());
                }
                throw throwable;
            }
        }
        LOG.debug("Get Filelet attr {} of path {} value {}", new Object[]{name, key, attr.value()});
        if (attr != null && attr.getByteBuffer() != null) {
            JbootBufferFactory.returnBuffer(attr.getByteBuffer());
        }
        return byArray;
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        Table attrs = null;
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        try {
            LOG.debug("Get Filelet attrs of path {}", (Object)key);
            attrs = this.context.fileletSystem.listXattrs(new JindoRequestPath(key, this.context.nsConnectorPtr, this.ossContext), this.timeoutInSecond);
            for (int i = 0; i < ((FileletXattributeList)attrs).xattributesLength(); ++i) {
                result.put(((FileletXattributeList)attrs).xattributes(i).name(), ((FileletXattributeList)attrs).xattributes(i).value().getBytes());
            }
            HashMap<String, byte[]> i = result;
            return i;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            LOG.debug("Get Filelet attrs of path {} size {}", (Object)key, (Object)result.size());
            if (attrs != null && attrs.getByteBuffer() != null) {
                JbootBufferFactory.returnBuffer(attrs.getByteBuffer());
            }
        }
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        Table attrs = null;
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        try {
            LOG.debug("Get Filelet attrs of path {} with names size {}", (Object)key, (Object)names.size());
            attrs = this.context.fileletSystem.listXattrs(new JindoRequestPath(key, this.context.nsConnectorPtr, this.ossContext), this.timeoutInSecond);
            for (int i = 0; i < ((FileletXattributeList)attrs).xattributesLength(); ++i) {
                if (!names.contains(((FileletXattributeList)attrs).xattributes(i).name())) continue;
                result.put(((FileletXattributeList)attrs).xattributes(i).name(), ((FileletXattributeList)attrs).xattributes(i).value().getBytes());
            }
            HashMap<String, byte[]> i = result;
            return i;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            LOG.debug("Get Filelet attrs of path {} with names size {}", (Object)key, (Object)result.size());
            if (attrs != null && attrs.getByteBuffer() != null) {
                JbootBufferFactory.returnBuffer(attrs.getByteBuffer());
            }
        }
    }

    @Override
    public void setXAttr(Path path, String name, byte[] value) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        boolean result = false;
        try {
            LOG.debug("Set attr {} with {} of path {}", new Object[]{name, new String(value), key});
            result = this.context.fileletSystem.setXattr(new JindoRequestPath(key, this.context.nsConnectorPtr, this.ossContext), name, new String(value), this.timeoutInSecond);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                LOG.debug("Set attr {} with {} of path {} result {}", new Object[]{name, new String(value), key, result});
                throw throwable;
            }
        }
        LOG.debug("Set attr {} with {} of path {} result {}", new Object[]{name, new String(value), key, result});
    }

    @Override
    public List<String> listXAttrs(Path path) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        ArrayList<String> result = new ArrayList<String>();
        Table attrs = null;
        try {
            LOG.debug("List Filelet attrs of path {}", (Object)key);
            attrs = this.context.fileletSystem.listXattrs(new JindoRequestPath(key, this.context.nsConnectorPtr, this.ossContext), this.timeoutInSecond);
            for (int i = 0; i < ((FileletXattributeList)attrs).xattributesLength(); ++i) {
                result.add(((FileletXattributeList)attrs).xattributes(i).name());
            }
            ArrayList<String> i = result;
            return i;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            LOG.debug("List Filelet attrs of path {} size {}", (Object)key, (Object)result.size());
            if (attrs != null && attrs.getByteBuffer() != null) {
                JbootBufferFactory.returnBuffer(attrs.getByteBuffer());
            }
        }
    }

    @Override
    public void removeXAttr(Path path, String name) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        boolean result = false;
        try {
            LOG.debug("Remove attr {} of path {}", (Object)name, (Object)key);
            result = this.context.fileletSystem.removeXattr(new JindoRequestPath(key, this.context.nsConnectorPtr, this.ossContext), name, false, this.timeoutInSecond);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                LOG.debug("Remove attr {} of path {} result {}", new Object[]{name, key, result});
                throw throwable;
            }
        }
        LOG.debug("Remove attr {} of path {} result {}", new Object[]{name, key, result});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPermission(Path path, FsAction mode) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        boolean result = false;
        try {
            LOG.debug("checkPermission for path {}", (Object)key);
            result = this.context.fileletSystem.checkPermission(new JindoRequestPath(key, this.context.nsConnectorPtr, this.ossContext), false, (short)0, (short)mode.ordinal(), this.timeoutInSecond);
        }
        finally {
            LOG.info("checkPermission for path {} result {}", (Object)key, (Object)result);
        }
    }

    public void removeXAttr(Path path, String name, boolean recursive) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        boolean result = false;
        try {
            LOG.debug("Remove attr {} of path {}", (Object)name, (Object)key);
            result = this.context.fileletSystem.removeXattr(new JindoRequestPath(key, this.context.nsConnectorPtr, this.ossContext), name, recursive, this.timeoutInSecond);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                LOG.debug("Remove attr {} of path {} recursive {} result {}", new Object[]{name, key, recursive, result});
                throw throwable;
            }
        }
        LOG.debug("Remove attr {} of path {} recursive {} result {}", new Object[]{name, key, recursive, result});
    }

    @Override
    public void setPermission(Path path, FsPermission permission) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        boolean result = false;
        try {
            LOG.debug("setPermission for path {}", (Object)key);
            result = this.context.fileletSystem.setPermission(new JindoRequestPath(key, this.context.nsConnectorPtr, this.ossContext), permission.toShort(), (short)0, false, this.timeoutInSecond);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            LOG.info("setPermission for path {} result {}", (Object)key, (Object)result);
        }
    }

    @Override
    public void processPermissionDelta(Path path, short permission, short permissionDelta, boolean recursive) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        boolean result = false;
        try {
            LOG.debug("processPermissionDelta for path {}", (Object)key);
            result = this.context.fileletSystem.setPermission(new JindoRequestPath(key, this.context.nsConnectorPtr, this.ossContext), permission, permissionDelta, recursive, this.timeoutInSecond);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            LOG.info("processPermissionDelta for path {} result {}", (Object)key, (Object)result);
        }
    }

    @Override
    public void setOwner(Path path, String username, String groupName) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        boolean result = false;
        try {
            LOG.debug("setOwner for path {}, {}:{}", new Object[]{key, username, groupName});
            result = this.context.fileletSystem.setOwner(new JindoRequestPath(key, this.context.nsConnectorPtr, this.ossContext), username, groupName, false, this.timeoutInSecond);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                LOG.debug("setOwner for path {}, {}:{}, result {}", new Object[]{key, username, groupName, result});
                throw throwable;
            }
        }
        LOG.debug("setOwner for path {}, {}:{}, result {}", new Object[]{key, username, groupName, result});
    }

    @Override
    public void setOwner(Path path, String username, String groupName, boolean recursive) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        boolean result = false;
        try {
            LOG.debug("setOwner for path {}, {}:{}", new Object[]{key, username, groupName});
            result = this.context.fileletSystem.setOwner(new JindoRequestPath(key, this.context.nsConnectorPtr, this.ossContext), username, groupName, recursive, this.timeoutInSecond);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                LOG.debug("setOwner for path {}, {}:{}, result {}", new Object[]{key, username, groupName, result});
                throw throwable;
            }
        }
        LOG.debug("setOwner for path {}, {}:{}, result {}", new Object[]{key, username, groupName, result});
    }

    @Override
    public Boolean isMagicCommitEnabled() {
        return false;
    }

    @Override
    public void cache(Path path, AbstractJindoShimsFileSystem.CacheOpContext opContext) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        try {
            this.context.fileletSystem.cache(new JindoRequestPath(key, this.context.nsConnectorPtr, this.ossContext), opContext, 20000L);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to cache " + key);
            throw e;
        }
    }

    @Override
    public void uncache(Path path) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        try {
            this.context.fileletSystem.uncache(new JindoRequestPath(key, this.context.nsConnectorPtr, this.ossContext), 10000L);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to uncache " + key);
            throw e;
        }
    }

    @Override
    public void archive(Path path, Byte policy) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        try {
            this.context.fileletSystem.archive(new JindoRequestPath(key, this.context.nsConnectorPtr, this.ossContext), policy, 10000L);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to archive " + key + " policy " + StoragePolicy.name(policy.byteValue()));
            throw e;
        }
    }

    @Override
    public void unarchive(Path path, Byte policy) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        try {
            this.context.fileletSystem.unarchive(new JindoRequestPath(key, this.context.nsConnectorPtr, this.ossContext), policy, 10000L);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to unarchive " + key + " policy " + StoragePolicy.name(policy.byteValue()));
            throw e;
        }
    }

    @Override
    public FileletStatus[] checkProgress(Path path, boolean detailed) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        try {
            FileletStatusList list = this.context.fileletSystem.checkProgress(new JindoRequestPath(key, this.context.nsConnectorPtr, this.ossContext), detailed, 10000L);
            FileletStatus[] fileStatuses = new FileletStatus[list.filesLength()];
            for (int i = 0; i < list.filesLength(); ++i) {
                fileStatuses[i] = list.files(i);
            }
            JbootBufferFactory.returnBuffer(list.getByteBuffer());
            return fileStatuses;
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to checkProgress " + key);
            return null;
        }
    }

    public Path composeClosePath(Path realPath) throws IOException {
        JfsOutputStream.WriteContext writeContext = this.path2InodeIdMap.get(realPath.toString());
        if (writeContext == null) {
            throw new IOException("Failed to composeClosePath for " + realPath + " is not found in path2InodeIdMap");
        }
        Path compositePath = CompositePathInfo.encodeCompositeJfsPath(realPath, writeContext.iNodeId, writeContext.fileSize.get());
        this.path2InodeIdMap.remove(realPath);
        return compositePath;
    }

    public boolean close2(JindoRequestPath path, List<String> paths, boolean abort) throws IOException {
        LOG.debug("Start to close2 for " + path.getPath());
        try {
            ArrayList<String> fileIds = new ArrayList<String>(paths.size());
            ArrayList<Long> sizes = new ArrayList<Long>(paths.size());
            ArrayList<String> realPaths = new ArrayList<String>(paths.size());
            for (String filePath : paths) {
                String realPath;
                long size;
                String inodeId;
                CompositePathInfo compositePathInfo = CompositePathInfo.decode(new Path(filePath));
                if (compositePathInfo != null) {
                    inodeId = compositePathInfo.inodeId;
                    size = compositePathInfo.fileSize;
                    realPath = compositePathInfo.realPath.toString();
                } else {
                    JfsOutputStream.WriteContext writeContext = this.path2InodeIdMap.get(filePath);
                    if (writeContext == null) {
                        LOG.warn("Failed to close2 for " + filePath + " is not found in path2InodeIdMap");
                        return false;
                    }
                    inodeId = writeContext.iNodeId;
                    size = writeContext.fileSize.get();
                    realPath = filePath;
                    this.path2InodeIdMap.remove(filePath);
                }
                fileIds.add(inodeId);
                sizes.add(size);
                realPaths.add(realPath);
            }
            JfsFileStatus status = JfsFileStatus.createStatus(new Path(paths.get(0)), new FsPermission(493), true, 0x800000, (short)2, 0x8000000L, this.conf);
            return this.context.fileletSystem.close2(path, realPaths, fileIds, sizes, status.getOwner(), status.getGroup(), abort, this.timeoutInSecond);
        }
        catch (IOException e) {
            LOG.warn("Failed to close2 for " + path.getPath());
            return false;
        }
    }

    @Override
    public void setCryptoPolicy(Path path, String keyIdName, byte cipherSuite) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        JfsAdminTool jfsAdmin = new JfsAdminTool();
        jfsAdmin.setCryptoPolicy(key, keyIdName, cipherSuite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JindoCryptoPolicy getCryptoPolicy(Path path) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        JfsAdminTool jfsAdmin = new JfsAdminTool();
        NssGetCryptoPolicyReply reply = null;
        try {
            JindoCryptoPolicy result;
            reply = jfsAdmin.getCryptoPolicy(key);
            JindoCryptoPolicy jindoCryptoPolicy = result = new JindoCryptoPolicy(reply);
            return jindoCryptoPolicy;
        }
        finally {
            if (reply != null) {
                JbootBufferFactory.returnBuffer(reply.getByteBuffer());
            }
        }
    }

    @Override
    public CltArchiveDirReply archiveDir(Path path, Byte policy) throws IOException {
        throw new IOException("Not Support archiveDir for JfsStore");
    }

    @Override
    public CltUnarchiveDirReply unarchiveDir(Path path, Byte policy) throws IOException {
        throw new IOException("Not Support unarchiveDir for JfsStore");
    }

    @Override
    public CltRestoreDirReply restoreDir(Path path) throws IOException {
        throw new IOException("Not Support restoreDir for JfsStore");
    }

    public static class Context
    extends AbstractFileSystemStore.Context {
        public JfsFileletSystem fileletSystem;
        public long nsConnectorPtr = 0L;
        public String bucket;
    }
}

