/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.ossnative;

import com.alibaba.jboot.JbootOssWriter;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.aliyun.emr.buffer.ChunkBuffer;
import com.aliyun.emr.compatibility.StopWatch;
import com.aliyun.emr.fs.common.FsStats;
import com.aliyun.emr.fs.internal.ossnative.OssOpContext;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.InvalidMarkException;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JindoOssRecoverableOutputStream
extends OutputStream {
    static final Logger LOG = LoggerFactory.getLogger(JindoOssRecoverableOutputStream.class);
    private boolean closed;
    private final byte[] singleByteBuf = new byte[1];
    private ChunkBuffer writeBuffer;
    private long byteWriten = 0L;
    private long writeElapsedNanos = 0L;
    private OssWriteContext context;
    private int DEFAULT_FUTURE_TIMEOUT = 600;

    public JindoOssRecoverableOutputStream(OssWriteContext context) throws IOException {
        this.context = context;
        this.writeBuffer = new ChunkBuffer(JbootBufferFactory.allocateBuffer(context.bufferSize));
    }

    @Override
    public synchronized void flush() throws IOException {
        LOG.info("Start to flush");
        this.checkStatus();
        this.flushPartialBuffer();
        StopWatch sw = new StopWatch().start();
        this.context.jbootWriter.flushFile(this.DEFAULT_FUTURE_TIMEOUT);
        long duration = sw.stop().now();
        FsStats.logStats("flush", this.context.path, null, this.byteWriten, null, duration, "3.7.2");
        this.writeElapsedNanos += duration;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            if (this.writeBuffer == null) {
                LOG.warn("Write buffer has been released because of former write failure, just do some clean up");
                return;
            }
            this.flushBuffer();
            StopWatch sw = new StopWatch().start();
            this.context.jbootWriter.finalizeFile();
            this.writeElapsedNanos += sw.stop().now();
        }
        catch (IOException e) {
            LOG.error("Close " + this.context.path + " error " + e.getMessage(), (Throwable)e);
            throw new IOException("Close stream " + this.context.path + " error " + e.getMessage(), e);
        }
        finally {
            this.closed = true;
            FsStats.logStats("upload", this.context.path, null, this.byteWriten, null, this.writeElapsedNanos, "3.7.2");
            this.cleanUp();
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.checkStatus();
        this.singleByteBuf[0] = (byte)b;
        this.write(this.singleByteBuf, 0, 1);
    }

    @Override
    public synchronized void write(byte[] buffer, int off, int len) throws IOException {
        this.checkStatus();
        int nWritten = this.writeBuffer.write(buffer, off, len);
        if (nWritten < len) {
            try {
                this.flushBuffer();
            }
            catch (Exception e) {
                this.cleanUp();
                throw new IOException("Write offset " + off + ", length " + len + " error: " + e.getMessage(), e);
            }
            this.write(buffer, off + nWritten, len - nWritten);
        }
    }

    protected void finalize() {
        this.cleanUp();
    }

    private void writeOutBuffer() throws IOException {
        StopWatch sw = new StopWatch().start();
        this.writeBuffer.buffer().flip();
        if (this.writeBuffer.buffer().remaining() > 0) {
            this.doWriteBuffer();
        }
        this.writeBuffer.buffer().position(0);
        this.writeElapsedNanos += sw.stop().now();
        this.byteWriten += (long)this.writeBuffer.buffer().remaining();
    }

    private void checkStatus() throws IOException {
        if (this.closed) {
            throw new IOException("Output stream closed.");
        }
    }

    private void cleanUp() {
        this.context.jbootWriter.close();
        if (this.writeBuffer != null) {
            JbootBufferFactory.returnBuffer(this.writeBuffer.buffer());
            this.writeBuffer = null;
        }
    }

    protected void flushPartialBuffer() throws IOException {
        if (this.writeBuffer == null) {
            return;
        }
        if (this.writeBuffer.buffer() == null) {
            return;
        }
        StopWatch sw = new StopWatch().start();
        this.flipBuffer();
        try {
            if (this.writeBuffer.buffer().remaining() > 0) {
                this.doWriteBuffer();
            }
            this.byteWriten += (long)this.writeBuffer.buffer().remaining();
            this.writeBuffer.buffer().position(this.writeBuffer.buffer().limit());
            this.writeBuffer.buffer().limit(this.writeBuffer.buffer().capacity());
            this.writeBuffer.buffer().mark();
        }
        catch (Exception e) {
            this.cleanUp();
            throw new IOException("Failed to flush write buffer after some tries, path " + this.context.path, e);
        }
        finally {
            this.writeElapsedNanos += sw.stop().now();
        }
    }

    protected void flushBuffer() throws IOException {
        if (this.writeBuffer == null) {
            return;
        }
        if (this.writeBuffer.buffer() == null) {
            return;
        }
        StopWatch sw = new StopWatch().start();
        this.flipBuffer();
        try {
            if (this.writeBuffer.buffer().remaining() > 0) {
                this.doWriteBuffer();
            }
            this.byteWriten += (long)this.writeBuffer.buffer().remaining();
            this.writeBuffer.buffer().clear();
        }
        catch (Exception e) {
            this.cleanUp();
            throw new IOException("Failed to flush write buffer after some tries, path " + this.context.path, e);
        }
        finally {
            this.writeElapsedNanos += sw.stop().now();
        }
    }

    private void flipBuffer() {
        this.writeBuffer.buffer().limit(this.writeBuffer.buffer().position());
        try {
            this.writeBuffer.buffer().reset();
        }
        catch (InvalidMarkException e) {
            this.writeBuffer.buffer().position(0);
        }
    }

    private void doWriteBuffer() throws IOException {
        this.context.jbootWriter.write(this.writeBuffer.buffer());
    }

    public static class OssWriteContext
    extends OssOpContext {
        public Path path;
        public int bufferSize;
        public JbootOssWriter jbootWriter;
    }
}

