/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.jfs;

import com.aliyun.emr.fs.common.AbstractJindoCommitterFactory;
import com.aliyun.emr.fs.jfs.commit.JindoBatchMetaCommitter;
import com.aliyun.emr.fs.oss.commit.magic.JindoOssMagicCommitter;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JindoFSCommitterFactory
extends AbstractJindoCommitterFactory {
    static final Logger LOG = LoggerFactory.getLogger(JindoFSCommitterFactory.class);

    @Override
    public FileOutputCommitter createFileOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        if (this.useMagicCommitter(outputPath, context.getConfiguration())) {
            LOG.info("Using JindoOssMagicCommitter as Job Committer.");
            return new JindoOssMagicCommitter(outputPath, context);
        }
        if (JindoBatchMetaCommitter.useJindoBatchMetaCommitter(outputPath, context.getConfiguration())) {
            LOG.info("Using JindoBatchMetaCommitter as Job Committer.");
            return new JindoBatchMetaCommitter(outputPath, context);
        }
        LOG.info("Using FileOutputCommitter as Job Committer.");
        return new FileOutputCommitter(outputPath, context);
    }

    @Override
    public FileOutputCommitter createFileOutputCommitter(Path outputPath, JobContext context) throws IOException {
        if (this.useMagicCommitter(outputPath, context.getConfiguration())) {
            LOG.info("Using JindoOssMagicCommitter as Job Committer.");
            return new JindoOssMagicCommitter(outputPath, context);
        }
        if (JindoBatchMetaCommitter.useJindoBatchMetaCommitter(outputPath, context.getConfiguration())) {
            LOG.info("Using JindoBatchMetaCommitter as Job Committer.");
            return new JindoBatchMetaCommitter(outputPath, context);
        }
        LOG.info("Using FileOutputCommitter as Job Committer.");
        return new FileOutputCommitter(outputPath, context);
    }
}

