/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.auth;

import com.aliyun.emr.fs.s3.auth.AuthUtils;
import com.aliyun.emr.fs.s3.auth.delegation.DelegationTokenIOException;
import com.aliyun.emr.shade.google_guava.annotations.VisibleForTesting;
import com.aliyun.emr.utils.StringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Private
public final class MarshalledCredentials
implements Writable,
Serializable {
    @VisibleForTesting
    public static final String INVALID_CREDENTIALS = "Invalid credentials";
    @VisibleForTesting
    public static final String NO_CREDENTIALS = "No credentials";
    private static final int MAX_SECRET_LENGTH = 8192;
    private static final long serialVersionUID = 8444610385533920692L;
    private String accessKeyId = "";
    private String accessKeySecret = "";
    private String securityToken = "";
    private String roleARN = "";
    private long expiration;

    public MarshalledCredentials() {
    }

    public MarshalledCredentials(String accessKeyId, String accessKeySecret, String securityToken) {
        this();
        this.accessKeyId = Objects.requireNonNull(accessKeyId);
        this.accessKeySecret = Objects.requireNonNull(accessKeySecret);
        this.securityToken = securityToken == null ? "" : securityToken;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public Optional<OffsetDateTime> getExpirationDateTime() {
        return this.expiration == 0L ? Optional.empty() : Optional.of(OffsetDateTime.ofInstant(new Date(this.expiration).toInstant(), ZoneOffset.UTC));
    }

    public String getRoleARN() {
        return this.roleARN;
    }

    public void setRoleARN(String roleARN) {
        this.roleARN = Objects.requireNonNull(roleARN);
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = Objects.requireNonNull(accessKeyId, "access key id");
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = Objects.requireNonNull(accessKeySecret, "access key secret");
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = Objects.requireNonNull(securityToken, "security token");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarshalledCredentials that = (MarshalledCredentials)o;
        return this.expiration == that.expiration && Objects.equals(this.accessKeyId, that.accessKeyId) && Objects.equals(this.accessKeySecret, that.accessKeySecret) && Objects.equals(this.securityToken, that.securityToken) && Objects.equals(this.roleARN, that.roleARN);
    }

    public int hashCode() {
        return Objects.hash(this.accessKeyId, this.accessKeySecret, this.securityToken, this.roleARN, this.expiration);
    }

    public String toString() {
        String validity;
        if (this.isEmpty()) {
            return "Empty credentials";
        }
        String string = validity = this.isValid(CredentialTypeRequired.AnyNonEmpty) ? "valid" : "invalid";
        if (!this.hasSecurityToken()) {
            return "full credentials (" + validity + ")";
        }
        return String.format("session credentials, expiry %s; %s(%s)", this.getExpirationDateTime().map(x -> x.format(DateTimeFormatter.ISO_DATE_TIME)).orElse("unknown"), StringUtils.isNotEmpty(this.roleARN) ? "role \"" + this.roleARN + "\" " : "", validity);
    }

    public boolean isEmpty() {
        return !StringUtils.isNotEmpty(this.accessKeyId) || !StringUtils.isNotEmpty(this.accessKeySecret);
    }

    public boolean isValid(CredentialTypeRequired required) {
        if (this.accessKeyId == null || this.accessKeySecret == null || this.securityToken == null) {
            return false;
        }
        boolean hasAccessAndSecretKeys = StringUtils.isNotEmpty(this.accessKeyId) && StringUtils.isNotEmpty(this.accessKeySecret);
        boolean hasSecurityToken = this.hasSecurityToken();
        switch (required) {
            case AnyIncludingEmpty: {
                return true;
            }
            case Empty: {
                return !hasAccessAndSecretKeys;
            }
            case AnyNonEmpty: {
                return hasAccessAndSecretKeys;
            }
            case FullOnly: {
                return hasAccessAndSecretKeys && !hasSecurityToken;
            }
            case SessionOnly: {
                return hasAccessAndSecretKeys && this.hasSecurityToken();
            }
        }
        return false;
    }

    public boolean hasSecurityToken() {
        return StringUtils.isNotEmpty(this.securityToken);
    }

    public void write(DataOutput out) throws IOException {
        this.validate("Writing " + this + ": ", CredentialTypeRequired.AnyIncludingEmpty);
        Text.writeString((DataOutput)out, (String)this.accessKeyId);
        Text.writeString((DataOutput)out, (String)this.accessKeySecret);
        Text.writeString((DataOutput)out, (String)this.securityToken);
        Text.writeString((DataOutput)out, (String)this.roleARN);
        out.writeLong(this.expiration);
    }

    public void readFields(DataInput in) throws IOException {
        this.accessKeyId = Text.readString((DataInput)in, (int)8192);
        this.accessKeySecret = Text.readString((DataInput)in, (int)8192);
        this.securityToken = Text.readString((DataInput)in, (int)8192);
        this.roleARN = Text.readString((DataInput)in, (int)8192);
        this.expiration = in.readLong();
    }

    public void validate(String message, CredentialTypeRequired typeRequired) throws IOException {
        if (!this.isValid(typeRequired)) {
            throw new DelegationTokenIOException(message + this.buildInvalidCredentialsError(typeRequired));
        }
    }

    public String buildInvalidCredentialsError(CredentialTypeRequired typeRequired) {
        if (this.isEmpty()) {
            return " No credentials";
        }
        return " Invalid credentials in " + this.toString() + " required: " + (Object)((Object)typeRequired);
    }

    public void setSecretsInConfiguration(Configuration config) {
        config.set("fs.jfs.cache.s3.accessKeyId", this.accessKeyId);
        config.set("fs.jfs.cache.s3.accessKeySecret", this.accessKeySecret);
        AuthUtils.setIfDefined(config, "fs.jfs.cache.s3.securityToken", this.securityToken, "security credentials");
    }

    public static MarshalledCredentials empty() {
        return new MarshalledCredentials("", "", "");
    }

    public static enum CredentialTypeRequired {
        Empty("None"),
        AnyIncludingEmpty("Full, Session or None"),
        AnyNonEmpty("Full or Session"),
        SessionOnly("Session"),
        FullOnly("Full");

        private final String text;

        private CredentialTypeRequired(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return this.getText();
        }
    }
}

