/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.aliyun.emr.fs.s3.S3FileSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;

public class S3
extends AbstractFileSystem {
    private static final int DELEGATE_TO_FS_DEFAULT_PORT = -1;
    protected final FileSystem fsImpl = new S3FileSystem();

    public S3(URI theUri, Configuration conf) throws IOException, URISyntaxException {
        super(new URI(theUri.getScheme() + "://" + theUri.getHost() + "/"), "s3", false, -1);
        this.fsImpl.initialize(theUri, conf);
        this.fsImpl.statistics = this.getStatistics();
    }

    public Path getInitialWorkingDirectory() {
        return this.fsImpl.getInitialWorkingDirectory();
    }

    public FSDataOutputStream createInternal(Path f, EnumSet<CreateFlag> flag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt, boolean createParent) throws IOException {
        this.checkPath(f);
        if (!createParent) {
            FileStatus stat = this.getFileStatus(f.getParent());
            if (stat == null) {
                throw new FileNotFoundException("Missing parent:" + f);
            }
            if (!stat.isDirectory()) {
                throw new ParentNotDirectoryException("parent is not a dir:" + f);
            }
        }
        return this.fsImpl.primitiveCreate(f, absolutePermission, flag, bufferSize, replication, blockSize, progress, checksumOpt);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        this.checkPath(f);
        return this.fsImpl.delete(f, recursive);
    }

    public BlockLocation[] getFileBlockLocations(Path f, long start, long len) throws IOException {
        this.checkPath(f);
        return this.fsImpl.getFileBlockLocations(f, start, len);
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        this.checkPath(f);
        return this.fsImpl.getFileChecksum(f);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        this.checkPath(f);
        return this.fsImpl.getFileStatus(f);
    }

    public FileStatus getFileLinkStatus(Path f) throws IOException {
        FileStatus status = this.fsImpl.getFileLinkStatus(f);
        if (status.isSymlink()) {
            status.setSymlink(this.fsImpl.getLinkTarget(f));
        }
        return status;
    }

    public FsStatus getFsStatus() throws IOException {
        return this.fsImpl.getStatus();
    }

    public FsStatus getFsStatus(Path f) throws IOException {
        return this.fsImpl.getStatus(f);
    }

    @Deprecated
    public FsServerDefaults getServerDefaults() throws IOException {
        return this.fsImpl.getServerDefaults();
    }

    public FsServerDefaults getServerDefaults(Path f) throws IOException {
        return this.fsImpl.getServerDefaults(f);
    }

    public Path getHomeDirectory() {
        return this.fsImpl.getHomeDirectory();
    }

    public int getUriDefaultPort() {
        return -1;
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        this.checkPath(f);
        return this.fsImpl.listStatus(f);
    }

    public void mkdir(Path dir, FsPermission permission, boolean createParent) throws IOException {
        this.checkPath(dir);
        this.fsImpl.primitiveMkdir(dir, permission, createParent);
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        this.checkPath(f);
        return this.fsImpl.open(f, bufferSize);
    }

    public boolean truncate(Path f, long newLength) throws IOException {
        this.checkPath(f);
        return this.fsImpl.truncate(f, newLength);
    }

    public void renameInternal(Path src, Path dst) throws IOException {
        this.checkPath(src);
        this.checkPath(dst);
        this.fsImpl.rename(src, dst, new Options.Rename[]{Options.Rename.NONE});
    }

    public void setOwner(Path f, String username, String groupname) throws IOException {
        this.checkPath(f);
        this.fsImpl.setOwner(f, username, groupname);
    }

    public void setPermission(Path f, FsPermission permission) throws IOException {
        this.checkPath(f);
        this.fsImpl.setPermission(f, permission);
    }

    public boolean setReplication(Path f, short replication) throws IOException {
        this.checkPath(f);
        return this.fsImpl.setReplication(f, replication);
    }

    public void setTimes(Path f, long mtime, long atime) throws IOException {
        this.checkPath(f);
        this.fsImpl.setTimes(f, mtime, atime);
    }

    public void setVerifyChecksum(boolean verifyChecksum) throws IOException {
        this.fsImpl.setVerifyChecksum(verifyChecksum);
    }

    public boolean supportsSymlinks() {
        return this.fsImpl.supportsSymlinks();
    }

    public void createSymlink(Path target, Path link, boolean createParent) throws IOException {
        this.fsImpl.createSymlink(target, link, createParent);
    }

    public Path getLinkTarget(Path f) throws IOException {
        return this.fsImpl.getLinkTarget(f);
    }

    public String getCanonicalServiceName() {
        return this.fsImpl.getCanonicalServiceName();
    }

    public List<Token<?>> getDelegationTokens(String renewer) throws IOException {
        return Arrays.asList(this.fsImpl.addDelegationTokens(renewer, null));
    }
}

