/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot;

import com.alibaba.jboot.ErrorCode;
import com.alibaba.jboot.exception.ConnectionBreakException;
import com.alibaba.jboot.exception.ConnectionDownException;
import com.alibaba.jboot.exception.NodeServerBreakException;
import com.alibaba.jboot.exception.OtsConditionalUpdateException;
import com.alibaba.jboot.exception.ServiceHaException;
import com.alibaba.jboot.exception.ServiceHaUnderInitException;
import com.alibaba.jboot.exception.ServiceHaUnderStandbyException;
import com.alibaba.jboot.exception.ShouldIgnoreException;
import com.alibaba.jboot.exception.ShouldReturnFalseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.file.FileAlreadyExistsException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JbootFuture
implements Future {
    private final CountDownLatch latch = new CountDownLatch(1);
    private long startTime = this.endTime = System.currentTimeMillis();
    private long endTime;
    private Object result;
    private Throwable error;
    static Constructor<?> hadoopSecurityExceptionConstructor = null;

    void handleResult(Object result) {
        if (result instanceof ByteBuffer) {
            ByteBuffer bb = (ByteBuffer)result;
            bb.position(0);
            bb.limit(bb.capacity());
        }
        this.result = result;
        this.endTime = System.currentTimeMillis();
        this.latch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static IOException makeAccessControlException(String errorMsg) {
        try {
            if (hadoopSecurityExceptionConstructor == null) {
                Class<JbootFuture> clazz = JbootFuture.class;
                // MONITORENTER : com.alibaba.jboot.JbootFuture.class
                Class<?> hadoopSecurityExceptionClz = Class.forName("org.apache.hadoop.security.AccessControlException");
                hadoopSecurityExceptionConstructor = hadoopSecurityExceptionClz.getConstructor(String.class);
                // MONITOREXIT : clazz
            }
            Object hadoopSecurityException = hadoopSecurityExceptionConstructor.newInstance(errorMsg);
            return (IOException)hadoopSecurityException;
        }
        catch (ClassNotFoundException e) {
            return new IOException(errorMsg + ", and class AccessControlException not found");
        }
        catch (NoSuchMethodException e) {
            return new IOException(errorMsg + ", and NoSuchMethodException");
        }
        catch (Exception e) {
            return new IOException(errorMsg + ", and unknown Exception");
        }
    }

    void handleError(int errorCode, String errorMsg) {
        errorMsg = this.trimErrMsg(errorMsg);
        switch (errorCode) {
            case 25000: 
            case 25001: {
                this.error = new FileAlreadyExistsException("ErrorCode : " + errorCode + " , ErrorMsg: " + (ErrorCode.ERROR_CODE_MAP.get(errorCode) == null ? errorMsg : ErrorCode.ERROR_CODE_MAP.get(errorCode) + ". " + errorMsg));
                break;
            }
            case 25002: {
                this.error = new FileNotFoundException("ErrorCode : " + errorCode + " , ErrorMsg: " + (ErrorCode.ERROR_CODE_MAP.get(errorCode) == null ? errorMsg : ErrorCode.ERROR_CODE_MAP.get(errorCode) + ". " + errorMsg));
                break;
            }
            case 25008: {
                this.error = new ShouldReturnFalseException(errorMsg);
                break;
            }
            case 25010: {
                this.error = new ShouldReturnFalseException(errorMsg);
                break;
            }
            case 25012: {
                this.error = new FileNotFoundException(errorMsg);
                break;
            }
            case 25014: {
                this.error = new ShouldReturnFalseException(errorMsg);
                break;
            }
            case 25015: {
                this.error = new ShouldReturnFalseException(errorMsg);
                break;
            }
            case 25016: {
                this.error = JbootFuture.makeAccessControlException(errorMsg);
                break;
            }
            case 25025: {
                this.error = new ShouldReturnFalseException(errorMsg);
                break;
            }
            case 25026: {
                this.error = new ShouldIgnoreException(errorMsg);
                break;
            }
            case 23003: {
                this.error = new ConnectionDownException(errorMsg);
                break;
            }
            case 23004: {
                this.error = new ConnectionBreakException(errorMsg);
                break;
            }
            case 23005: {
                this.error = new NullPointerException(errorMsg);
                break;
            }
            case 24004: {
                this.error = new NodeServerBreakException(errorMsg);
                break;
            }
            case 26001: {
                this.error = new OtsConditionalUpdateException(errorMsg);
                break;
            }
            case 27000: {
                this.error = new ServiceHaException(errorMsg);
                break;
            }
            case 27001: {
                this.error = new ServiceHaUnderInitException(errorMsg);
                break;
            }
            case 27002: {
                this.error = new ServiceHaUnderStandbyException(errorMsg);
                break;
            }
            default: {
                this.error = new IOException("ErrorCode : " + errorCode + " , ErrorMsg: " + (ErrorCode.ERROR_CODE_MAP.get(errorCode) == null ? errorMsg : ErrorCode.ERROR_CODE_MAP.get(errorCode) + ". " + errorMsg));
            }
        }
        this.endTime = System.currentTimeMillis();
        this.latch.countDown();
    }

    private String trimErrMsg(String errorMsg) {
        if (errorMsg == null) {
            return "";
        }
        Pattern pattern = Pattern.compile("^[\\[E\\d\\.:\\]]+");
        Matcher matcher = pattern.matcher(errorMsg);
        String out = matcher.replaceFirst("");
        return out;
    }

    public long getDuration() {
        return this.endTime - this.startTime;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    public Object get() throws InterruptedException, ExecutionException {
        this.latch.await();
        if (this.error != null) {
            this.error.setStackTrace(new Exception().getStackTrace());
            throw new ExecutionException(this.error);
        }
        return this.result;
    }

    public synchronized Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.latch.await(timeout, unit)) {
            if (this.error != null) {
                this.error.setStackTrace(new Exception().getStackTrace());
                throw new ExecutionException(this.error);
            }
            return this.result;
        }
        throw new TimeoutException();
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }

    public void await(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.latch.await(timeout, unit)) {
            throw new TimeoutException();
        }
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() <= 0L;
    }

    public static void checkFuture(JbootFuture future, long timeoutInSeconds) throws IOException {
        try {
            future.get(timeoutInSeconds, TimeUnit.SECONDS);
            return;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof IOException) {
                throw (IOException)ee.getCause();
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

