/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot;

import com.alibaba.jboot.NativeCodeLoader;
import com.alibaba.jboot.jni.NativeClass;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class JbootNative
extends NativeClass {
    private static Object initLock = new Object();
    private static boolean loadSucceeded;
    private static JbootNative _instance;
    static Set<Class> classInitSet;

    public static void checkLoaded() {
        if (!loadSucceeded) {
            throw new RuntimeException("JbootNative loading failed: " + NativeCodeLoader.getError());
        }
    }

    public static JbootNative instance() {
        JbootNative.checkLoaded();
        JbootNative.initialize();
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize() {
        if (_instance == null) {
            Object object = initLock;
            synchronized (object) {
                if (_instance == null) {
                    JbootNative tmpNative = new JbootNative();
                    tmpNative.init();
                    _instance = tmpNative;
                }
            }
        }
    }

    private JbootNative() {
    }

    private synchronized void init() {
        if (!loadSucceeded) {
            throw new RuntimeException("unable to init because NativeCodeLoader is not loaded, error:" + NativeCodeLoader.getError());
        }
        try {
            this.initNative();
            String err = this.checkLibjbootState();
            if (err != null) {
                throw new RuntimeException("detect LibjbootMainImpl initialization failure. " + err + " please check safe log /tmp/b2safelog_*.log");
            }
        }
        catch (Throwable e) {
            NativeCodeLoader.dumpAnalysisLog(null, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initOnceNativeClass(Class javaClass) {
        JbootNative.instance();
        if (classInitSet.contains(javaClass)) return;
        Class<JbootNative> clazz = JbootNative.class;
        synchronized (JbootNative.class) {
            if (classInitSet.contains(javaClass)) return;
            try {
                Method initMethod = javaClass.getDeclaredMethod("init", new Class[0]);
                initMethod.setAccessible(true);
                initMethod.invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            classInitSet.add(javaClass);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public synchronized native void setConfDir(String var1);

    public synchronized native void setOption(String var1, String var2);

    public synchronized native void loadConfig(String var1);

    public native String checkLibjbootState();

    @Override
    public synchronized native void destroy();

    private synchronized native void initNative();

    public synchronized native void initNativeClass(String var1);

    public native String getLogName();

    static {
        _instance = null;
        NativeCodeLoader.load();
        loadSucceeded = NativeCodeLoader.getError() == null;
        classInitSet = new CopyOnWriteArraySet<Class>();
    }
}

