/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot.buffer;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import sun.misc.Unsafe;

public class ByteBufferPool {
    private static final int majorVersion = Integer.parseInt(System.getProperty("java.version").split("\\D+")[0]);
    private Method cleannerCleanMethod = null;
    private Method directBufferCleanner = null;
    private boolean usePool;
    final ConcurrentMap<Integer, Queue<Reference<ByteBuffer>>> nativeBuffersBySize = new ConcurrentHashMap<Integer, Queue<Reference<ByteBuffer>>>();

    public ByteBufferPool(boolean usePool) {
        try {
            if (majorVersion < 9) {
                this.directBufferCleanner = Class.forName("java.nio.DirectByteBuffer").getMethod("cleaner", new Class[0]);
                this.directBufferCleanner.setAccessible(true);
                String cleanerClassName = "sun.misc.Cleaner";
                Class<?> cleanerClass = Class.forName(cleanerClassName);
                this.cleannerCleanMethod = cleanerClass.getMethod("clean", new Class[0]);
            } else {
                this.cleannerCleanMethod = Class.forName("sun.misc.Unsafe").getMethod("invokeCleaner", ByteBuffer.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.usePool = usePool;
    }

    public ByteBuffer getDirect(int size) {
        if (!this.usePool) {
            return this.createDirectBuffer(size);
        }
        Queue list = (Queue)this.nativeBuffersBySize.get(size);
        if (list == null) {
            return this.createDirectBuffer(size);
        }
        ByteBuffer buffer = this.poll(list);
        return buffer != null ? buffer : this.createDirectBuffer(size);
    }

    private ByteBuffer poll(Queue<Reference<ByteBuffer>> list) {
        Reference<ByteBuffer> ref;
        while ((ref = list.poll()) != null) {
            ByteBuffer cached = ref.get();
            if (cached == null) continue;
            cached.clear();
            return cached;
        }
        return null;
    }

    public void release(ByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        buffer.clear();
        if (!this.usePool) {
            try {
                if (this.directBufferCleanner == null) {
                    Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                    unsafeField.setAccessible(true);
                    Unsafe unsafe = (Unsafe)unsafeField.get(null);
                    this.cleannerCleanMethod.invoke((Object)unsafe, buffer);
                } else {
                    Object obj = this.directBufferCleanner.invoke((Object)buffer, new Object[0]);
                    this.cleannerCleanMethod.invoke(obj, new Object[0]);
                }
                return;
            }
            catch (Throwable e) {
                return;
            }
        }
        int size = buffer.capacity();
        Queue<WeakReference<ByteBuffer>> list = (ConcurrentLinkedQueue<WeakReference<ByteBuffer>>)this.nativeBuffersBySize.get(size);
        if (list == null) {
            list = new ConcurrentLinkedQueue<WeakReference<ByteBuffer>>();
            Queue prev = this.nativeBuffersBySize.putIfAbsent(size, list);
            if (prev != null) {
                list = prev;
            }
        }
        if (list.size() > 1000) {
            return;
        }
        Reference bufferRef = size > 4096 ? new WeakReference<ByteBuffer>(buffer) : new SoftReference<ByteBuffer>(buffer);
        list.add((WeakReference<ByteBuffer>)bufferRef);
    }

    private ByteBuffer createDirectBuffer(int size) {
        return ByteBuffer.allocateDirect(size);
    }
}

