/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.buffer;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

public class ByteBufferPool {
    final ConcurrentMap<Integer, Queue<WeakReference<ByteBuffer>>> buffersBySize = new ConcurrentHashMap<Integer, Queue<WeakReference<ByteBuffer>>>();
    final ConcurrentMap<Integer, Queue<WeakReference<ByteBuffer>>> directBuffersBySize = new ConcurrentHashMap<Integer, Queue<WeakReference<ByteBuffer>>>();

    public ByteBuffer get(int size) {
        Queue list = (Queue)this.buffersBySize.get(size);
        if (list == null) {
            return ByteBuffer.allocate(size);
        }
        ByteBuffer buffer = this.poll(list);
        return buffer != null ? buffer : ByteBuffer.allocate(size);
    }

    public ByteBuffer getDirect(int size) {
        Queue list = (Queue)this.directBuffersBySize.get(size);
        if (list == null) {
            return ByteBuffer.allocateDirect(size);
        }
        ByteBuffer buffer = this.poll(list);
        return buffer != null ? buffer : ByteBuffer.allocateDirect(size);
    }

    private ByteBuffer poll(Queue<WeakReference<ByteBuffer>> list) {
        WeakReference<ByteBuffer> ref;
        while ((ref = list.poll()) != null) {
            ByteBuffer cached = (ByteBuffer)ref.get();
            if (cached == null) continue;
            cached.clear();
            return cached;
        }
        return null;
    }

    public void release(ByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        buffer.clear();
        int size = buffer.capacity();
        Queue<WeakReference<ByteBuffer>> list = null;
        list = buffer.isDirect() ? (ConcurrentLinkedQueue<WeakReference<ByteBuffer>>)this.directBuffersBySize.get(size) : (Queue)this.buffersBySize.get(size);
        if (list == null) {
            list = new ConcurrentLinkedQueue<WeakReference<ByteBuffer>>();
            Queue prev = null;
            prev = buffer.isDirect() ? (Queue)this.directBuffersBySize.putIfAbsent(size, list) : (Queue)this.buffersBySize.putIfAbsent(size, list);
            if (prev != null) {
                list = prev;
            }
        }
        list.add(new WeakReference<ByteBuffer>(buffer));
    }
}

