/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.bench;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JindoPerfTool {
    static final Logger LOG = LoggerFactory.getLogger(JindoPerfTool.class);
    private Path testDir;
    private FileSystem fs;
    private Configuration conf;
    private static final int DEFAILT_SIZE = 4096;
    private static final int CONCURRENCY_MAX = 200;

    private static long parseSize(String arg) {
        String[] args = arg.split("\\D", 2);
        assert (args.length <= 2);
        long nrBytes = Long.parseLong(args[0]);
        String bytesMult = arg.substring(args[0].length());
        return nrBytes * ByteMultiple.parseString(bytesMult).value();
    }

    private static int parseConcurrency(String arg) {
        int concurrency = Integer.parseInt(arg);
        if (concurrency > 200) {
            concurrency = 200;
        }
        if (concurrency < 1) {
            concurrency = 1;
        }
        return concurrency;
    }

    public JindoPerfTool(String path, Configuration conf) throws IOException {
        this.conf = conf;
        this.testDir = new Path(path);
        this.fs = this.testDir.getFileSystem(conf);
        System.out.println("Test path " + this.testDir.toString());
    }

    private static void printHelp() {
        String usage = "Usage: " + JindoPerfTool.class.getSimpleName() + " -read | -write -path [URI]  [-rand]  -size Size[B|KB|MB|GB|TB] -files fileNumber [-clean]";
        System.out.println(usage);
    }

    public void cleanup() throws IOException {
        LOG.info("Cleaning up test files");
        this.fs.delete(this.testDir, true);
    }

    public void writeTest(long writeSize, int concurrency) throws IOException {
        final long totalSize = writeSize < 4096L ? 4096L : writeSize;
        final byte[] buffer = new byte[4096];
        Random rand = new Random();
        rand.nextBytes(buffer);
        System.out.println("Start write test, size " + totalSize + ", files " + concurrency);
        ExecutorService executors = Executors.newCachedThreadPool();
        for (int i = 0; i < concurrency; ++i) {
            final Path filePath = new Path(this.testDir, "data_" + i);
            executors.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        long start = System.currentTimeMillis();
                        FSDataOutputStream outputStream = JindoPerfTool.this.fs.create(filePath);
                        for (long nrRemaining = totalSize; nrRemaining > 0L; nrRemaining -= 4096L) {
                            int curSize = 4096L < nrRemaining ? 4096 : (int)nrRemaining;
                            outputStream.write(buffer, 0, curSize);
                        }
                        outputStream.close();
                        long dur = System.currentTimeMillis() - start;
                        System.out.println("Writing file " + filePath + " takes time " + dur + "ms");
                    }
                    catch (IOException e) {
                        System.err.println("Error when writing " + filePath + ": " + e.getMessage());
                    }
                }
            });
        }
        executors.shutdown();
        try {
            executors.awaitTermination(600L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void readTest(long readSize, int concurrency, final boolean rand) throws IOException {
        final long totalSize = readSize < 4096L ? 4096L : readSize;
        final byte[] buffer = new byte[4096];
        System.out.println("Start read test, size " + totalSize + ", files " + concurrency + ", rand " + rand);
        final ArrayList<Long> randomReadPositions = new ArrayList<Long>();
        if (rand) {
            for (long i = 0L; i < totalSize / 4096L; ++i) {
                randomReadPositions.add(i * 4096L);
            }
            Random randseed = new Random(8234716L);
            Collections.shuffle(randomReadPositions, randseed);
        }
        ExecutorService executors = Executors.newCachedThreadPool();
        for (int i = 0; i < concurrency; ++i) {
            final Path filePath = new Path(this.testDir, "data_" + i);
            executors.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        long start = System.currentTimeMillis();
                        FSDataInputStream inputStream = JindoPerfTool.this.fs.open(filePath);
                        if (!rand) {
                            int curSize;
                            for (long actualSize = 0L; actualSize < totalSize && (curSize = inputStream.read(buffer, 0, buffer.length)) >= 0; actualSize += (long)curSize) {
                            }
                        } else {
                            Iterator actualSize = randomReadPositions.iterator();
                            while (actualSize.hasNext()) {
                                long pos = (Long)actualSize.next();
                                inputStream.read(pos, buffer, 0, buffer.length);
                            }
                        }
                        inputStream.close();
                        long dur = System.currentTimeMillis() - start;
                        System.out.println("Reading file " + filePath + " takes time " + dur + "ms");
                    }
                    catch (IOException e) {
                        System.err.println("Error when reading " + filePath + ": " + e.getMessage());
                    }
                }
            });
        }
        executors.shutdown();
        try {
            executors.awaitTermination(600L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void close() throws IOException {
        this.fs.close();
    }

    public static void main(String[] argv) throws IOException {
        TestType testType = null;
        String path = null;
        long size = 1024L;
        int concurrency = 1;
        boolean rand = false;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].startsWith("-write")) {
                testType = TestType.WRITE_TYPE;
                continue;
            }
            if (argv[i].startsWith("-read")) {
                testType = TestType.READ_TYPE;
                continue;
            }
            if (argv[i].startsWith("-path")) {
                path = argv[++i];
                continue;
            }
            if (argv[i].startsWith("-size")) {
                size = JindoPerfTool.parseSize(argv[++i]);
                continue;
            }
            if (argv[i].startsWith("-files")) {
                concurrency = JindoPerfTool.parseConcurrency(argv[++i]);
                continue;
            }
            if (argv[i].startsWith("-clean")) {
                testType = TestType.CLEAN_TYPE;
                continue;
            }
            if (argv[i].startsWith("-rand")) {
                rand = true;
                continue;
            }
            if (argv[i].startsWith("--help") || argv[i].startsWith("-h")) {
                JindoPerfTool.printHelp();
                return;
            }
            System.err.println("Illegal argument " + argv[i]);
            return;
        }
        if (testType == null) {
            JindoPerfTool.printHelp();
            System.err.println("please specify test type with -read/-write/-clean");
            return;
        }
        if (path == null) {
            JindoPerfTool.printHelp();
            System.err.println("please specify test path with -path");
            return;
        }
        Configuration conf = new Configuration();
        JindoPerfTool tool = new JindoPerfTool(path, conf);
        long startMilli = System.currentTimeMillis();
        switch (testType) {
            case READ_TYPE: {
                tool.readTest(size, concurrency, rand);
                break;
            }
            case WRITE_TYPE: {
                tool.writeTest(size, concurrency);
                break;
            }
            case CLEAN_TYPE: {
                tool.cleanup();
                break;
            }
            default: {
                return;
            }
        }
        long dur = System.currentTimeMillis() - startMilli;
        System.out.println("Test " + (Object)((Object)testType) + " takes time " + dur + "ms");
        tool.close();
    }

    static enum ByteMultiple {
        B(1L),
        KB(1024L),
        MB(0x100000L),
        GB(0x40000000L),
        TB(0x10000000000L);

        private long multiplier;

        private ByteMultiple(long mult) {
            this.multiplier = mult;
        }

        long value() {
            return this.multiplier;
        }

        static ByteMultiple parseString(String sMultiple) {
            if (sMultiple == null || sMultiple.isEmpty()) {
                return MB;
            }
            String sMU = StringUtils.toUpperCase((String)sMultiple);
            if (StringUtils.toUpperCase((String)B.name()).endsWith(sMU)) {
                return B;
            }
            if (StringUtils.toUpperCase((String)KB.name()).endsWith(sMU)) {
                return KB;
            }
            if (StringUtils.toUpperCase((String)MB.name()).endsWith(sMU)) {
                return MB;
            }
            if (StringUtils.toUpperCase((String)GB.name()).endsWith(sMU)) {
                return GB;
            }
            if (StringUtils.toUpperCase((String)TB.name()).endsWith(sMU)) {
                return TB;
            }
            throw new IllegalArgumentException("Unsupported ByteMultiple " + sMultiple);
        }
    }

    private static enum TestType {
        WRITE_TYPE("write"),
        READ_TYPE("read"),
        CLEAN_TYPE("clean");

        private String type;

        private TestType(String t) {
            this.type = t;
        }

        public String toString() {
            return this.type;
        }
    }
}

