/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.ossnative;

import bigboot.protocol.type.BlockInfo;
import bigboot.protocol.type.BlockInfoList;
import bigboot.protocol.type.CltArchiveDirReply;
import bigboot.protocol.type.CltRecoverReply;
import bigboot.protocol.type.CltRestoreDirReply;
import bigboot.protocol.type.CltUnarchiveDirReply;
import bigboot.protocol.type.FileletCreateReply;
import bigboot.protocol.type.FileletOpenReply;
import bigboot.protocol.type.FileletStatus;
import bigboot.protocol.type.FileletStatusList;
import bigboot.protocol.type.FileletSummary;
import bigboot.protocol.type.NssFileletDiffReply;
import bigboot.protocol.type.StoragePolicy;
import bigboot.protocol.type.StringList;
import com.alibaba.jboot.JbootNative;
import com.alibaba.jboot.JbootOssReader;
import com.alibaba.jboot.JbootOssWriter;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.alibaba.jboot.google.flatbuffers.Table;
import com.alibaba.jfs.CredentialContext;
import com.alibaba.jfs.JindoRequestPath;
import com.alibaba.jfs.OssAtomicRenameContext;
import com.alibaba.jfs.OssFlushContext;
import com.aliyun.emr.fs.auth.AliyunCredentialProviderList;
import com.aliyun.emr.fs.auth.AliyunCredentialsProvider;
import com.aliyun.emr.fs.auth.AuthUtils;
import com.aliyun.emr.fs.common.AbstractJindoShimsFileSystem;
import com.aliyun.emr.fs.common.Utils;
import com.aliyun.emr.fs.internal.AbstractFileSystemStore;
import com.aliyun.emr.fs.internal.jfs.Crc32FileChecksum;
import com.aliyun.emr.fs.internal.jfs.Crc64FileChecksum;
import com.aliyun.emr.fs.internal.oss.OssUtils;
import com.aliyun.emr.fs.internal.ossnative.JindoOssInputStream;
import com.aliyun.emr.fs.internal.ossnative.JindoOssOutputStream;
import com.aliyun.emr.fs.internal.ossnative.JindoOssRecoverableOutputStream;
import com.aliyun.emr.fs.internal.ossnative.OssCredentialUtils;
import com.aliyun.emr.fs.internal.ossnative.OssDeleteOp;
import com.aliyun.emr.fs.internal.ossnative.OssFileStatus;
import com.aliyun.emr.fs.internal.ossnative.OssFileletSystem;
import com.aliyun.emr.fs.internal.ossnative.OssGetFileChecksum2Op;
import com.aliyun.emr.fs.internal.ossnative.OssGetFileChecksumOp;
import com.aliyun.emr.fs.internal.ossnative.OssGetFileStatusOp;
import com.aliyun.emr.fs.internal.ossnative.OssListStatusOp;
import com.aliyun.emr.fs.internal.ossnative.OssOpContext;
import com.aliyun.emr.fs.internal.ossnative.OssRenameOp;
import com.aliyun.emr.fs.oss.commit.magic.JindoOssMagicOutputStream;
import com.aliyun.emr.fs.oss.commit.magic.MagicCommitPaths;
import com.aliyun.emr.utils.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssNativeStore
extends AbstractFileSystemStore {
    public static final Logger LOG = LoggerFactory.getLogger(OssNativeStore.class);
    private int writeBufferSize;
    private int readBufferSize;
    private boolean enableBlockLocation;
    private long logicBlockSize;
    private boolean magicEnabled = false;
    private String magicUUID = null;
    private boolean magicVerifyChecksum = false;
    private int contentSummaryBatchCount;
    private boolean dataVerify;
    private boolean allowFileOverwriteFolder;
    private OssOpBuilder ossOpBuilder;
    private final String version = "3.7.2";
    private Context context;
    private URI finalUri;
    private AliyunCredentialProviderList providers = null;
    private CredentialContext ossContext;
    private boolean isToken = false;
    private String[] deleteMarkerDirs;
    private boolean enableDeleteMarkerForAll = false;
    private OssFlushContext flushContext;

    public OssNativeStore(FileSystem fs, Configuration conf, Context context) throws IOException {
        super(fs, conf, context);
        this.context = context;
        try {
            String logName = JbootNative.instance().getLogName();
            LOG.info("Jboot log name is {}", (Object)logName);
            this.context.logName = logName;
        }
        catch (Throwable e) {
            LOG.info("NativeLibrary of Jindo is not available, you can ignore if you are not using jindo fs and cache.");
        }
        if (context.credentialProviders != null) {
            this.providers = context.credentialProviders;
        } else if (fs.getScheme().equals("oss")) {
            this.providers = AuthUtils.createAliyunCredentialProviderSet(context.uri, conf, AliyunCredentialsProvider.CredentialType.OSS);
        } else if (fs.getScheme().equals("jfs")) {
            this.providers = AuthUtils.createAliyunCredentialProviderSet(context.uri, conf, AliyunCredentialsProvider.CredentialType.JFS);
        } else {
            throw new IOException("Unsupported file system: " + fs.getScheme());
        }
        LOG.debug("Using credential provider {}", (Object)this.providers);
        this.ossContext = OssCredentialUtils.createOssCredentialContext(conf, context.uri, this.providers);
        this.finalUri = OssCredentialUtils.createFinallyURI(context.uri, conf, fs.getScheme(), this.ossContext);
        this.ossOpBuilder = new OssOpBuilder();
        int bufferSize = conf.getInt("fs.jfs.cache.write.buffer.size", 0x100000);
        this.writeBufferSize = this.allignBufferSize(bufferSize);
        bufferSize = conf.getInt("fs.jfs.cache.read.buffer.size", 0x100000);
        this.readBufferSize = this.allignBufferSize(bufferSize);
        this.enableBlockLocation = conf.getBoolean("fs.jfs.cache.block.location.enable", false);
        this.logicBlockSize = conf.getLong("fs.jfs.cache.oss-blocksize", 0x8000000L);
        this.magicEnabled = conf.getBoolean("fs.oss.committer.magic.enabled", false);
        this.magicUUID = conf.get("fs.oss.committer.magic.job.uuid", null);
        this.magicVerifyChecksum = conf.getBoolean("fs.oss.committer.magicverify.checksum.enabled", false);
        this.allowFileOverwriteFolder = conf.getBoolean("fs.jfs.cache.allow-file-overwrite-folder", true);
        this.contentSummaryBatchCount = conf.getInt("fs.jfs.cache.get-summary.batch-size", 1000);
        this.dataVerify = conf.getBoolean("fs.jfs.cache.data.verify.enable", true);
        if (this.contentSummaryBatchCount > 1000) {
            LOG.info("fs.jfs.cache.get-summary.batch-size=" + this.contentSummaryBatchCount + ", is larger than maxValue: " + 1000);
            this.contentSummaryBatchCount = 1000;
        }
        this.deleteMarkerDirs = conf.getTrimmedStrings("fs.jfs.cache.oss.delete-marker.dirs", new String[]{"_temporary", ".staging", ".hive-staging", "__magic"});
        this.enableDeleteMarkerForAll = conf.getBoolean("fs.jfs.cache.oss.delete-all-marker", false);
        boolean usePool = conf.getBoolean("fs.jfs.cache.buffer.pool", false);
        JbootBufferFactory.setUsePool(usePool);
        boolean flushEnabled = conf.getBoolean("fs.jfs.cache.oss.flush.enable", false);
        String flushStagingPath = conf.get("fs.jfs.cache.oss.flush.staging.path", "tmp");
        this.flushContext = new OssFlushContext();
        this.flushContext.flushEnabled = flushEnabled;
        this.flushContext.flushStagingPath = flushStagingPath;
        this.ossContext.enableHiveFastRename = conf.getBoolean("fs.jfs.cache.hive-fast-move", false);
        this.ossContext.useSLD = conf.getBoolean("fs.jfs.cache.use-second-level-domain", false);
        this.ossContext.retryCount = conf.getInt("client.oss.retry", 5);
        this.ossContext.timeout = conf.getInt("client.oss.timeout.millisecond", 30000);
        this.ossContext.connectionTimeout = conf.getInt("client.oss.connection.timeout.millisecond", 30000);
        LOG.info("Filesystem support for magic committers {} enabled, write buffer size {}, read buffer size {}", new Object[]{this.magicEnabled ? "is" : "is not", this.writeBufferSize, this.readBufferSize});
    }

    public Path qualifyPath(Path path) {
        if (this.fs.getScheme().equals("jfs")) {
            return path;
        }
        Path finalPath = Utils.qualifyPath(path, this.finalUri, this.context.workingDir);
        return finalPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress, String storageOption) throws IOException {
        Path finalPath = this.qualifyPath(path);
        this.checkFileWritable(finalPath, overwrite);
        Table reply = null;
        try {
            OutputStream outputStream;
            if (this.magicEnabled && MagicCommitPaths.isMagicCommitPath(finalPath, this.magicUUID)) {
                Path destPath = MagicCommitPaths.pathOfFinalDestination(finalPath, this.finalUri.getAuthority(), this.magicUUID);
                String pendingSetPath = finalPath.toString() + ".pending";
                JindoOssMagicOutputStream.OssMagicWriteContext magicWriteContext = new JindoOssMagicOutputStream.OssMagicWriteContext();
                JbootOssWriter jbootWriter = new JbootOssWriter(this.context.ossFileletSystem.getUgi(), new JindoRequestPath(destPath.toString(), this.ossContext));
                reply = this.context.ossFileletSystem.create(new JindoRequestPath(destPath.toString(), this.ossContext), jbootWriter, storageOption, this.flushContext, this.writeBufferSize);
                int realBufferSize = ((FileletCreateReply)reply).bufferSize();
                this.initContext(magicWriteContext);
                magicWriteContext.bucket = this.context.uri.getHost();
                magicWriteContext.path = finalPath.toString();
                magicWriteContext.destPath = destPath.toString();
                magicWriteContext.pendingPath = pendingSetPath;
                magicWriteContext.jbootWriter = jbootWriter;
                magicWriteContext.bufferSize = realBufferSize;
                magicWriteContext.verifyChecksum = this.magicVerifyChecksum;
                outputStream = new JindoOssMagicOutputStream(magicWriteContext, this.ossContext);
            } else if (this.flushContext.flushEnabled) {
                JbootOssWriter jbootWriter = new JbootOssWriter(this.context.ossFileletSystem.getUgi(), new JindoRequestPath(finalPath.toString(), this.ossContext));
                reply = this.context.ossFileletSystem.create(new JindoRequestPath(finalPath.toString(), this.ossContext), jbootWriter, storageOption, this.flushContext, this.writeBufferSize);
                int realBufferSize = ((FileletCreateReply)reply).bufferSize();
                JindoOssRecoverableOutputStream.OssWriteContext writeContext = new JindoOssRecoverableOutputStream.OssWriteContext();
                this.initContext(writeContext);
                writeContext.path = finalPath;
                writeContext.key = OssUtils.pathToKey(finalPath);
                writeContext.bufferSize = realBufferSize;
                writeContext.jbootWriter = jbootWriter;
                outputStream = new JindoOssRecoverableOutputStream(writeContext);
            } else {
                JbootOssWriter jbootWriter = new JbootOssWriter(this.context.ossFileletSystem.getUgi(), new JindoRequestPath(finalPath.toString(), this.ossContext));
                reply = this.context.ossFileletSystem.create(new JindoRequestPath(finalPath.toString(), this.ossContext), jbootWriter, storageOption, this.flushContext, this.writeBufferSize);
                int realBufferSize = ((FileletCreateReply)reply).bufferSize();
                JindoOssOutputStream.OssWriteContext writeContext = new JindoOssOutputStream.OssWriteContext();
                this.initContext(writeContext);
                writeContext.path = finalPath;
                writeContext.key = OssUtils.pathToKey(finalPath);
                writeContext.bufferSize = realBufferSize;
                writeContext.jbootWriter = jbootWriter;
                outputStream = new JindoOssOutputStream(writeContext);
            }
            FSDataOutputStream fSDataOutputStream = new FSDataOutputStream(outputStream, this.context.statistics);
            return fSDataOutputStream;
        }
        finally {
            if (reply != null) {
                JbootBufferFactory.returnBuffer(reply.getByteBuffer());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress, String storageOption, String checksumInfo) throws IOException {
        Path finalPath = this.qualifyPath(path);
        this.checkFileWritable(finalPath, overwrite);
        Table reply = null;
        try {
            OutputStream outputStream;
            if (this.magicEnabled && MagicCommitPaths.isMagicCommitPath(finalPath, this.magicUUID)) {
                Path destPath = MagicCommitPaths.pathOfFinalDestination(finalPath, this.finalUri.getAuthority(), this.magicUUID);
                String pendingSetPath = finalPath.toString() + ".pending";
                JindoOssMagicOutputStream.OssMagicWriteContext magicWriteContext = new JindoOssMagicOutputStream.OssMagicWriteContext();
                JbootOssWriter jbootWriter = new JbootOssWriter(this.context.ossFileletSystem.getUgi(), new JindoRequestPath(destPath.toString(), this.ossContext));
                reply = this.context.ossFileletSystem.create(new JindoRequestPath(destPath.toString(), this.ossContext), jbootWriter, storageOption, checksumInfo, this.flushContext, this.writeBufferSize);
                int realBufferSize = ((FileletCreateReply)reply).bufferSize();
                this.initContext(magicWriteContext);
                magicWriteContext.bucket = this.context.uri.getHost();
                magicWriteContext.path = finalPath.toString();
                magicWriteContext.destPath = destPath.toString();
                magicWriteContext.pendingPath = pendingSetPath;
                magicWriteContext.jbootWriter = jbootWriter;
                magicWriteContext.bufferSize = realBufferSize;
                magicWriteContext.verifyChecksum = this.magicVerifyChecksum;
                outputStream = new JindoOssMagicOutputStream(magicWriteContext, this.ossContext);
            } else if (this.flushContext.flushEnabled) {
                JbootOssWriter jbootWriter = new JbootOssWriter(this.context.ossFileletSystem.getUgi(), new JindoRequestPath(finalPath.toString(), this.ossContext));
                reply = this.context.ossFileletSystem.create(new JindoRequestPath(finalPath.toString(), this.ossContext), jbootWriter, storageOption, checksumInfo, this.flushContext, this.writeBufferSize);
                int realBufferSize = ((FileletCreateReply)reply).bufferSize();
                JindoOssRecoverableOutputStream.OssWriteContext writeContext = new JindoOssRecoverableOutputStream.OssWriteContext();
                this.initContext(writeContext);
                writeContext.path = finalPath;
                writeContext.key = OssUtils.pathToKey(finalPath);
                writeContext.bufferSize = realBufferSize;
                writeContext.jbootWriter = jbootWriter;
                outputStream = new JindoOssRecoverableOutputStream(writeContext);
            } else {
                JbootOssWriter jbootWriter = new JbootOssWriter(this.context.ossFileletSystem.getUgi(), new JindoRequestPath(finalPath.toString(), this.ossContext));
                reply = this.context.ossFileletSystem.create(new JindoRequestPath(finalPath.toString(), this.ossContext), jbootWriter, storageOption, checksumInfo, this.flushContext, this.writeBufferSize);
                int realBufferSize = ((FileletCreateReply)reply).bufferSize();
                JindoOssOutputStream.OssWriteContext writeContext = new JindoOssOutputStream.OssWriteContext();
                this.initContext(writeContext);
                writeContext.path = finalPath;
                writeContext.key = OssUtils.pathToKey(finalPath);
                writeContext.bufferSize = realBufferSize;
                writeContext.jbootWriter = jbootWriter;
                outputStream = new JindoOssOutputStream(writeContext);
            }
            FSDataOutputStream fSDataOutputStream = new FSDataOutputStream(outputStream, this.context.statistics);
            return fSDataOutputStream;
        }
        finally {
            if (reply != null) {
                JbootBufferFactory.returnBuffer(reply.getByteBuffer());
            }
        }
    }

    private void checkFileWritable(Path f, boolean overwrite) throws IOException {
        if (overwrite && this.allowFileOverwriteFolder) {
            return;
        }
        try {
            OssFileStatus status = this.getFileStatusInternal(f, false);
            if (status.isDir()) {
                throw new FileAlreadyExistsException(f + " is a directory");
            }
            if (!overwrite) {
                throw new FileAlreadyExistsException(f + " already exists");
            }
            this.getFileStatusInternal(f, false);
            throw new FileAlreadyExistsException(f + " already exists");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
    }

    @Override
    public boolean delete(Path path, boolean recurse, boolean ignoreHidden, boolean deleteVersion) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        return this.deleteInternal(qualifiedPath, recurse, ignoreHidden, deleteVersion);
    }

    public boolean deleteInternal(Path f, boolean recurse, boolean ignoreHidden, boolean deleteVersion) throws IOException {
        try {
            boolean deleteWithVersions = deleteVersion || this.enableDeleteMarkerForAll || OssNativeStore.needDeleteVersions(f, this.deleteMarkerDirs);
            return this.ossOpBuilder.createDeleteOperation().delete(f, recurse, ignoreHidden, deleteWithVersions, this.ossContext);
        }
        catch (FileNotFoundException e) {
            LOG.debug("Delete called for '" + f + "' but file does not exist, so returning false");
            return false;
        }
    }

    public static boolean needDeleteVersions(Path f, String[] deleteMarkerDirs) {
        if (deleteMarkerDirs == null || deleteMarkerDirs.length == 0) {
            return false;
        }
        try {
            for (String dm : deleteMarkerDirs) {
                String pathStr = f.toString();
                if (!pathStr.contains(dm)) continue;
                List<String> components = OssNativeStore.getJindoPathComponents(pathStr);
                for (String comp : components) {
                    if (!comp.startsWith(dm)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOG.info("Can't detect '" + f + "' for enable deleteWithVersions or not. " + e.getMessage());
        }
        return false;
    }

    private static List<String> getJindoPathComponents(String path) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        for (String component : path.split("/")) {
            if (component.isEmpty()) continue;
            ret.add(component);
        }
        return ret;
    }

    @Override
    public FileStatus getFileStatus(Path path) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        OssFileStatus fileStatus = this.getFileStatusInternal(qualifiedPath, false);
        this.qualifyStatusResult(fileStatus);
        return fileStatus;
    }

    public OssFileStatus getOssFileStatus(Path path) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        OssFileStatus fileStatus = this.getFileStatusInternal(qualifiedPath, true);
        this.qualifyStatusResult(fileStatus);
        return fileStatus;
    }

    private OssFileStatus getFileStatusInternal(Path qualifiedPath, boolean lsExtend) throws IOException {
        if (qualifiedPath.toString().endsWith("/") && qualifiedPath.getParent() != null) {
            qualifiedPath = qualifiedPath.getParent();
        }
        return this.ossOpBuilder.createGetFileStatusOperation().getFileStatus(qualifiedPath, lsExtend);
    }

    private void qualifyStatusResult(FileStatus fileStatus) {
        Path finalPath = Utils.qualifyPath(fileStatus.getPath(), this.context.uri, this.context.workingDir);
        fileStatus.setPath(finalPath);
    }

    @Override
    public FileStatus[] listStatus(Path path, boolean recursive, boolean isCmd) throws IOException {
        FileStatus[] result;
        if (recursive) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support recursive listStatus.");
        }
        Path qualifiedPath = this.qualifyPath(path);
        for (FileStatus status : result = this.ossOpBuilder.createListStatusOperation().listStatus(qualifiedPath)) {
            this.qualifyStatusResult(status);
        }
        return result;
    }

    private FileStatus[] listStatusWithoutCreateTime(Path path) throws IOException {
        FileStatus[] result;
        Path qualifiedPath = this.qualifyPath(path);
        for (FileStatus status : result = this.ossOpBuilder.createListStatusOperation().listStatus(qualifiedPath, false, false, true)) {
            this.qualifyStatusResult(status);
        }
        return result;
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path qualifiedPath, final PathFilter filter) throws IOException {
        return new RemoteIterator<LocatedFileStatus>(){
            private final FileStatus[] stats;
            private int i;
            {
                this.stats = OssNativeStore.this.listStatus(qualifiedPath, false, false);
                this.i = 0;
            }

            public boolean hasNext() {
                while (this.i < this.stats.length) {
                    if (filter.accept(this.stats[this.i].getPath())) {
                        return true;
                    }
                    ++this.i;
                }
                return false;
            }

            public LocatedFileStatus next() throws IOException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more entry in " + qualifiedPath);
                }
                FileStatus result = this.stats[this.i++];
                BlockLocation[] locs = null;
                if (result.isFile()) {
                    if (OssNativeStore.this.enableBlockLocation) {
                        locs = OssNativeStore.this.getFileBlockLocations(result, 0L, result.getLen());
                    }
                    if (locs == null) {
                        String[] name = new String[]{"localhost:50010"};
                        String[] host = new String[]{"localhost"};
                        locs = new BlockLocation[]{new BlockLocation(name, host, 0L, result.getLen())};
                    }
                }
                return new LocatedFileStatus(result, locs);
            }
        };
    }

    @Override
    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        try {
            this.context.ossFileletSystem.mkdir(new JindoRequestPath(qualifiedPath.toString(), this.ossContext));
            return true;
        }
        catch (java.nio.file.FileAlreadyExistsException e) {
            throw new FileAlreadyExistsException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        int realBufferSize;
        Path qualifiedPath = this.qualifyPath(f);
        Table reply = null;
        OssFileStatus status = null;
        JbootOssReader jbootReader = new JbootOssReader(this.context.ossFileletSystem.getUgi(), new JindoRequestPath(qualifiedPath.toString(), this.ossContext));
        try {
            reply = this.context.ossFileletSystem.open(new JindoRequestPath(qualifiedPath.toString(), this.ossContext), jbootReader, false, this.dataVerify, this.readBufferSize);
            FileletStatus fileletStatus = ((FileletOpenReply)reply).statusAsFileletStatus();
            status = new OssFileStatus(fileletStatus, this.conf);
            realBufferSize = ((FileletOpenReply)reply).bufferSize();
        }
        finally {
            if (reply != null) {
                JbootBufferFactory.returnBuffer(reply.getByteBuffer());
            }
        }
        if (status.isDir()) {
            throw new FileNotFoundException("'" + f + "' is a directory");
        }
        LOG.debug("Opening ' {} ' for reading, size: {}", (Object)f, (Object)status.getLen());
        JindoOssInputStream.OssReadContext readContext = new JindoOssInputStream.OssReadContext();
        this.initContext(readContext.ossCtx);
        readContext.stats = this.context.statistics;
        readContext.path = qualifiedPath;
        readContext.ossCtx.key = OssUtils.pathToKey(qualifiedPath);
        readContext.fileSize = status.getLen();
        readContext.bufferSize = realBufferSize;
        int bufferNum = (int)(readContext.fileSize / (long)readContext.bufferSize);
        readContext.totalBuffers = readContext.fileSize % (long)readContext.bufferSize == 0L ? (long)bufferNum : (long)(bufferNum + 1);
        readContext.timeoutInSecond = this.conf.getInt("fs.jfs.cache.timeout.second", 10);
        JindoOssInputStream fsInputStream = new JindoOssInputStream(readContext, jbootReader);
        return new FSDataInputStream((InputStream)((Object)fsInputStream));
    }

    @Override
    public boolean rename(Path srcPath, Path dstPath, boolean appendName, boolean ignoreHidden) throws IOException {
        Path parent;
        Path qualifiedSrcPath = this.qualifyPath(srcPath);
        Path qualifiedDstPath = this.qualifyPath(dstPath);
        String srcKey = OssUtils.pathToKey(qualifiedSrcPath);
        if (srcKey.length() == 0) {
            return false;
        }
        for (parent = qualifiedDstPath.getParent(); parent != null && !qualifiedSrcPath.equals((Object)parent); parent = parent.getParent()) {
        }
        if (parent != null) {
            return false;
        }
        String debugPreamble = "Renaming '" + qualifiedSrcPath + "' to '" + qualifiedDstPath + "' - ";
        if (qualifiedSrcPath.equals((Object)qualifiedDstPath)) {
            try {
                FileStatus srcFileStatus = this.getFileStatus(qualifiedSrcPath);
                boolean srcIsFile = srcFileStatus.isFile();
                return srcIsFile;
            }
            catch (FileNotFoundException e) {
                LOG.debug("src is not found, maybe an *");
            }
        }
        OssRenameOp renameOperation = this.ossOpBuilder.createRenameOperation();
        boolean result = false;
        try {
            LOG.debug(debugPreamble + " enable atomic rename " + this.conf.getBoolean("fs.jfs.cache.atomic-rename.enable", false));
            result = this.ossContext.enableHiveFastRename && OssNativeStore.verifyDst(qualifiedDstPath.toString()) ? renameOperation.rename(qualifiedSrcPath.toString(), qualifiedDstPath.toString(), appendName, ignoreHidden, true, this.ossContext) : renameOperation.rename(qualifiedSrcPath.toString(), qualifiedDstPath.toString(), appendName, ignoreHidden, false, this.ossContext);
        }
        catch (java.nio.file.FileAlreadyExistsException e) {
            return false;
        }
        return result;
    }

    private static boolean verifyDst(String OriginPath) {
        String path = "";
        if (!OriginPath.startsWith("oss://")) {
            return false;
        }
        path = OriginPath.replace("oss://", "/");
        try {
            boolean foundHiveStagingComponent = false;
            boolean foundHiveStagingDstComponent = false;
            List<String> components = OssNativeStore.getJindoPathComponents(path);
            String bucketPrefix = "";
            for (String comp : components) {
                if (bucketPrefix == "") {
                    bucketPrefix = comp;
                }
                if (comp.startsWith(".hive-staging_hive_")) {
                    if (!foundHiveStagingComponent) {
                        foundHiveStagingComponent = true;
                        continue;
                    }
                    foundHiveStagingComponent = false;
                    break;
                }
                if (comp.startsWith("-ext-100")) {
                    if (!foundHiveStagingDstComponent) {
                        foundHiveStagingDstComponent = true;
                        continue;
                    }
                    foundHiveStagingDstComponent = false;
                    break;
                }
                if (!foundHiveStagingComponent || !foundHiveStagingDstComponent) continue;
                return false;
            }
            if (foundHiveStagingComponent && foundHiveStagingDstComponent) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (!this.enableBlockLocation) {
            return null;
        }
        Path qualifiedPath = this.qualifyPath(file.getPath());
        String path = Utils.pathToJindoPath(qualifiedPath);
        if (file == null) {
            LOG.debug("getFileBlockLocations({}, {}, {}) returned null", new Object[]{path, start, len});
            return null;
        }
        if (!(file instanceof OssFileStatus)) {
            LOG.warn("FileStatus is not OssFileStatus for path {}, cannot getFileBlockLocations", (Object)path);
            return null;
        }
        OssFileStatus ossFileStatus = (OssFileStatus)file;
        String etag = ossFileStatus.getEtag();
        LOG.debug("GetFileBlockLocations start : {}, {}, {}, {}, {}", new Object[]{path, etag, start, len, this.logicBlockSize});
        Table list = null;
        try {
            list = this.context.ossFileletSystem.getFileBlockLocations(new JindoRequestPath(path, this.ossContext), etag, start, len, this.logicBlockSize);
            LOG.debug("GetFileBlockLocations end : {}, {}, {}, {} returned {}", new Object[]{path, start, len, this.logicBlockSize, list == null ? null : Integer.valueOf(((BlockInfoList)list).blocksLength())});
            BlockLocation[] blockLocationArray = this.getBlockLocation((BlockInfoList)list, file.getLen());
            return blockLocationArray;
        }
        finally {
            if (list != null) {
                JbootBufferFactory.returnBuffer(list.getByteBuffer());
            }
        }
    }

    private BlockLocation[] getBlockLocation(BlockInfoList list, long fileSize) {
        if (list != null && list.blocksLength() > 0) {
            BlockLocation[] blockLocations = new BlockLocation[list.blocksLength()];
            for (int i = 0; i < list.blocksLength(); ++i) {
                BlockInfo info = list.blocks(i);
                ArrayList<String> hosts = new ArrayList<String>();
                ArrayList<String> names = new ArrayList<String>();
                StringList blockHosts = StringList.getRootAsStringList(info.locationsAsByteBuffer());
                for (int j = 0; j < blockHosts.stringsLength(); ++j) {
                    String ip;
                    String host;
                    String hostAndPort = blockHosts.strings(j);
                    String[] hostPort = hostAndPort.split(":");
                    String hostName = hostPort[0];
                    String port = hostPort.length > 1 ? hostPort[1] : "6101";
                    try {
                        InetAddress addr = InetAddress.getByName(hostName);
                        addr.getHostAddress();
                        host = addr.getHostName();
                        ip = addr.getHostAddress();
                    }
                    catch (Exception e) {
                        host = hostName;
                        ip = hostName;
                    }
                    String ipAndPort = ip + ":" + port;
                    hosts.add(host);
                    names.add(ipAndPort);
                }
                long blockOffset = info.start();
                long remainingSize = fileSize - blockOffset;
                long blockLength = Math.min(remainingSize, this.logicBlockSize);
                blockLocations[i] = new BlockLocation(names.toArray(new String[blockHosts.stringsLength()]), hosts.toArray(new String[blockHosts.stringsLength()]), blockOffset, blockLength);
            }
            return blockLocations;
        }
        return null;
    }

    @Override
    public byte[] getXAttr(Path path, String name) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeXAttr");
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeXAttr");
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeXAttr");
    }

    @Override
    public void setXAttr(Path path, String name, byte[] value) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeXAttr");
    }

    @Override
    public List<String> listXAttrs(Path path) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeXAttr");
    }

    @Override
    public void removeXAttr(Path path, String name) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeXAttr");
    }

    @Override
    public void checkPermission(Path path, FsAction mode) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        boolean result = false;
        try {
            LOG.debug("checkPermission for path {}", (Object)key);
            result = this.context.ossFileletSystem.checkPermission(new JindoRequestPath(key, this.ossContext), false, (short)0, (short)mode.ordinal());
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            LOG.info("checkPermission for path {} result {}", (Object)key, (Object)result);
        }
    }

    @Override
    public void setPermission(Path p, FsPermission permission) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support setPermission");
    }

    @Override
    public void processPermissionDelta(Path path, short permission, short permissionDelta, boolean recursive) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support processPermissionDelta");
    }

    @Override
    public void setOwner(Path path, String username, String groupName, boolean recursive) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support processPermissionDelta");
    }

    @Override
    public void setOwner(Path p, String username, String groupName) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support setOwner");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentSummary getContentSummary(Path path) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String key = Utils.pathToJindoPath(qualifiedPath);
        Table fileletSummary = null;
        try {
            fileletSummary = this.context.ossFileletSystem.getContentSummary(new JindoRequestPath(key, this.ossContext), this.contentSummaryBatchCount);
            if (fileletSummary != null) {
                ContentSummary contentSummary = new ContentSummary(((FileletSummary)fileletSummary).fileLength(), ((FileletSummary)fileletSummary).fileCount(), ((FileletSummary)fileletSummary).directoryCount(), -1L, ((FileletSummary)fileletSummary).fileLength(), -1L);
                return contentSummary;
            }
            ContentSummary contentSummary = new ContentSummary();
            return contentSummary;
        }
        finally {
            if (fileletSummary != null && fileletSummary.getByteBuffer() != null) {
                JbootBufferFactory.returnBuffer(fileletSummary.getByteBuffer());
            }
        }
    }

    @Override
    public FileChecksum getFileChecksum(Path path) throws IOException {
        String checksum = this.ossOpBuilder.createGetFileChecksumOperation().getFileChecksum(path, this.ossContext);
        return new Crc64FileChecksum(checksum);
    }

    @Override
    public FileChecksum getFileChecksum2(Path path) throws IOException {
        String checksum = this.ossOpBuilder.createGetFileChecksum2Operation().getFileChecksum2(path, this.ossContext);
        return new Crc32FileChecksum(checksum);
    }

    @Override
    public FileChecksum getFileChecksum2(Path path, long blockSize) throws IOException {
        return this.getFileChecksum2(path);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public Boolean isMagicCommitEnabled() {
        return this.magicEnabled;
    }

    private void initContext(OssOpContext ossOpContext) {
        ossOpContext.ossFileletSystem = this.context.ossFileletSystem;
        ossOpContext.conf = this.conf;
        ossOpContext.stats = this.context.statistics;
    }

    public OssOpBuilder getOssOpBuilder() {
        return this.ossOpBuilder;
    }

    public OssFileletSystem getOssFileletSystem() {
        return this.context.ossFileletSystem;
    }

    public CredentialContext getOssContext() {
        return this.ossContext;
    }

    @Override
    public void cache(Path path, AbstractJindoShimsFileSystem.CacheOpContext opContext) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            this.context.ossFileletSystem.cache(new JindoRequestPath(filePath, this.ossContext), opContext, 36000L);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to cache " + filePath);
            throw e;
        }
    }

    @Override
    public void atomicCache(Path path, AbstractJindoShimsFileSystem.CacheOpContext opContext) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            this.context.ossFileletSystem.atomicCache(new JindoRequestPath(filePath, this.ossContext), opContext, 36000L);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to cache " + filePath);
            throw e;
        }
    }

    @Override
    public void uncache(Path path) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            this.context.ossFileletSystem.uncache(new JindoRequestPath(filePath, this.ossContext), 10000L);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to uncache " + filePath);
            throw e;
        }
    }

    @Override
    public void archive(Path path, Byte policy) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            this.context.ossFileletSystem.archive(new JindoRequestPath(filePath, this.ossContext), policy, 10000L);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to archive " + filePath + " policy " + StoragePolicy.name(policy.byteValue()));
            throw e;
        }
    }

    @Override
    public void unarchive(Path path, Byte policy) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            this.context.ossFileletSystem.unarchive(new JindoRequestPath(filePath, this.ossContext), policy, 10000L);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to unarchive " + filePath + " policy " + StoragePolicy.name(policy.byteValue()));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileletStatus[] checkProgress(Path path, boolean detailed) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        Table list = null;
        try {
            list = this.context.ossFileletSystem.checkProgress(new JindoRequestPath(filePath, this.ossContext), detailed, 10000L);
            FileletStatus[] fileStatuses = new FileletStatus[((FileletStatusList)list).filesLength()];
            for (int i = 0; i < ((FileletStatusList)list).filesLength(); ++i) {
                fileStatuses[i] = ((FileletStatusList)list).files(i);
            }
            FileletStatus[] fileletStatusArray = fileStatuses;
            return fileletStatusArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to checkProgress " + filePath);
            FileletStatus[] fileletStatusArray = null;
            return fileletStatusArray;
        }
        finally {
            if (list != null) {
                JbootBufferFactory.returnBuffer(list.getByteBuffer());
            }
        }
    }

    @Override
    public CltRecoverReply recoverCore(Path path, boolean recursive) throws IOException {
        Path finalPath = this.qualifyPath(path);
        this.checkFileWritable(finalPath, true);
        try {
            return this.context.ossFileletSystem.recover(new JindoRequestPath(finalPath.toString(), this.ossContext), recursive, this.flushContext);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to recover " + finalPath.toString());
            throw e;
        }
    }

    @Override
    public CltArchiveDirReply archiveDir(Path path, Byte policy) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            return this.context.ossFileletSystem.archiveDir(new JindoRequestPath(filePath, this.ossContext), policy);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to archive " + filePath + " policy " + StoragePolicy.name(policy.byteValue()));
            throw e;
        }
    }

    @Override
    public CltUnarchiveDirReply unarchiveDir(Path path, Byte policy) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            return this.context.ossFileletSystem.unarchiveDir(new JindoRequestPath(filePath, this.ossContext), policy);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to unarchive " + filePath + " policy " + StoragePolicy.name(policy.byteValue()));
            throw e;
        }
    }

    @Override
    public CltRestoreDirReply restoreDir(Path path) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            return this.context.ossFileletSystem.restoreDir(new JindoRequestPath(filePath, this.ossContext));
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to unarchive " + filePath);
            throw e;
        }
    }

    @Override
    public NssFileletDiffReply metaDiff(Path path, boolean recursive) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            return this.context.ossFileletSystem.metaDiff(new JindoRequestPath(filePath, this.ossContext), recursive);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to cache " + filePath);
            throw e;
        }
    }

    @Override
    public void metaSync(Path path, boolean recursive, boolean progressable) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            this.context.ossFileletSystem.metaSync(new JindoRequestPath(filePath, this.ossContext), recursive, progressable);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to cache " + filePath);
            throw e;
        }
    }

    public class OssOpBuilder {
        public OssRenameOp createRenameOperation() throws IOException {
            boolean atomicRename;
            OssRenameOp.OssRenameContext context = new OssRenameOp.OssRenameContext();
            OssNativeStore.this.initContext(context);
            context.maxSimpleCopySize = OssNativeStore.this.conf.getLong("fs.jfs.cache.copy.simple.max.byte", -1L);
            context.atomicRename = atomicRename = OssNativeStore.this.conf.getBoolean("fs.jfs.cache.atomic-rename.enable", false);
            context.batchSize = OssNativeStore.this.conf.getInt("fs.jfs.cache.batch-copy.size", 0);
            if (context.batchSize > 100) {
                context.batchSize = 100;
            }
            OssAtomicRenameContext atomicRenameContext = new OssAtomicRenameContext();
            if (atomicRename) {
                long timeout;
                String typeStr = OssNativeStore.this.conf.getTrimmed("fs.jfs.cache.atomic.rename.type", "NS");
                atomicRenameContext.timeout = timeout = OssNativeStore.this.conf.getLong("fs.jfs.cache.atomic.rename.timeout", 100000L);
                if ("NS".equals(typeStr)) {
                    atomicRenameContext.type = 0;
                } else if ("OTS".equals(typeStr)) {
                    atomicRenameContext.type = 1;
                    OssAtomicRenameContext.OtsOptions otsOptions = OssCredentialUtils.createOtsCredential(OssNativeStore.this.conf);
                    String endpoint = OssNativeStore.this.conf.getTrimmed("fs.jfs.cache.ots.endpoint");
                    if (StringUtils.isEmpty(endpoint)) {
                        throw new IOException("ERROR: fail to get TableStore endpoint for atomic rename.");
                    }
                    otsOptions.endpoint = OssNativeStore.this.conf.getTrimmed("fs.jfs.cache.ots.endpoint");
                    String tableName = OssNativeStore.this.conf.getTrimmed("fs.jfs.cache.ots.tableName");
                    if (StringUtils.isEmpty(tableName)) {
                        throw new IOException("ERROR: fail to get TableStore tableName for atomic rename.");
                    }
                    otsOptions.tableName = OssNativeStore.this.conf.getTrimmed("fs.jfs.cache.ots.tableName");
                    atomicRenameContext.otsOptions = otsOptions;
                } else if ("OSS".equals(typeStr)) {
                    atomicRenameContext.type = (byte)2;
                } else {
                    throw new IOException("ERROR: the atomic rename type: " + typeStr + " is not supported.");
                }
            }
            context.atomicRenameContext = atomicRenameContext;
            return new OssRenameOp(context);
        }

        public OssDeleteOp createDeleteOperation() {
            OssOpContext context = new OssOpContext();
            OssNativeStore.this.initContext(context);
            return new OssDeleteOp(context, OssNativeStore.this.fs, OssNativeStore.this.ossContext);
        }

        public OssListStatusOp createListStatusOperation() {
            OssOpContext context = new OssOpContext();
            OssNativeStore.this.initContext(context);
            return new OssListStatusOp(context, OssNativeStore.this.fs, OssNativeStore.this.ossContext);
        }

        public OssGetFileStatusOp createGetFileStatusOperation() {
            OssOpContext context = new OssOpContext();
            OssNativeStore.this.initContext(context);
            return new OssGetFileStatusOp(context, OssNativeStore.this.fs, OssNativeStore.this.ossContext);
        }

        public OssGetFileChecksumOp createGetFileChecksumOperation() {
            OssOpContext context = new OssOpContext();
            OssNativeStore.this.initContext(context);
            return new OssGetFileChecksumOp(context, OssNativeStore.this.fs, OssNativeStore.this.ossContext);
        }

        public OssGetFileChecksum2Op createGetFileChecksum2Operation() {
            OssOpContext context = new OssOpContext();
            OssNativeStore.this.initContext(context);
            return new OssGetFileChecksum2Op(context, OssNativeStore.this.fs, OssNativeStore.this.ossContext);
        }
    }

    public static class Context
    extends AbstractFileSystemStore.Context {
        public final OssFileletSystem ossFileletSystem = new OssFileletSystem();
        public String prefix;
        public long namespaceConnectId = 0L;
        public AliyunCredentialProviderList credentialProviders;
    }
}

