/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.jfs;

import com.aliyun.emr.fs.internal.jfs.JfsFileStatus;
import com.aliyun.emr.fs.internal.jfs.JfsLocatedFileStatus;
import com.aliyun.emr.fs.jfs.JindoFileSystem;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class JindoBatchMetaHelperImpl {
    public static final Log LOG = LogFactory.getLog(JindoBatchMetaHelperImpl.class);

    private JindoBatchMetaHelperImpl() {
    }

    public static Boolean isBatchMetaSupported(FileSystem fs, Path path) {
        if (fs instanceof JindoFileSystem) {
            JindoFileSystem jfs = (JindoFileSystem)fs;
            return jfs.isBatchMetaSupported();
        }
        return false;
    }

    public static Path composeReadPath(FileSystem fs, FileStatus fileStatus) {
        Path realPath = fileStatus.getPath();
        if (fs != null && !JindoBatchMetaHelperImpl.isBatchMetaSupported(fs, null).booleanValue()) {
            return realPath;
        }
        if (!JindoBatchMetaHelperImpl.isJfs(realPath)) {
            return realPath;
        }
        String inodeId = JindoBatchMetaHelperImpl.getINodeId(fileStatus);
        if (inodeId == null) {
            return realPath;
        }
        String oldName = realPath.getName();
        if (oldName.endsWith("JindoCompositeName")) {
            return realPath;
        }
        String newName = oldName + "_" + inodeId + "_" + fileStatus.getLen() + "JindoCompositeName";
        return new Path(realPath.getParent(), newName);
    }

    public static void composeReadPathList(FileSystem fs, FileStatus[] fileStatusList) {
        if (fileStatusList.length == 0) {
            return;
        }
        if (fs != null && !JindoBatchMetaHelperImpl.isBatchMetaSupported(fs, null).booleanValue()) {
            return;
        }
        if (!JindoBatchMetaHelperImpl.isJfs(fileStatusList[0].getPath())) {
            return;
        }
        for (FileStatus fileStatus : fileStatusList) {
            String oldName;
            Path realPath = fileStatus.getPath();
            String inodeId = JindoBatchMetaHelperImpl.getINodeId(fileStatus);
            if (inodeId == null) break;
            if (fileStatus.isDirectory() || (oldName = realPath.getName()).endsWith("JindoCompositeName")) continue;
            Path jfsPath = JindoBatchMetaHelperImpl.composeReadPathInternal(realPath, inodeId, fileStatus.getLen());
            fileStatus.setPath(jfsPath);
        }
    }

    public static Path composeCreatePath(FileSystem fs, Path realPath) {
        if (fs != null && !JindoBatchMetaHelperImpl.isBatchMetaSupported(fs, null).booleanValue()) {
            return realPath;
        }
        String newName = realPath.getName() + "_JINDO_CREATE2_FLAG";
        return new Path(realPath.getParent(), newName);
    }

    public static Path composeClosePath(FileSystem fs, Path realPath) throws IOException {
        if (fs != null && !JindoBatchMetaHelperImpl.isBatchMetaSupported(fs, null).booleanValue()) {
            return realPath;
        }
        if (fs instanceof JindoFileSystem) {
            JindoFileSystem jfs = (JindoFileSystem)fs;
            return jfs.composeClosePath(realPath);
        }
        throw new IOException("fs is not instanceof JindoFileSystem, cannot call close2");
    }

    public static void closeBatch(FileSystem fs, List<String> paths, Boolean abort) throws IOException {
        if (!(fs instanceof JindoFileSystem)) {
            throw new IOException("fs is not instanceof JindoFileSystem, cannot call close2");
        }
        JindoFileSystem jfs = (JindoFileSystem)fs;
        jfs.close2(paths, abort);
    }

    private static String getINodeId(FileStatus fileStatus) {
        if (fileStatus == null) {
            return null;
        }
        if (fileStatus instanceof JfsFileStatus) {
            JfsFileStatus jfsFileStatus = (JfsFileStatus)fileStatus;
            return jfsFileStatus.getINodeId();
        }
        if (fileStatus instanceof JfsLocatedFileStatus) {
            JfsLocatedFileStatus jfsFileStatus = (JfsLocatedFileStatus)fileStatus;
            return jfsFileStatus.getINodeId();
        }
        return null;
    }

    private static boolean isJfs(Path path) {
        URI uri = path.toUri();
        return uri.getScheme().equalsIgnoreCase("jfs");
    }

    private static Path composeReadPathInternal(Path realPath, String inodeId, long fileSize) {
        String newName = realPath.getName() + "_" + inodeId + "_" + fileSize + "JindoCompositeName";
        return new Path(realPath.getParent(), newName);
    }
}

