/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.oss.commit.magic;

import com.aliyun.emr.fs.common.AbstractJindoShimsFileSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSSClientUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OSSClientUtils.class);

    public static List<LocatedFileStatus> listAndFilter(FileSystem fileSystem, Path path, boolean recursive, PathFilter filter) throws IOException {
        LOG.info("list pendingset files from {}", (Object)path.toString());
        return OSSClientUtils.flatmapLocatedFiles((RemoteIterator<LocatedFileStatus>)fileSystem.listFiles(path, recursive), status -> OSSClientUtils.maybe(filter.accept(status.getPath()), status));
    }

    public static <T> List<T> flatmapLocatedFiles(RemoteIterator<LocatedFileStatus> iterator, LocatedFileStatusMap<Optional<T>> eval) throws IOException {
        ArrayList results = new ArrayList();
        OSSClientUtils.applyLocatedFiles(iterator, s -> ((Optional)eval.call(s)).map(r -> results.add(r)));
        return results;
    }

    public static <T> Optional<T> maybe(boolean include, T value) {
        return include ? Optional.of(value) : Optional.empty();
    }

    public static long applyLocatedFiles(RemoteIterator<LocatedFileStatus> iterator, CallOnLocatedFileStatus eval) throws IOException {
        long count = 0L;
        while (iterator.hasNext()) {
            ++count;
            eval.call((LocatedFileStatus)iterator.next());
        }
        return count;
    }

    public static void deleteQuietly(FileSystem fs, Path path, boolean recursive) {
        try {
            fs.delete(path, recursive);
        }
        catch (IOException e) {
            LOG.debug("Failed to delete {}", (Object)path, (Object)e);
        }
    }

    public static void deleteWithWarning(FileSystem fs, Path path, boolean recursive, boolean tryDeleteVersions) {
        try {
            if (fs instanceof AbstractJindoShimsFileSystem && ((AbstractJindoShimsFileSystem)fs).isCacheMode().booleanValue()) {
                ((AbstractJindoShimsFileSystem)fs).delete(path, recursive, tryDeleteVersions);
            } else {
                fs.delete(path, recursive);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to delete {}", (Object)path, (Object)e);
        }
    }

    @FunctionalInterface
    public static interface LocatedFileStatusMap<T> {
        public T call(LocatedFileStatus var1) throws IOException;
    }

    @FunctionalInterface
    public static interface CallOnLocatedFileStatus {
        public void call(LocatedFileStatus var1) throws IOException;
    }
}

