/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.spark.streaming.loghub;

import com.aliyun.openservices.loghub.client.config.LogHubCursorPosition;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.streaming.Durations$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.streaming.loghub.LoghubUtils$;
import org.apache.spark.streaming.loghub.StreamingParam;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class LogHubStreamingDemo$ {
    public static final LogHubStreamingDemo$ MODULE$;

    static {
        new LogHubStreamingDemo$();
    }

    /*
     * WARNING - void declaration
     */
    public StreamingParam buildParam(SparkConf conf) {
        void var2_2;
        StreamingParam sp2 = new StreamingParam();
        sp2.setId(conf.get("spark.logservice.accessKeyId"));
        sp2.setSecret(conf.get("spark.logservice.accessKeySecret"));
        sp2.setEndpoint(conf.get("spark.logservice.endpoint"));
        sp2.setProject(conf.get("spark.logservice.project"));
        sp2.setLogstore(conf.get("spark.logservice.logstore"));
        sp2.setCursor(LogHubCursorPosition.END_CURSOR);
        sp2.setGroup("test");
        sp2.setLevel(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        return var2_2;
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf(true).setAppName("LogHubStreamingDemo");
        SparkContext sc = new SparkContext(conf);
        StreamingContext ssc = new StreamingContext(sc, Durations$.MODULE$.seconds(5L));
        DStream lines = LoghubUtils$.MODULE$.createStream(ssc, this.buildParam(conf), 1).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final String apply(byte[] line) {
                void var2_2;
                String str = new String(line);
                return var2_2;
            }
        }, ClassTag$.MODULE$.apply(String.class));
        DStream words = lines.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String x$1) {
                return Predef$.MODULE$.refArrayOps((Object[])x$1.split(" "));
            }
        }, ClassTag$.MODULE$.apply(String.class));
        DStream pairs = words.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(String word) {
                return new Tuple2((Object)word, (Object)BoxesRunTime.boxToInteger((int)1));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        DStream wordCounts = DStream$.MODULE$.toPairDStreamFunctions(pairs, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$2, int x$3) {
                return this.apply$mcIII$sp(x$2, x$3);
            }

            public int apply$mcIII$sp(int x$2, int x$3) {
                return x$2 + x$3;
            }
        });
        wordCounts.print();
        ssc.start();
        ssc.awaitTermination();
    }

    private LogHubStreamingDemo$() {
        MODULE$ = this;
    }
}

