/*
 * Decompiled with CFR 0.152.
 */
package bigboot.protocol.type;

import bigboot.protocol.type.CryptoPolicy;
import bigboot.protocol.type.DirectorySnapshottableFeatureData;
import bigboot.protocol.type.DirectoryStatistics;
import bigboot.protocol.type.DirectoryWithSnapshotFeatureData;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.alibaba.jboot.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class HdfsInodeDirectoryStatus
extends Table {
    public static HdfsInodeDirectoryStatus getRootAsHdfsInodeDirectoryStatus(ByteBuffer _bb) {
        return HdfsInodeDirectoryStatus.getRootAsHdfsInodeDirectoryStatus(_bb, new HdfsInodeDirectoryStatus());
    }

    public static HdfsInodeDirectoryStatus getRootAsHdfsInodeDirectoryStatus(ByteBuffer _bb, HdfsInodeDirectoryStatus obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
    }

    public HdfsInodeDirectoryStatus __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public byte fileType() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public boolean mutateFileType(byte fileType) {
        int o = this.__offset(4);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, fileType);
            return true;
        }
        return false;
    }

    public String fileId() {
        int o = this.__offset(6);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer fileIdAsByteBuffer() {
        return this.__vector_as_bytebuffer(6, 1);
    }

    public ByteBuffer fileIdInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 6, 1);
    }

    public String parentId() {
        int o = this.__offset(8);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer parentIdAsByteBuffer() {
        return this.__vector_as_bytebuffer(8, 1);
    }

    public ByteBuffer parentIdInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 8, 1);
    }

    public String fileName() {
        int o = this.__offset(10);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer fileNameAsByteBuffer() {
        return this.__vector_as_bytebuffer(10, 1);
    }

    public ByteBuffer fileNameInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 10, 1);
    }

    public long fileSize() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateFileSize(long fileSize) {
        int o = this.__offset(12);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, fileSize);
            return true;
        }
        return false;
    }

    public short permission() {
        int o = this.__offset(14);
        return o != 0 ? this.bb.getShort(o + this.bb_pos) : (short)509;
    }

    public boolean mutatePermission(short permission) {
        int o = this.__offset(14);
        if (o != 0) {
            this.bb.putShort(o + this.bb_pos, permission);
            return true;
        }
        return false;
    }

    public String owner() {
        int o = this.__offset(16);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer ownerAsByteBuffer() {
        return this.__vector_as_bytebuffer(16, 1);
    }

    public ByteBuffer ownerInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 16, 1);
    }

    public String ownerGroup() {
        int o = this.__offset(18);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer ownerGroupAsByteBuffer() {
        return this.__vector_as_bytebuffer(18, 1);
    }

    public ByteBuffer ownerGroupInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 18, 1);
    }

    public long mtime() {
        int o = this.__offset(20);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateMtime(long mtime) {
        int o = this.__offset(20);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, mtime);
            return true;
        }
        return false;
    }

    public String attributes() {
        int o = this.__offset(22);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer attributesAsByteBuffer() {
        return this.__vector_as_bytebuffer(22, 1);
    }

    public ByteBuffer attributesInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 22, 1);
    }

    public byte state() {
        int o = this.__offset(24);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)2;
    }

    public boolean mutateState(byte state) {
        int o = this.__offset(24);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, state);
            return true;
        }
        return false;
    }

    public byte storagePolicy() {
        int o = this.__offset(26);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)5;
    }

    public boolean mutateStoragePolicy(byte storagePolicy) {
        int o = this.__offset(26);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, storagePolicy);
            return true;
        }
        return false;
    }

    public String etag() {
        int o = this.__offset(28);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer etagAsByteBuffer() {
        return this.__vector_as_bytebuffer(28, 1);
    }

    public ByteBuffer etagInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 28, 1);
    }

    public boolean directChildrenLoaded() {
        int o = this.__offset(30);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean mutateDirectChildrenLoaded(boolean directChildrenLoaded) {
        int o = this.__offset(30);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, (byte)(directChildrenLoaded ? 1 : 0));
            return true;
        }
        return false;
    }

    public long atime() {
        int o = this.__offset(32);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateAtime(long atime) {
        int o = this.__offset(32);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, atime);
            return true;
        }
        return false;
    }

    public String statistics() {
        int o = this.__offset(34);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer statisticsAsByteBuffer() {
        return this.__vector_as_bytebuffer(34, 1);
    }

    public ByteBuffer statisticsInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 34, 1);
    }

    public DirectoryStatistics statisticsAsDirectoryStatistics() {
        return this.statisticsAsDirectoryStatistics(new DirectoryStatistics());
    }

    public DirectoryStatistics statisticsAsDirectoryStatistics(DirectoryStatistics obj) {
        int o = this.__offset(34);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o)), this.bb) : null;
    }

    public byte compressionType() {
        int o = this.__offset(36);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public boolean mutateCompressionType(byte compressionType) {
        int o = this.__offset(36);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, compressionType);
            return true;
        }
        return false;
    }

    public String cryptoPolicy() {
        int o = this.__offset(38);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer cryptoPolicyAsByteBuffer() {
        return this.__vector_as_bytebuffer(38, 1);
    }

    public ByteBuffer cryptoPolicyInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 38, 1);
    }

    public CryptoPolicy cryptoPolicyAsCryptoPolicy() {
        return this.cryptoPolicyAsCryptoPolicy(new CryptoPolicy());
    }

    public CryptoPolicy cryptoPolicyAsCryptoPolicy(CryptoPolicy obj) {
        int o = this.__offset(38);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o)), this.bb) : null;
    }

    public byte shardPolicy() {
        int o = this.__offset(40);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public boolean mutateShardPolicy(byte shardPolicy) {
        int o = this.__offset(40);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, shardPolicy);
            return true;
        }
        return false;
    }

    public String dirSnapshottable() {
        int o = this.__offset(42);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer dirSnapshottableAsByteBuffer() {
        return this.__vector_as_bytebuffer(42, 1);
    }

    public ByteBuffer dirSnapshottableInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 42, 1);
    }

    public DirectorySnapshottableFeatureData dirSnapshottableAsDirectorySnapshottableFeatureData() {
        return this.dirSnapshottableAsDirectorySnapshottableFeatureData(new DirectorySnapshottableFeatureData());
    }

    public DirectorySnapshottableFeatureData dirSnapshottableAsDirectorySnapshottableFeatureData(DirectorySnapshottableFeatureData obj) {
        int o = this.__offset(42);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o)), this.bb) : null;
    }

    public String dirWithSnapshot() {
        int o = this.__offset(44);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer dirWithSnapshotAsByteBuffer() {
        return this.__vector_as_bytebuffer(44, 1);
    }

    public ByteBuffer dirWithSnapshotInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 44, 1);
    }

    public DirectoryWithSnapshotFeatureData dirWithSnapshotAsDirectoryWithSnapshotFeatureData() {
        return this.dirWithSnapshotAsDirectoryWithSnapshotFeatureData(new DirectoryWithSnapshotFeatureData());
    }

    public DirectoryWithSnapshotFeatureData dirWithSnapshotAsDirectoryWithSnapshotFeatureData(DirectoryWithSnapshotFeatureData obj) {
        int o = this.__offset(44);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o)), this.bb) : null;
    }

    public static int createHdfsInodeDirectoryStatus(FlatBufferBuilder builder, byte fileType, int fileIdOffset, int parentIdOffset, int fileNameOffset, long fileSize, short permission, int ownerOffset, int ownerGroupOffset, long mtime, int attributesOffset, byte state, byte storagePolicy, int etagOffset, boolean directChildrenLoaded, long atime, int statisticsOffset, byte compressionType, int cryptoPolicyOffset, byte shardPolicy, int dirSnapshottableOffset, int dirWithSnapshotOffset) {
        builder.startObject(21);
        HdfsInodeDirectoryStatus.addAtime(builder, atime);
        HdfsInodeDirectoryStatus.addMtime(builder, mtime);
        HdfsInodeDirectoryStatus.addFileSize(builder, fileSize);
        HdfsInodeDirectoryStatus.addDirWithSnapshot(builder, dirWithSnapshotOffset);
        HdfsInodeDirectoryStatus.addDirSnapshottable(builder, dirSnapshottableOffset);
        HdfsInodeDirectoryStatus.addCryptoPolicy(builder, cryptoPolicyOffset);
        HdfsInodeDirectoryStatus.addStatistics(builder, statisticsOffset);
        HdfsInodeDirectoryStatus.addEtag(builder, etagOffset);
        HdfsInodeDirectoryStatus.addAttributes(builder, attributesOffset);
        HdfsInodeDirectoryStatus.addOwnerGroup(builder, ownerGroupOffset);
        HdfsInodeDirectoryStatus.addOwner(builder, ownerOffset);
        HdfsInodeDirectoryStatus.addFileName(builder, fileNameOffset);
        HdfsInodeDirectoryStatus.addParentId(builder, parentIdOffset);
        HdfsInodeDirectoryStatus.addFileId(builder, fileIdOffset);
        HdfsInodeDirectoryStatus.addPermission(builder, permission);
        HdfsInodeDirectoryStatus.addShardPolicy(builder, shardPolicy);
        HdfsInodeDirectoryStatus.addCompressionType(builder, compressionType);
        HdfsInodeDirectoryStatus.addDirectChildrenLoaded(builder, directChildrenLoaded);
        HdfsInodeDirectoryStatus.addStoragePolicy(builder, storagePolicy);
        HdfsInodeDirectoryStatus.addState(builder, state);
        HdfsInodeDirectoryStatus.addFileType(builder, fileType);
        return HdfsInodeDirectoryStatus.endHdfsInodeDirectoryStatus(builder);
    }

    public static void startHdfsInodeDirectoryStatus(FlatBufferBuilder builder) {
        builder.startObject(21);
    }

    public static void addFileType(FlatBufferBuilder builder, byte fileType) {
        builder.addByte(0, fileType, 0);
    }

    public static void addFileId(FlatBufferBuilder builder, int fileIdOffset) {
        builder.addOffset(1, fileIdOffset, 0);
    }

    public static void addParentId(FlatBufferBuilder builder, int parentIdOffset) {
        builder.addOffset(2, parentIdOffset, 0);
    }

    public static void addFileName(FlatBufferBuilder builder, int fileNameOffset) {
        builder.addOffset(3, fileNameOffset, 0);
    }

    public static void addFileSize(FlatBufferBuilder builder, long fileSize) {
        builder.addLong(4, fileSize, 0L);
    }

    public static void addPermission(FlatBufferBuilder builder, short permission) {
        builder.addShort(5, permission, 509);
    }

    public static void addOwner(FlatBufferBuilder builder, int ownerOffset) {
        builder.addOffset(6, ownerOffset, 0);
    }

    public static void addOwnerGroup(FlatBufferBuilder builder, int ownerGroupOffset) {
        builder.addOffset(7, ownerGroupOffset, 0);
    }

    public static void addMtime(FlatBufferBuilder builder, long mtime) {
        builder.addLong(8, mtime, 0L);
    }

    public static void addAttributes(FlatBufferBuilder builder, int attributesOffset) {
        builder.addOffset(9, attributesOffset, 0);
    }

    public static void addState(FlatBufferBuilder builder, byte state) {
        builder.addByte(10, state, 2);
    }

    public static void addStoragePolicy(FlatBufferBuilder builder, byte storagePolicy) {
        builder.addByte(11, storagePolicy, 5);
    }

    public static void addEtag(FlatBufferBuilder builder, int etagOffset) {
        builder.addOffset(12, etagOffset, 0);
    }

    public static void addDirectChildrenLoaded(FlatBufferBuilder builder, boolean directChildrenLoaded) {
        builder.addBoolean(13, directChildrenLoaded, false);
    }

    public static void addAtime(FlatBufferBuilder builder, long atime) {
        builder.addLong(14, atime, 0L);
    }

    public static void addStatistics(FlatBufferBuilder builder, int statisticsOffset) {
        builder.addOffset(15, statisticsOffset, 0);
    }

    public static void addCompressionType(FlatBufferBuilder builder, byte compressionType) {
        builder.addByte(16, compressionType, 0);
    }

    public static void addCryptoPolicy(FlatBufferBuilder builder, int cryptoPolicyOffset) {
        builder.addOffset(17, cryptoPolicyOffset, 0);
    }

    public static void addShardPolicy(FlatBufferBuilder builder, byte shardPolicy) {
        builder.addByte(18, shardPolicy, 0);
    }

    public static void addDirSnapshottable(FlatBufferBuilder builder, int dirSnapshottableOffset) {
        builder.addOffset(19, dirSnapshottableOffset, 0);
    }

    public static void addDirWithSnapshot(FlatBufferBuilder builder, int dirWithSnapshotOffset) {
        builder.addOffset(20, dirWithSnapshotOffset, 0);
    }

    public static int endHdfsInodeDirectoryStatus(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }
}

