/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot.protocols;

import bigboot.protocol.type.CltOssCopyObjectRequest;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.alibaba.jboot.google.flatbuffers.JbootFlatBufferBuilder;
import com.alibaba.jboot.protocols.JniRequestWrapper;
import com.alibaba.jfs.CredentialContext;
import java.nio.ByteBuffer;

public class OssCopyObjectRequestWrapper
extends JniRequestWrapper {
    private String sourceBucket;
    private String sourceKey;
    private String sourceVersionId;
    private String destinationBucket;
    private String destinationKey;

    public OssCopyObjectRequestWrapper(String sourceBucket, String sourceKey, String sourceVersionId, String destinationBucket, String destinationKey, CredentialContext ossContext) {
        this.sourceBucket = sourceBucket;
        this.sourceKey = sourceKey;
        this.sourceVersionId = sourceVersionId;
        this.destinationBucket = destinationBucket;
        this.destinationKey = destinationKey;
        this.ossContext = ossContext;
    }

    @Override
    protected ByteBuffer toFbBuffer() {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int sourceBucketOffset = ((FlatBufferBuilder)builder).createString(this.sourceBucket);
        int sourceObjectOffset = ((FlatBufferBuilder)builder).createString(this.sourceKey);
        int sourceVersionIdOffset = ((FlatBufferBuilder)builder).createString("");
        if (this.sourceVersionId != null) {
            sourceVersionIdOffset = ((FlatBufferBuilder)builder).createString(this.sourceVersionId);
        }
        int destinationBucketOffset = ((FlatBufferBuilder)builder).createString(this.destinationBucket);
        int destinationKeyOffset = ((FlatBufferBuilder)builder).createString(this.destinationKey);
        int requestHeaderOffset = this.getRequestHeader(builder, EMPTY_NS_NAME, null);
        CltOssCopyObjectRequest.startCltOssCopyObjectRequest(builder);
        CltOssCopyObjectRequest.addSourceBucketName(builder, sourceBucketOffset);
        CltOssCopyObjectRequest.addSourceKey(builder, sourceObjectOffset);
        CltOssCopyObjectRequest.addSourceVersionId(builder, sourceVersionIdOffset);
        CltOssCopyObjectRequest.addDestinationBucketName(builder, destinationBucketOffset);
        CltOssCopyObjectRequest.addDestinationKey(builder, destinationKeyOffset);
        CltOssCopyObjectRequest.addRequestHeader(builder, requestHeaderOffset);
        builder.finish(CltOssCopyObjectRequest.endCltOssCopyObjectRequest(builder));
        ByteBuffer buffer = builder.dataBuffer();
        return buffer;
    }
}

