/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.buffer;

import com.aliyun.emr.buffer.ByteBufferPool;
import com.aliyun.emr.buffer.ChunkBuffer;
import com.aliyun.emr.buffer.MultiChunkBuffer;
import com.aliyun.emr.buffer.SmartBuffer;
import java.nio.ByteBuffer;

public class SmartBufferFactory {
    public static void init(int defaultBufferSize) {
        FactoryInternal.INSTANCE.setDefaultBufferSize(defaultBufferSize);
    }

    public static ChunkBuffer makeChunk() {
        return FactoryInternal.INSTANCE.makeChunkBuffer();
    }

    public static void free(SmartBuffer smartBuffer) {
        FactoryInternal.INSTANCE.freeBuffer(smartBuffer);
    }

    public static SmartBuffer make(int desiredLength) {
        return FactoryInternal.INSTANCE.makeBuffer(desiredLength, false);
    }

    public static SmartBuffer makeDirect(int desiredLength) {
        return FactoryInternal.INSTANCE.makeBuffer(desiredLength, true);
    }

    public static void free(ByteBuffer byteBuffer) {
        FactoryInternal.INSTANCE.bufferPool.release(byteBuffer);
    }

    static enum FactoryInternal {
        INSTANCE;

        private int defaultBufferSize = -1;
        private ByteBufferPool bufferPool = new ByteBufferPool();

        synchronized void setDefaultBufferSize(int defaultBufferSize) {
            this.defaultBufferSize = defaultBufferSize;
        }

        ChunkBuffer makeChunkBuffer() {
            if (this.defaultBufferSize == -1) {
                throw new RuntimeException("defaultBufferSize not set yet!");
            }
            ByteBuffer buffer = this.bufferPool.get(this.defaultBufferSize);
            ChunkBuffer result = new ChunkBuffer(buffer);
            return result;
        }

        SmartBuffer makeBuffer(int desiredLength, boolean isDirect) {
            int buffersNum = desiredLength / this.defaultBufferSize;
            int bigSize = this.defaultBufferSize * (buffersNum += desiredLength % this.defaultBufferSize > 0 ? 1 : 0);
            ByteBuffer bigBuffer = null;
            bigBuffer = isDirect ? this.bufferPool.getDirect(bigSize) : this.bufferPool.get(bigSize);
            ChunkBuffer[] childBuffers = new ChunkBuffer[buffersNum];
            for (int idx = 0; idx < buffersNum; ++idx) {
                ByteBuffer tmpBuffer = bigBuffer.duplicate();
                tmpBuffer.position(idx * this.defaultBufferSize);
                tmpBuffer.limit(this.defaultBufferSize);
                childBuffers[idx] = new ChunkBuffer(tmpBuffer, false);
            }
            MultiChunkBuffer multiBuffer = new MultiChunkBuffer(bigBuffer, desiredLength, childBuffers);
            return multiBuffer;
        }

        void freeBuffer(SmartBuffer smartBuffer) {
            ByteBuffer buffer = smartBuffer.release();
            this.bufferPool.release(buffer);
        }
    }
}

