/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.auth;

import com.aliyun.emr.fs.auth.AliyunCredentials;
import com.aliyun.emr.fs.auth.AliyunCredentialsProvider;
import com.aliyun.emr.fs.auth.BasicCredentials;
import com.aliyun.emr.fs.auth.BasicSessionCredentials;
import com.aliyun.emr.fs.auth.CredentialInitializationException;
import com.aliyun.emr.shade.google_guava.base.Strings;
import com.aliyun.emr.utils.StringUtils;

public class EnvironmentVariableCredentialsProvider
implements AliyunCredentialsProvider {
    public static final String NAME = "com.aliyun.emr.fs.auth.EnvironmentVariableCredentialsProvider";
    private final AliyunCredentialsProvider.CredentialType type;

    public EnvironmentVariableCredentialsProvider(AliyunCredentialsProvider.CredentialType type) {
        this.type = type;
    }

    @Override
    public AliyunCredentials getCredentials() {
        String securityToken;
        String accessKeySecret;
        String accessKeyId;
        if (this.type == AliyunCredentialsProvider.CredentialType.OSS || this.type == AliyunCredentialsProvider.CredentialType.JFS) {
            accessKeyId = StringUtils.trim(System.getenv("ALIYUN_ACCESS_KEY_ID"));
            accessKeySecret = StringUtils.trim(System.getenv("ALIYUN_ACCESS_KEY_SECRET"));
            securityToken = StringUtils.trim(System.getenv("ALIYUN_SECURITY_TOKEN"));
        } else if (this.type == AliyunCredentialsProvider.CredentialType.OTS) {
            accessKeyId = StringUtils.trim(System.getenv("OTS_ACCESS_KEY_ID"));
            accessKeySecret = StringUtils.trim(System.getenv("OTS_ACCESS_KEY_SECRET"));
            securityToken = StringUtils.trim(System.getenv("OTS_SECURITY_TOKEN"));
        } else {
            throw new CredentialInitializationException("WARNING: wrong credential type: " + this.type.name());
        }
        if (Strings.isNullOrEmpty(accessKeyId) || Strings.isNullOrEmpty(accessKeySecret)) {
            throw new CredentialInitializationException("Unable to load ALIYUN credentials from environment variables (ALIYUN_ACCESS_KEY_ID) and (ALIYUN_ACCESS_KEY_SECRET)");
        }
        return Strings.isNullOrEmpty(securityToken) ? new BasicCredentials(accessKeyId, accessKeySecret) : new BasicSessionCredentials(accessKeyId, accessKeySecret, securityToken);
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

