/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.auth;

import com.aliyun.emr.fs.auth.AbstractSessionCredentialsProvider;
import com.aliyun.emr.fs.auth.AliyunCredentials;
import com.aliyun.emr.fs.auth.AliyunCredentialsProvider;
import com.aliyun.emr.fs.auth.MarshalledCredentialBinding;
import com.aliyun.emr.fs.auth.MarshalledCredentials;
import com.aliyun.emr.shade.google_guava.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;

public class MarshalledCredentialProvider
extends AbstractSessionCredentialsProvider {
    public static final String NAME = "com.aliyun.emr.fs.auth.MarshalledCredentialProvider";
    private final MarshalledCredentials credentials;
    private final MarshalledCredentials.CredentialTypeRequired typeRequired;
    private final String component;

    public MarshalledCredentialProvider(String component, URI uri, Configuration conf, MarshalledCredentials credentials, MarshalledCredentials.CredentialTypeRequired typeRequired) throws IOException {
        super(Preconditions.checkNotNull(uri, "No filesystem URI"), conf, AliyunCredentialsProvider.CredentialType.OSS);
        this.component = component;
        this.typeRequired = typeRequired;
        this.credentials = Preconditions.checkNotNull(credentials);
    }

    @Override
    protected AliyunCredentials createCredentials(Configuration config) throws IOException {
        return MarshalledCredentialBinding.toAliyunCredentials(this.credentials, this.typeRequired, this.component);
    }
}

