/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.ossnative;

import bigboot.protocol.type.FileletStatusList;
import bigboot.protocol.type.InodeStatus;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.alibaba.jboot.google.flatbuffers.Table;
import com.alibaba.jfs.CredentialContext;
import com.alibaba.jfs.JindoRequestPath;
import com.aliyun.emr.fs.internal.ossnative.OssFileStatus;
import com.aliyun.emr.fs.internal.ossnative.OssOpContext;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssListStatusOp {
    static final Logger LOG = LoggerFactory.getLogger(OssListStatusOp.class);
    private final OssOpContext context;
    private final FileSystem fs;
    private final CredentialContext ossContext;

    public OssListStatusOp(OssOpContext context, FileSystem fs, CredentialContext ossContext) {
        this.context = context;
        this.fs = fs;
        this.ossContext = ossContext;
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        return this.listStatus(f, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStatus[] listStatus(Path f, boolean recursive, boolean skipDir, boolean isSummary) throws IOException {
        Table statusList = null;
        try {
            statusList = this.context.ossFileletSystem.listStatus(new JindoRequestPath(f.toString(), this.ossContext), recursive, isSummary);
            ArrayList<OssFileStatus> fileStatuses = new ArrayList<OssFileStatus>();
            for (int i = 0; i < ((FileletStatusList)statusList).filesLength(); ++i) {
                InodeStatus inodeStatus = ((FileletStatusList)statusList).files(i).inodeAsInodeStatus();
                LOG.debug("path " + inodeStatus.fileName());
                if (inodeStatus.fileName().endsWith("_$folder$") || skipDir && 0 == inodeStatus.fileType()) continue;
                OssFileStatus fileStatus = new OssFileStatus(((FileletStatusList)statusList).files(i), this.fs.getConf());
                fileStatuses.add(fileStatus);
            }
            FileStatus[] fileStatusArray = fileStatuses.toArray(new FileStatus[0]);
            return fileStatusArray;
        }
        finally {
            if (statusList != null) {
                JbootBufferFactory.returnBuffer(statusList.getByteBuffer());
            }
        }
    }
}

