/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.auth;

import com.aliyun.emr.fs.s3.Constants;
import com.aliyun.emr.fs.s3.auth.AuthUtils;
import com.aliyun.emr.fs.s3.auth.BasicCredentials;
import com.aliyun.emr.fs.s3.auth.BasicSessionCredentials;
import com.aliyun.emr.fs.s3.auth.MarshalledCredentials;
import com.aliyun.emr.fs.s3.auth.NoAuthWithException;
import com.aliyun.emr.fs.s3.auth.NoCredentialsException;
import com.aliyun.emr.fs.s3.auth.S3Credentials;
import com.aliyun.emr.fs.s3.internal.s3.ProviderUtils;
import com.aliyun.emr.shade.google_guava.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MarshalledCredentialBinding {
    private static final Logger LOG = LoggerFactory.getLogger(MarshalledCredentialBinding.class);
    @VisibleForTesting
    public static final String NO_CREDENTIALS = "No credentials";

    private MarshalledCredentialBinding() {
    }

    public static MarshalledCredentials fromEnvironment(Map<String, String> env) {
        return new MarshalledCredentials(MarshalledCredentialBinding.nullToEmptyString(env.get("ACCESS_KEY_ID")), MarshalledCredentialBinding.nullToEmptyString(env.get("ACCESS_KEY_SECRET")), MarshalledCredentialBinding.nullToEmptyString(env.get("SECURITY_TOKEN")));
    }

    private static String nullToEmptyString(String src) {
        return src == null ? "" : src;
    }

    public static MarshalledCredentials fromFileSystem(URI uri, Configuration conf, Class<? extends FileSystem> fileSystemClass) throws IOException {
        String bucket = uri != null ? uri.getHost() : "";
        Configuration leanConf = ProviderUtils.excludeIncompatibleCredentialProviders(conf, fileSystemClass);
        return new MarshalledCredentials(AuthUtils.lookupS3Password(bucket, leanConf, "fs.jfs.cache.s3.accessKeyId", Constants.DEPRECATED_S3_ACCESS_KEY_ID), AuthUtils.lookupS3Password(bucket, leanConf, "fs.jfs.cache.s3.accessKeySecret", Constants.DEPRECATED_S3_ACCESS_KEY_SECRET), AuthUtils.lookupS3Password(bucket, leanConf, "fs.jfs.cache.s3.securityToken", Constants.DEPRECATED_S3_SECURITY_TOKEN));
    }

    public static S3Credentials toCredentials(MarshalledCredentials marshalled, MarshalledCredentials.CredentialTypeRequired typeRequired, String component) throws NoCredentialsException {
        if (marshalled.isEmpty()) {
            throw new NoCredentialsException(component, NO_CREDENTIALS);
        }
        if (!marshalled.isValid(typeRequired)) {
            throw new NoAuthWithException(component + ":" + marshalled.buildInvalidCredentialsError(typeRequired));
        }
        String accessKey = marshalled.getAccessKeyId();
        String secretKey = marshalled.getAccessKeySecret();
        if (marshalled.hasSecurityToken()) {
            return new BasicSessionCredentials(accessKey, secretKey, marshalled.getSecurityToken());
        }
        return new BasicCredentials(accessKey, secretKey);
    }
}

